/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import quek.undergarden.block.tileentity.DepthrockBedTE;
import quek.undergarden.registry.UGTileEntities;

public class DepthrockBedRender
extends TileEntityRenderer<DepthrockBedTE> {
    private final ModelRenderer headPiece = new ModelRenderer(64, 64, 0, 0);
    private final ModelRenderer footPiece;

    public DepthrockBedRender(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
        this.headPiece.func_228301_a_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 9.0f, 0.0f);
        this.footPiece = new ModelRenderer(64, 64, 0, 25);
        this.footPiece.func_228301_a_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 9.0f, 0.0f);
    }

    public void render(DepthrockBedTE bed, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int combinedLight, int combinedOverlay) {
        World world = bed.func_145831_w();
        if (world != null) {
            BlockState blockstate = bed.func_195044_w();
            TileEntityMerger.ICallbackWrapper icallbackwrapper = TileEntityMerger.func_226924_a_((TileEntityType)((TileEntityType)UGTileEntities.DEPTHROCK_BED.get()), BedBlock::func_226863_i_, BedBlock::func_226862_h_, (DirectionProperty)ChestBlock.field_176459_a, (BlockState)blockstate, (IWorld)world, (BlockPos)bed.func_174877_v(), (iWorld, pos) -> false);
            int i = ((Int2IntFunction)icallbackwrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).get(combinedLight);
            this.renderPiece(matrixStack, renderTypeBuffer, blockstate.func_177229_b((Property)BedBlock.field_176472_a) == BedPart.HEAD, (Direction)blockstate.func_177229_b((Property)BedBlock.field_185512_D), i, combinedOverlay, false);
        } else {
            this.renderPiece(matrixStack, renderTypeBuffer, true, Direction.SOUTH, combinedLight, combinedOverlay, false);
            this.renderPiece(matrixStack, renderTypeBuffer, false, Direction.SOUTH, combinedLight, combinedOverlay, true);
        }
    }

    private void renderPiece(MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, boolean isBedHead, Direction direction, int combinedLight, int combinedOverlay, boolean isBedFoot) {
        this.headPiece.field_78806_j = isBedHead;
        this.footPiece.field_78806_j = !isBedHead;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.5625, isBedFoot ? -1.0 : 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f + direction.func_185119_l()));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        IVertexBuilder ivertexbuilder = renderTypeBuffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("undergarden", "textures/block/depthrock_bed.png")));
        this.headPiece.func_228308_a_(matrixStack, ivertexbuilder, combinedLight, combinedOverlay);
        this.footPiece.func_228308_a_(matrixStack, ivertexbuilder, combinedLight, combinedOverlay);
        matrixStack.func_227865_b_();
    }
}

