/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SpreadableSnowyDirtBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.lighting.LightEngine;
import net.minecraft.world.server.ServerWorld;
import quek.undergarden.registry.UGBlocks;

public class UGGrassBlock
extends SpreadableSnowyDirtBlock {
    public UGGrassBlock(AbstractBlock.Properties builder) {
        super(builder);
    }

    private static boolean isSnowyConditions(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == Blocks.field_150433_aE && (Integer)blockstate.func_177229_b((Property)SnowBlock.field_176315_a) == 1) {
            return true;
        }
        int i = LightEngine.func_215613_a((IBlockReader)world, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.func_200016_a((IBlockReader)world, blockpos));
        return i < world.func_201572_C();
    }

    private static boolean isSnowyAndNotUnderwater(BlockState state, IWorldReader world, BlockPos pos) {
        BlockPos blockpos = pos.func_177984_a();
        return UGGrassBlock.isSnowyConditions(state, world, pos) && !world.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!UGGrassBlock.isSnowyConditions(state, (IWorldReader)worldIn, pos)) {
            if (!worldIn.isAreaLoaded(pos, 3)) {
                return;
            }
            worldIn.func_175656_a(pos, ((Block)UGBlocks.DEEPSOIL.get()).func_176223_P());
        } else {
            BlockState blockstate = this.func_176223_P();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockpos = pos.func_177982_a(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                if (!worldIn.func_180495_p(blockpos).func_203425_a((Block)UGBlocks.DEEPSOIL.get()) || !UGGrassBlock.isSnowyAndNotUnderwater(blockstate, (IWorldReader)worldIn, blockpos)) continue;
                worldIn.func_175656_a(blockpos, (BlockState)blockstate.func_206870_a((Property)field_196382_a, (Comparable)Boolean.valueOf(worldIn.func_180495_p(blockpos.func_177984_a()).func_203425_a(Blocks.field_150433_aE))));
            }
        }
    }
}

