/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.data.GlobalVariables;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.EndPortalFrameBlock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockFunctions {
    public static Boolean isSpecificBlock(Block specificblock, Block tocheckblock) {
        if (specificblock == null || tocheckblock == null) {
            return false;
        }
        if (specificblock.equals(tocheckblock)) {
            return true;
        }
        return false;
    }

    public static Boolean isSpecificBlock(Block specificblock, ItemStack tocheckitemstack) {
        if (tocheckitemstack == null) {
            return false;
        }
        Item tocheckitem = tocheckitemstack.func_77973_b();
        if (tocheckitem == null) {
            return false;
        }
        Block tocheckblock = Block.func_149634_a((Item)tocheckitem);
        return BlockFunctions.isSpecificBlock(specificblock, tocheckblock);
    }

    public static Boolean isSpecificBlock(Block specificblock, World world, BlockPos pos) {
        Block tocheckblock = world.func_180495_p(pos).func_177230_c();
        return BlockFunctions.isSpecificBlock(specificblock, tocheckblock);
    }

    public static void dropBlock(World world, BlockPos pos) {
        BlockState blockstate = world.func_180495_p(pos);
        TileEntity tileentity = blockstate.hasTileEntity() ? world.func_175625_s(pos) : null;
        Block.func_220059_a((BlockState)blockstate, (IWorld)world, (BlockPos)pos, (TileEntity)tileentity);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    public static Boolean isOneOfBlocks(List<Block> blocks, Block tocheckblock) {
        if (blocks.size() < 1) {
            return false;
        }
        for (Block specificblock : blocks) {
            if (!BlockFunctions.isSpecificBlock(specificblock, tocheckblock).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Boolean isOneOfBlocks(List<Block> blocks, ItemStack tocheckitemstack) {
        if (tocheckitemstack == null) {
            return false;
        }
        Item tocheckitem = tocheckitemstack.func_77973_b();
        if (tocheckitem == null) {
            return false;
        }
        Block tocheckblock = Block.func_149634_a((Item)tocheckitem);
        return BlockFunctions.isOneOfBlocks(blocks, tocheckblock);
    }

    public static Boolean isOneOfBlocks(List<Block> blocks, World world, BlockPos pos) {
        Block tocheckblock = world.func_180495_p(pos).func_177230_c();
        return BlockFunctions.isOneOfBlocks(blocks, tocheckblock);
    }

    public static boolean isGrowBlock(Block block) {
        BlockState state = block.func_176223_P();
        if (state.func_177230_c().func_203417_a((ITag)BlockTags.field_219749_R)) {
            return true;
        }
        return GlobalVariables.growblocks.contains(block);
    }

    public static boolean isStoneTypeBlock(Block block) {
        return GlobalVariables.stoneblocks.contains(block);
    }

    public static Boolean isFilledPortalFrame(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        if (!block.equals(Blocks.field_150378_br)) {
            return false;
        }
        return (Boolean)blockstate.func_177229_b((Property)EndPortalFrameBlock.field_176507_b);
    }

    public static String blockToReadableString(Block block, int amount) {
        String blockstring = "";
        String[] blockspl = block.func_149739_a().replace("block.", "").split("\\.");
        blockstring = blockspl.length > 1 ? blockspl[1] : blockspl[0];
        blockstring = blockstring.replace("_", " ");
        if (amount > 1) {
            blockstring = blockstring + "s";
        }
        return blockstring;
    }

    public static String blockToReadableString(Block block) {
        return BlockFunctions.blockToReadableString(block, 1);
    }
}

