/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.events;

import com.natamus.collective.check.RegisterMod;
import com.natamus.collective.config.ConfigHandler;
import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.EntityFunctions;
import com.natamus.collective.functions.SpawnEntityFunctions;
import com.natamus.collective.functions.WorldFunctions;
import com.natamus.collective.objects.SAMObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CollectiveEvents {
    public static HashMap<ServerWorld, List<Entity>> entitiesToSpawn = new HashMap();
    public static HashMap<ServerWorld, HashMap<Entity, Entity>> entitiesToRide = new HashMap();

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getWorld());
        if (world == null) {
            return;
        }
        ServerWorld serverworld = (ServerWorld)world;
        entitiesToSpawn.put(serverworld, new ArrayList());
        entitiesToRide.put(serverworld, new HashMap());
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        World world = e.world;
        if (world.field_72995_K || !e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        ServerWorld serverworld = (ServerWorld)world;
        if (entitiesToSpawn.get(serverworld).size() > 0) {
            Entity tospawn = entitiesToSpawn.get(serverworld).get(0);
            serverworld.func_242417_l(tospawn);
            if (entitiesToRide.get(world).containsKey(tospawn)) {
                Entity rider = entitiesToRide.get(world).get(tospawn);
                rider.func_184220_m(tospawn);
                entitiesToRide.get(world).remove(tospawn);
            }
            entitiesToSpawn.get(world).remove(0);
        }
    }

    @SubscribeEvent
    public void onMobSpawnerSpawn(LivingSpawnEvent.SpecialSpawn e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getWorld());
        if (world == null) {
            return;
        }
        if (e.getSpawner() != null && !e.isCanceled()) {
            e.getEntity().func_184211_a("collective.spawner");
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (RegisterMod.shouldDoCheck && entity instanceof PlayerEntity) {
            RegisterMod.joinWorldProcess(world, (PlayerEntity)entity);
        }
        if (e.isCanceled()) {
            return;
        }
        if (GlobalVariables.samobjects.isEmpty()) {
            return;
        }
        Set tags = entity.func_184216_O();
        if (tags.contains("collective.checked")) {
            return;
        }
        entity.func_184211_a("collective.checked");
        EntityType entitytype = entity.func_200600_R();
        if (entitytype == null || !GlobalVariables.activesams.contains(entitytype)) {
            return;
        }
        boolean isspawner = tags.contains("collective.spawner");
        ArrayList<SAMObject> possibles = new ArrayList<SAMObject>();
        for (SAMObject samobject : GlobalVariables.samobjects) {
            if (samobject == null || samobject.fromtype == null || !samobject.fromtype.equals((Object)entitytype) || samobject.spawner && !isspawner || !samobject.spawner && isspawner) continue;
            possibles.add(samobject);
        }
        int size = possibles.size();
        if (size == 0) {
            return;
        }
        for (SAMObject sam : possibles) {
            LivingEntity le;
            double num = GlobalVariables.random.nextDouble();
            if (num > sam.chance) continue;
            Vector3d evec = entity.func_213303_ch();
            if (sam.surface && !BlockPosFunctions.isOnSurface(world, evec).booleanValue()) continue;
            Entity to = sam.totype.func_200721_a(world);
            to.func_70029_a(world);
            to.func_70107_b(evec.field_72450_a, evec.field_72448_b, evec.field_72449_c);
            boolean ignoremainhand = false;
            if (sam.helditem != null && to instanceof LivingEntity && !(le = (LivingEntity)to).func_184614_ca().func_77973_b().equals(sam.helditem)) {
                le.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)sam.helditem, 1));
                ignoremainhand = true;
            }
            boolean ride = false;
            if (EntityFunctions.isHorse(to).booleanValue() && sam.rideable) {
                AbstractHorseEntity ah = (AbstractHorseEntity)to;
                ah.func_110234_j(true);
                to = ah;
                ride = true;
            } else if (((Boolean)ConfigHandler.COLLECTIVE.transferItemsBetweenReplacedEntities.get()).booleanValue()) {
                EntityFunctions.transferItemsBetweenEntities(entity, to, ignoremainhand);
            }
            if (!(world instanceof ServerWorld)) {
                return;
            }
            ServerWorld serverworld = (ServerWorld)world;
            if (ride) {
                SpawnEntityFunctions.startRidingEntityOnNextTick(serverworld, to, entity);
            } else {
                e.setCanceled(true);
            }
            to.func_184211_a("collective.checked");
            SpawnEntityFunctions.spawnEntityOnNextTick(serverworld, to);
            break;
        }
    }
}

