/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.client.renderers.entities.PicklePlayer;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class PicklePacket {
    private UUID playerID;
    private boolean on;

    public PicklePacket(UUID appliesTo, boolean on) {
        this.playerID = appliesTo;
        this.on = on;
    }

    public static void buffer(PicklePacket pkt, PacketBuffer buf) {
        buf.writeBoolean(pkt.on);
        if (pkt.playerID != null) {
            buf.func_179252_a(pkt.playerID);
        }
    }

    public PicklePacket(PacketBuffer buf) {
        this.on = buf.readBoolean();
        if (buf.isReadable()) {
            this.playerID = buf.func_179253_g();
        }
    }

    public static void handler(PicklePacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> PicklePlayer.PickleData.set(msg.playerID, msg.on));
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                UUID id = player.func_146103_bH().getId();
                if (PicklePlayer.PickleData.isDev(id)) {
                    PicklePlayer.PickleData.set(id, msg.on);
                    msg.playerID = id;
                    for (ServerPlayerEntity p : player.func_184102_h().func_184103_al().func_181057_v()) {
                        if (p == player) continue;
                        NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)msg);
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

