/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.supplementaries.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.client.Materials;
import net.mehvahdjukaar.supplementaries.client.renderers.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.client.renderers.LOD;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class BlackboardBlockTileRenderer
extends TileEntityRenderer<BlackboardBlockTile> {
    private final Minecraft MC = Minecraft.func_71410_x();
    public final int WIDTH = 6;

    public BlackboardBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(BlackboardBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ClientPlayerEntity player;
        BlockRayTraceResult blockHit;
        BlockPos pos;
        Direction dir = tile.getDirection();
        float yaw = -dir.func_185119_l();
        ActiveRenderInfo camera = this.field_228858_b_.field_217666_g;
        Vector3d cameraPos = camera.func_216785_c();
        if (LOD.isOutOfFocus(cameraPos, pos = tile.func_174877_v(), yaw, 0.0f, dir, 0.375f)) {
            return;
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
        matrixStackIn.func_227863_a_(Const.rot(dir));
        matrixStackIn.func_227863_a_(Const.XN90);
        matrixStackIn.func_227861_a_(-0.5, -0.5, -0.1875);
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        RayTraceResult hit = this.MC.field_71476_x;
        if (hit != null && hit.func_216346_c() == RayTraceResult.Type.BLOCK && (blockHit = (BlockRayTraceResult)hit).func_216350_a().equals((Object)pos) && tile.getDirection() == blockHit.func_216354_b() && (player = this.MC.field_71439_g) != null && BlackboardBlock.getStackChalkColor(player.func_184614_ca()) != null) {
            Pair<Integer, Integer> pair = BlackboardBlock.getHitSubPixel(blockHit);
            float p = 0.0625f;
            float x = (float)((Integer)pair.getFirst()).intValue() * p;
            float y = (float)((Integer)pair.getSecond()).intValue() * p;
            IVertexBuilder builder2 = Materials.BLACKBOARD_GRID.func_229311_a_(bufferIn, RenderType::func_228638_b_);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)x, (double)(1.0f - y - p), 0.001);
            RendererUtil.addQuadSide(builder2, matrixStackIn, 0.0f, 0.0f, 0.0f, p, p, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f, Materials.BLACKBOARD_GRID.func_229314_c_());
            matrixStackIn.func_227865_b_();
        }
        IVertexBuilder builder = bufferIn.getBuffer(BlackboardTextureManager.INSTANCE.getRenderType(tile));
        RendererUtil.addQuadSide(builder, matrixStackIn, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
        matrixStackIn.func_227865_b_();
    }
}

