/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.gui;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.mehvahdjukaar.supplementaries.client.gui.MultiLineEditBoxWidget;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.StatueBlockTileRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.UsernameCache;
import org.jetbrains.annotations.Nullable;

public class PlayerSuggestionBoxWidget
extends MultiLineEditBoxWidget {
    private static final ITextComponent EMPTY_SEARCH = new TranslationTextComponent("gui.supplementaries.present.send").func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC);
    private final List<SimplePlayerEntry> allPlayers = new ArrayList<SimplePlayerEntry>();
    private final List<SimplePlayerEntry> filtered = new ArrayList<SimplePlayerEntry>();
    private SimplePlayerEntry selectedPlayer = null;
    @Nullable
    private String suggestion;
    private String fullSuggestion = "";
    private Consumer<PlayerSuggestionBoxWidget> onClick;

    public PlayerSuggestionBoxWidget(Minecraft mc, int x, int y, int width, int height) {
        super(mc, x, y, width, height);
        Collection onlinePlayers = mc.field_71439_g.field_71174_a.func_244695_f();
        for (UUID uuid : onlinePlayers) {
            NetworkPlayerInfo playerinfo = mc.field_71439_g.field_71174_a.func_175102_a(uuid);
            if (playerinfo == null) continue;
            this.allPlayers.add(new SimplePlayerEntry(playerinfo));
        }
        Map offlinePlayers = UsernameCache.getMap();
        for (Map.Entry entry : offlinePlayers.entrySet()) {
            if (onlinePlayers.contains(entry.getKey())) continue;
            this.allPlayers.add(new SimplePlayerEntry((UUID)entry.getKey(), (String)entry.getValue()));
        }
        this.filtered.addAll(this.allPlayers);
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        if (this.field_230694_p_) {
            if (this.canConsumeInput() && this.suggestion != null) {
                int x = this.field_230690_l_;
                MultiLineEditBoxWidget.DisplayCache cache = this.getDisplayCache();
                if (cache.lines.length > 0) {
                    x += this.font.func_78256_a(cache.lines[0].contents);
                }
                this.font.func_238421_b_(poseStack, this.suggestion, (float)x, (float)this.field_230691_m_, -8355712);
            }
            if (this.getText().isEmpty()) {
                this.font.func_243248_b(poseStack, EMPTY_SEARCH, (float)this.field_230690_l_, (float)this.field_230691_m_, 0);
            } else if (this.selectedPlayer != null) {
                this.selectedPlayer.render(poseStack, this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, partialTicks);
            }
        }
    }

    @Override
    public boolean func_231046_a_(int key, int p_94133_, int p_94134_) {
        if (key == 258 && this.canConsumeInput()) {
            if (!this.fullSuggestion.isEmpty()) {
                this.setText(this.fullSuggestion);
                this.moveCursorToEnd();
                this.clearDisplayCache();
            }
            return true;
        }
        return super.func_231046_a_(key, p_94133_, p_94134_);
    }

    @Override
    public void onValueChanged() {
        this.updateFilteredEntries();
        String newValue = this.getText();
        this.selectedPlayer = null;
        String suggestion = "";
        this.fullSuggestion = "";
        if (!newValue.isEmpty()) {
            for (SimplePlayerEntry entry : this.filtered) {
                String name = entry.getName();
                if (this.fullSuggestion.isEmpty()) {
                    this.fullSuggestion = name;
                    suggestion = name.substring(newValue.length());
                }
                if (!name.equalsIgnoreCase(newValue)) continue;
                this.selectedPlayer = entry;
                break;
            }
        }
        this.setSuggestion(suggestion);
    }

    private void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    public void setState(boolean hasItem, boolean packed) {
        super.setState(hasItem, packed);
        this.filtered.clear();
        if (!packed && hasItem) {
            this.func_230996_d_(true);
            this.filtered.addAll(this.allPlayers);
        }
    }

    private void updateFilteredEntries() {
        String filter = this.getText();
        filter = filter == null ? "" : filter.toLowerCase();
        this.filtered.clear();
        String finalFilter = filter;
        this.filtered.addAll(this.allPlayers.stream().filter(s -> s.getName().toLowerCase().startsWith(finalFilter)).collect(Collectors.toList()));
    }

    public void addPlayer(NetworkPlayerInfo info) {
        this.allPlayers.removeIf(simplePlayerEntry -> simplePlayerEntry.getId().equals(info.func_178845_a().getId()));
        this.allPlayers.add(new SimplePlayerEntry(info));
        this.updateFilteredEntries();
        this.onValueChanged();
    }

    public void removePlayer(UUID id) {
        for (SimplePlayerEntry simplePlayerEntry : this.allPlayers) {
            if (!simplePlayerEntry.getId().equals(id)) continue;
            simplePlayerEntry.setOnline(false);
            return;
        }
    }

    public static class SimplePlayerEntry {
        private static final int SKIN_SIZE = 8;
        private final Supplier<ResourceLocation> skinGetter;
        private GameProfile profile;
        private boolean isOnline;

        public SimplePlayerEntry(NetworkPlayerInfo playerInfo) {
            this.profile = playerInfo.func_178845_a();
            this.skinGetter = () -> ((NetworkPlayerInfo)playerInfo).func_178837_g();
            this.isOnline = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SimplePlayerEntry(UUID id, String lastName) {
            GameProfile profile = new GameProfile(id, lastName);
            this.skinGetter = () -> StatueBlockTileRenderer.getPlayerSkin(this.profile);
            if (!profile.isComplete() || !profile.getProperties().containsKey((Object)"textures")) {
                SimplePlayerEntry simplePlayerEntry = this;
                synchronized (simplePlayerEntry) {
                    this.profile = profile;
                }
                SkullTileEntity.func_174884_b((GameProfile)this.profile);
            }
            this.isOnline = false;
        }

        public void setOnline(boolean online) {
            this.isOnline = online;
        }

        public UUID getId() {
            return this.profile.getId();
        }

        public String getName() {
            return this.profile.getName();
        }

        public void render(MatrixStack poseStack, int x, int y, int width, int height, float pPartialTicks) {
            int i = x + width - 4;
            float c = this.isOnline ? 1.0f : 0.5f;
            RenderSystem.color4f((float)1.0f, (float)c, (float)c, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.skinGetter.get());
            AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)i, (int)y, (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.enableBlend();
            AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)i, (int)y, (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
        }
    }
}

