/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Random;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.blocks.SconceWallBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class SconceLeverBlock
extends SconceWallBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public SconceLeverBlock(AbstractBlock.Properties properties, Supplier<BasicParticleType> particleData) {
        super(properties, particleData);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public void onChange(BlockState state, IWorld world, BlockPos pos) {
        if (world instanceof World) {
            this.updateNeighbors(state, (World)world, pos);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ActionResultType result = super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        if (result.func_226246_a_()) {
            this.updateNeighbors(state, worldIn, pos);
            return result;
        }
        if (worldIn.field_72995_K) {
            state.func_235896_a_((Property)POWERED);
            return ActionResultType.SUCCESS;
        }
        BlockState blockstate = this.setPowered(state, worldIn, pos);
        float f = (Boolean)blockstate.func_177229_b((Property)POWERED) != false ? 0.6f : 0.5f;
        worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        return ActionResultType.CONSUME;
    }

    public BlockState setPowered(BlockState state, World world, BlockPos pos) {
        state = (BlockState)state.func_235896_a_((Property)POWERED);
        world.func_180501_a(pos, state, 3);
        this.updateNeighbors(state, world, pos);
        return state;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.func_203425_a(newState.func_177230_c())) {
            if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
                this.updateNeighbors(state, worldIn, pos);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) ^ (Boolean)blockState.func_177229_b((Property)LIT) == false ? 15 : 0;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.func_177229_b((Property)POWERED) ^ (Boolean)blockState.func_177229_b((Property)LIT) == false && SconceLeverBlock.getFacing(blockState) == side ? 15 : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    private void updateNeighbors(BlockState state, World world, BlockPos pos) {
        world.func_195593_d(pos, (Block)this);
        world.func_195593_d(pos.func_177972_a(SconceLeverBlock.getFacing(state).func_176734_d()), (Block)this);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{POWERED});
    }

    protected static Direction getFacing(BlockState state) {
        return (Direction)state.func_177229_b((Property)FACING);
    }

    @Override
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!((Boolean)stateIn.func_177229_b((Property)POWERED)).booleanValue()) {
            super.func_180655_c(stateIn, worldIn, pos, rand);
        } else if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            Direction direction = (Direction)stateIn.func_177229_b((Property)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.65;
            double d2 = (double)pos.func_177952_p() + 0.5;
            Direction direction1 = direction.func_176734_d();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.125 * (double)direction1.func_82601_c(), d1 + 0.15, d2 + 0.125 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)this.particleData.get(), d0 + 0.125 * (double)direction1.func_82601_c(), d1 + 0.15, d2 + 0.125 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0);
        }
    }
}

