/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import com.endertech.minecraft.mods.adhooks.motion.MotionController;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class ClientPlayerTarget
extends EntityTarget<AbstractClientPlayerEntity> {
    private static final Optional<Field> jumpTicks;
    public float swingStrength = 0.15f * MotionController.mainFactor;
    protected Vect3d durableMotion = Vect3d.ZERO;
    protected int duration;
    protected boolean swinging;

    public ClientPlayerTarget(AbstractClientPlayerEntity target, double damping) {
        super(target, damping);
    }

    @Override
    public boolean exists() {
        return super.exists() || ((AbstractClientPlayerEntity)this.target).func_70089_S() && this.durableMotion.notZero();
    }

    public void setDurableMotion(Vect3d motion, int duration) {
        this.durableMotion = motion;
        this.duration = duration;
    }

    public int getJumpTicks() {
        if (jumpTicks.isPresent()) {
            try {
                return jumpTicks.get().getInt(this.target);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public void updateSwinging() {
        this.swinging = !((AbstractClientPlayerEntity)this.target).func_233570_aj_() && !((AbstractClientPlayerEntity)this.target).func_70090_H() && this.getJumpTicks() == 0 && (!((AbstractClientPlayerEntity)this.target).func_184812_l_() || !((AbstractClientPlayerEntity)this.target).field_71075_bZ.field_75100_b);
    }

    protected Vect3d getSwingMotion() {
        Vect3d motion = ForgeEntity.getMotion((Entity)this.target);
        Vect3d movement = Vect3d.from((double)((AbstractClientPlayerEntity)this.target).field_70702_br, (double)0.0, (double)((AbstractClientPlayerEntity)this.target).field_191988_bg).rotateAroundY(-((AbstractClientPlayerEntity)this.target).field_70177_z);
        if (Vect3d.scalarMult((Vect3d)movement, (Vect3d)motion) < 0.0) {
            return Vect3d.ZERO;
        }
        return movement.projectOn(motion).scale((double)this.swingStrength);
    }

    @Override
    public void applyMotions() {
        if (this.swinging) {
            this.addDampedMotion(this.getSwingMotion());
        }
        this.swinging = false;
        if (this.duration > 0) {
            --this.duration;
            this.addDampedMotion(this.durableMotion);
        } else {
            this.durableMotion = Vect3d.ZERO;
        }
        super.applyMotions();
    }

    static {
        Field field = null;
        try {
            field = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"field_70773_bE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        jumpTicks = Optional.ofNullable(field);
    }
}

