/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.units.UnitProperties;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;

public class Rope
implements IHaveConfig,
INBTSerializable<Rope> {
    public static final IntBounds LENGTH_BOUNDS = new IntBounds(Integer.valueOf(1), Integer.valueOf(80));
    public static final FloatBounds WIDTH_BOUNDS = new FloatBounds(Float.valueOf(1.0f), Float.valueOf(10.0f));
    public static final FloatBounds ELASTICITY_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.95f));
    public static final FloatBounds BOUNCE_REDUCTION_BOUNDS = new FloatBounds(Float.valueOf(0.1f), Float.valueOf(0.3f));
    public final int segmentsAmount = 16;
    public final ColorARGB color;
    protected int maxLength;
    protected float width;
    protected float elasticity;
    protected final UnitConfig config;

    public Rope(UnitConfig config, Properties<?> props) {
        this.config = config;
        String category = this.getClassCategory();
        this.maxLength = UnitConfig.getInt((UnitConfig)config, (String)category, (String)"maxLength", (int)props.maxLength, (IntBounds)LENGTH_BOUNDS, (String)"Defines the maximal rope length.");
        this.width = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"width", (float)props.width, (FloatBounds)WIDTH_BOUNDS, (String)"Defines the rope width.");
        this.elasticity = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"elasticity", (float)props.elasticity, (FloatBounds)ELASTICITY_BOUNDS, (String)"Defines how elastic the rope is.");
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)category, (String)"color", (ColorARGB)props.color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public float getWidth() {
        return this.width;
    }

    public float getElasticity() {
        return this.elasticity;
    }

    public float getBounceReduction() {
        return BOUNCE_REDUCTION_BOUNDS.approxDown(this.getElasticity()).floatValue();
    }

    public float getTensionForce(float ropeLength, float realDistance) {
        float diff = realDistance - ropeLength;
        float ropeStrength = this.getRopeStrength();
        return diff * ropeStrength;
    }

    public float getRopeStrength() {
        return CommonMath.Approx.down((float)this.getElasticity(), (FloatBounds)ELASTICITY_BOUNDS);
    }

    public UnitConfig getConfig() {
        return this.config;
    }

    public float getMinLength(@Nullable LivingEntity shooter, @Nullable Entity target) {
        float shooterSize = shooter != null ? Math.max(shooter.func_213311_cf(), shooter.func_213302_cg()) : 0.0f;
        float targetSize = target != null ? Math.max(target.func_213311_cf(), target.func_213302_cg()) : 0.0f;
        float minLength = shooterSize + targetSize;
        minLength = (float)((double)minLength / 2.0);
        return minLength;
    }

    public FloatBounds getLengthBounds(@Nullable LivingEntity shooter, @Nullable Entity target) {
        float minLength = this.getMinLength(shooter, target);
        return FloatBounds.from((Float)Float.valueOf(minLength), (Float)Float.valueOf(this.getMaxLength()));
    }

    public Rope readFrom(CompoundNBT compound) {
        this.maxLength = compound.func_74762_e("maxLength");
        this.width = compound.func_74760_g("width");
        this.elasticity = compound.func_74760_g("elasticity");
        return this;
    }

    public CompoundNBT writeTo(CompoundNBT compound) {
        compound.func_74768_a("maxLength", this.maxLength);
        compound.func_74776_a("width", this.width);
        compound.func_74776_a("elasticity", this.elasticity);
        return compound;
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public int maxLength;
        public float width;
        public float elasticity;
        public ColorARGB color = ColorARGB.DEFAULT;

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public static Properties<?> of() {
            return new Properties<Properties>(Properties.class);
        }

        public T maxLength(int value) {
            this.maxLength = value;
            return (T)((Object)((Properties)this.self));
        }

        public T width(float value) {
            this.width = value;
            return (T)((Object)((Properties)this.self));
        }

        public T elasticity(float value) {
            this.elasticity = value;
            return (T)((Object)((Properties)this.self));
        }

        public T color(int argb) {
            this.color = ColorARGB.from((int)argb);
            return (T)((Object)((Properties)this.self));
        }
    }
}

