/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.items.DamageableItem;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitProperties;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.client.ControlBindings;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.network.MakeShotMsg;
import com.endertech.minecraft.mods.adhooks.network.WatchedBoolMsg;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Launcher
extends DamageableItem
implements INBTSerializable<Launcher> {
    public static final String TAG_HOOKSHOT_ID = "hookShotId";
    public static final int DAMAGE_ON_SHOT = 1;
    public final HookType hookType;
    protected float reelingSpeed;
    protected float launchVelocity;
    protected float jumpBoostStrength;
    protected float tarzanJumpStrength;
    protected float shooterWeightFactor;
    protected final Map<Hand, Cooldowns> cooldownsByHand = new EnumMap<Hand, Cooldowns>(Hand.class);
    protected final Map<Hand, WatchedStates> watchedStatesByHand = new EnumMap<Hand, WatchedStates>(Hand.class);

    public Launcher(ForgeMod mod, UnitConfig config, HookType hookType, Properties<?> props) {
        super(mod, config, hookType.getName() + "_launcher", new Item.Properties().func_200916_a(ItemGroup.field_78040_i), props.durability, UnitId.from((String)"string"));
        this.hookType = hookType;
        String category = this.getUnitCategory();
        this.launchVelocity = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"launchVelocity", (float)props.launchVelocity, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.1f), (Float)Float.valueOf(10.0f)), (String)"Defines the launch velocity of the hook");
        this.reelingSpeed = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"reelingSpeed", (float)props.reelingSpeed, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.1f), (Float)Float.valueOf(4.0f)), (String)"Defines how fast the launcher reels in the rope");
        this.jumpBoostStrength = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"jumpBoostStrength", (float)props.jumpBoostStrength, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(3.0f)), (String)"Defines how high you will be thrown when performing Jump Boost or Tarzan Jump");
        this.tarzanJumpStrength = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"tarzanJumpStrength", (float)props.tarzanJumpStrength, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(3.0f)), (String)"Defines how far you will be thrown when performing Tarzan Jump");
        this.shooterWeightFactor = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"shooterWeightFactor", (float)props.shooterWeightFactor, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(1000.0f)), (String)"Allows to adjust your weight advantage/disadvantage over the hooked entity");
    }

    public float getLaunchVelocity() {
        return this.launchVelocity;
    }

    public float getReelingSpeed() {
        return this.reelingSpeed;
    }

    public float getJumpBoostStrength() {
        return this.jumpBoostStrength;
    }

    public float getTarzanJumpStrength() {
        return this.tarzanJumpStrength;
    }

    public float getShooterWeightFactor() {
        return this.shooterWeightFactor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        GameSettings gs = GameKeys.getGameSettings();
        Tooltip tip = Tooltip.of((ForgeMod)AdHooks.getInstance(), (String)"launcher", lines);
        TextFormatting formText = TextFormatting.RESET;
        if (Screen.func_231173_s_()) {
            tip.add(TextFormatting.RED, "hook_strength", (Object)Float.valueOf(this.hookType.hook.strength));
            tip.add(TextFormatting.AQUA, "rope_elasticity", (Object)Float.valueOf(this.hookType.rope.elasticity));
            tip.add(TextFormatting.YELLOW, "rope_max_length", (Object)this.hookType.rope.maxLength);
            tip.add(TextFormatting.GREEN, "reeling_speed", (Object)Float.valueOf(this.reelingSpeed));
            tip.add(TextFormatting.DARK_PURPLE, "jump_boost_strength", (Object)Float.valueOf(this.jumpBoostStrength));
            tip.add(TextFormatting.GOLD, "tarzan_jump_strength", (Object)Float.valueOf(this.tarzanJumpStrength));
        } else if (Screen.func_231172_r_()) {
            for (Hand hand : Hand.values()) {
                String textUnhooking = ControlBindings.getTextFor(hand, HookShot.WatchedBool.UNHOOKING);
                String textLoosening = ControlBindings.getTextFor(hand, HookShot.WatchedBool.LOOSENING);
                String handName = hand.name().toLowerCase(Locale.ROOT);
                tip.add(handName, new Object[]{TextFormatting.UNDERLINE});
                String textLaunching = ControlBindings.getTextFor(hand, HookShot.WatchedBool.LAUNCHING);
                tip.add("launch", new Object[]{TextFormatting.RED, formText, textLaunching});
                String textPulling = ControlBindings.getTextFor(hand, HookShot.WatchedBool.PULLING);
                if (ControlBindings.areSameForBothHands(HookShot.WatchedBool.UNHOOKING)) {
                    tip.add("reel_unhook_same", new Object[]{TextFormatting.GREEN, formText, textPulling, textUnhooking});
                } else {
                    tip.add("reel_unhook", new Object[]{TextFormatting.GREEN, formText, textUnhooking});
                }
                tip.add("pull", new Object[]{TextFormatting.YELLOW, formText, textPulling});
                if (ControlBindings.areSameForBothHands(HookShot.WatchedBool.LOOSENING)) {
                    tip.add("loosen_same", new Object[]{TextFormatting.AQUA, formText, textPulling, textLoosening});
                } else {
                    tip.add("loosen", new Object[]{TextFormatting.AQUA, formText, textLoosening});
                }
                tip.add("jump_boost", new Object[]{TextFormatting.DARK_PURPLE, formText, textUnhooking, ControlBindings.getTextFor(hand, HookShot.WatchedBool.JUMPING)});
                tip.add("tarzan_jump", new Object[]{TextFormatting.GOLD, formText, ControlBindings.getTextFor(hand, HookShot.WatchedBool.JUMPING)});
            }
            tip.add("other", new Object[]{TextFormatting.UNDERLINE});
            tip.add("swing", new Object[]{TextFormatting.BLUE, formText, Args.joinDelim((String)"-", (Object[])new Object[]{gs.field_74370_x.func_238171_j_().getString(), gs.field_74366_z.func_238171_j_().getString(), gs.field_74368_y.func_238171_j_().getString(), gs.field_74351_w.func_238171_j_().getString()})});
            tip.add("release", new Object[]{TextFormatting.LIGHT_PURPLE, formText, gs.field_74312_F.func_238171_j_().getString(), gs.field_228046_af_.func_238171_j_().getString()});
            tip.add("repair", new Object[]{TextFormatting.DARK_GRAY, formText});
        } else {
            tip.add("more_info", new Object[]{TextFormatting.GRAY, TextFormatting.DARK_PURPLE});
            tip.add("controls", new Object[]{TextFormatting.GRAY, TextFormatting.DARK_PURPLE});
        }
    }

    public static boolean isShotAttached(ItemStack launcher) {
        return Launcher.stackHasLauncher(launcher) && launcher.func_77942_o() && launcher.func_77978_p().func_74764_b(TAG_HOOKSHOT_ID);
    }

    public static boolean isAttachedToHookShot(ItemStack launcher, HookShot hookShot) {
        return Launcher.isShotAttached(launcher) && Launcher.getAttachedHookShotId(launcher) == hookShot.func_145782_y();
    }

    public static int getAttachedHookShotId(ItemStack launcher) {
        if (launcher.func_77942_o()) {
            return launcher.func_77978_p().func_74762_e(TAG_HOOKSHOT_ID);
        }
        return 0;
    }

    public static boolean stackHasLauncher(ItemStack stack) {
        return stack.func_77973_b() instanceof Launcher;
    }

    public static Optional<HookShot> findAttachedHookShot(ItemStack launcher, World world) {
        Entity entity;
        if (Launcher.isShotAttached(launcher) && (entity = world.func_73045_a(Launcher.getAttachedHookShotId(launcher))) instanceof HookShot) {
            return Optional.of((HookShot)entity);
        }
        return Optional.empty();
    }

    public static Optional<ItemStack> findAttachedLauncher(PlayerInventory inventory, HookShot hookShot) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (!Launcher.isAttachedToHookShot(stack, hookShot)) continue;
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    public static void attachToHookShot(ItemStack launcher, HookShot hookShot) {
        if (Launcher.stackHasLauncher(launcher) && hookShot != null) {
            CompoundNBT tag = launcher.func_196082_o();
            tag.func_74768_a(TAG_HOOKSHOT_ID, hookShot.func_145782_y());
        }
    }

    public static void unattach(ItemStack launcher) {
        if (Launcher.stackHasLauncher(launcher) && launcher.func_77942_o()) {
            launcher.func_77978_p().func_82580_o(TAG_HOOKSHOT_ID);
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        stack.func_196082_o();
    }

    public boolean onDroppedByPlayer(ItemStack stack, PlayerEntity player) {
        return true;
    }

    public boolean onLeftClickEntity(ItemStack launcher, PlayerEntity player, Entity entity) {
        return this.hookType != HookType.PUDGE;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public void makeShot(ItemStack launcher, LivingEntity shooter) {
        HookShot hookShot;
        World world = shooter.field_70170_p;
        if (this.isServerSide((IWorldReader)world) && this.hookType != HookType.PROTOTYPE && Launcher.notBroken((ItemStack)launcher) && world.func_217376_c((Entity)(hookShot = new HookShot(world, shooter, this.hookType)))) {
            hookShot.launch(shooter.func_70040_Z(), this.launchVelocity, 1.0f);
            Launcher.attachToHookShot(launcher, hookShot);
            Launcher.damageItem((int)1, (ItemStack)launcher, (boolean)false, (LivingEntity)shooter, null);
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (hand == Hand.OFF_HAND || !Launcher.stackHasLauncher(player.func_184592_cb())) {
            player.func_184598_c(hand);
        }
        return ActionResult.func_226250_c_((Object)player.func_184586_b(hand));
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void processPressedKeysBy(ClientPlayerEntity player, Hand activeHand) {
        RayTraceResult result;
        if (!GameKeys.affectPlayer()) {
            return;
        }
        Cooldowns cooldowns = this.cooldownsByHand.computeIfAbsent(activeHand, Cooldowns::new);
        WatchedStates states = this.watchedStatesByHand.computeIfAbsent(activeHand, WatchedStates::new);
        ItemStack activeItem = player.func_184586_b(activeHand);
        boolean kdJumping = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.JUMPING);
        boolean kdLaunching = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.LAUNCHING);
        boolean kdPulling = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.PULLING);
        boolean kdLoosening = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.LOOSENING);
        boolean kdUnhooking = ControlBindings.isKeyDownFor(activeHand, HookShot.WatchedBool.UNHOOKING);
        boolean shotAttached = Launcher.isShotAttached(activeItem);
        Function<HookShot.WatchedBool, Boolean> kdDoubleJumping = key -> {
            if (kdJumping) {
                if (!cooldowns.maxxed((HookShot.WatchedBool)((Object)key)) && !cooldowns.expired((HookShot.WatchedBool)((Object)key))) {
                    cooldowns.reset((HookShot.WatchedBool)((Object)key));
                    cooldowns.reset(HookShot.WatchedBool.LAUNCHING);
                    return true;
                }
                cooldowns.set((HookShot.WatchedBool)((Object)key), 4);
            } else {
                cooldowns.tick((HookShot.WatchedBool)((Object)key));
            }
            return false;
        };
        if (shotAttached) {
            cooldowns.tickIfTrueElseZero(HookShot.WatchedBool.UNHOOKING, b -> kdUnhooking);
        } else {
            cooldowns.tickIfTrueElseZero(HookShot.WatchedBool.LAUNCHING, b -> kdLaunching);
        }
        if (kdLaunching && !shotAttached && ((result = Minecraft.func_71410_x().field_71476_x) == null || result.func_216346_c() == RayTraceResult.Type.MISS) && cooldowns.expired(HookShot.WatchedBool.LAUNCHING)) {
            new MakeShotMsg(activeHand).sendToServer();
            cooldowns.reset(HookShot.WatchedBool.UNHOOKING);
            states.bools.clear();
        }
        states.updateAndSync(HookShot.WatchedBool.PULLING, pulling -> kdPulling && !kdLoosening);
        states.updateAndSync(HookShot.WatchedBool.LOOSENING, loosening -> ControlBindings.areSameForBothHands(loosening) ? kdLoosening && kdPulling : kdLoosening && !kdPulling);
        states.updateAndSync(HookShot.WatchedBool.UNHOOKING, unhooking -> shotAttached && cooldowns.expired((HookShot.WatchedBool)((Object)unhooking)) && (ControlBindings.areSameForBothHands(unhooking) ? kdUnhooking && kdPulling : kdUnhooking));
        states.updateAndSync(HookShot.WatchedBool.JUMPING, jumping -> kdJumping);
        states.updateAndSync(HookShot.WatchedBool.DOUBLE_JUMPING, kdDoubleJumping);
        if (states.get(HookShot.WatchedBool.UNHOOKING)) {
            cooldowns.reset(HookShot.WatchedBool.LAUNCHING);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int inventorySlot, boolean isCurrentItem) {
        if (this.isClientSide((IWorldReader)world) && entity instanceof ClientPlayerEntity) {
            ClientPlayerEntity player = (ClientPlayerEntity)entity;
            Optional<Hand> activeHand = Optional.empty();
            for (Hand hand2 : Hand.values()) {
                if (stack != player.func_184586_b(hand2)) continue;
                activeHand = Optional.of(hand2);
            }
            activeHand.ifPresent(hand -> this.processPressedKeysBy(player, (Hand)hand));
        }
    }

    public Launcher readFrom(CompoundNBT compound) {
        this.reelingSpeed = compound.func_74760_g("reelingSpeed");
        this.launchVelocity = compound.func_74760_g("launchVelocity");
        this.jumpBoostStrength = compound.func_74760_g("jumpBoostStrength");
        this.tarzanJumpStrength = compound.func_74760_g("tarzanJumpStrength");
        this.shooterWeightFactor = compound.func_74760_g("shooterWeightFactor");
        return this;
    }

    public CompoundNBT writeTo(CompoundNBT compound) {
        compound.func_74776_a("reelingSpeed", this.reelingSpeed);
        compound.func_74776_a("launchVelocity", this.launchVelocity);
        compound.func_74776_a("jumpBoostStrength", this.jumpBoostStrength);
        compound.func_74776_a("tarzanJumpStrength", this.tarzanJumpStrength);
        compound.func_74776_a("shooterWeightFactor", this.shooterWeightFactor);
        return compound;
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public int durability;
        public float reelingSpeed;
        public float launchVelocity;
        public float jumpBoostStrength = 1.0f;
        public float tarzanJumpStrength = 1.0f;
        public float shooterWeightFactor = 1.0f;

        public static Properties<?> of() {
            return new Properties<Properties>(Properties.class);
        }

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T durability(int value) {
            this.durability = value;
            return (T)((Object)((Properties)this.self));
        }

        public T reelingSpeed(float value) {
            this.reelingSpeed = value;
            return (T)((Object)((Properties)this.self));
        }

        public T launchVelocity(float value) {
            this.launchVelocity = value;
            return (T)((Object)((Properties)this.self));
        }

        public T jumpBoost(float strength) {
            this.jumpBoostStrength = strength;
            return (T)((Object)((Properties)this.self));
        }

        public T tarzanJump(float strength) {
            this.tarzanJumpStrength = strength;
            return (T)((Object)((Properties)this.self));
        }

        public T shooterWeightFactor(float value) {
            this.shooterWeightFactor = value;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static class Cooldowns {
        static final int TICKS_MAX_DEFAULT = 10;
        protected final Hand hand;
        protected final Map<HookShot.WatchedBool, Integer> ticksRemain;
        protected final Map<HookShot.WatchedBool, Integer> ticksMax;

        public Cooldowns(Hand hand) {
            this.hand = hand;
            this.ticksRemain = new EnumMap<HookShot.WatchedBool, Integer>(HookShot.WatchedBool.class);
            this.ticksMax = new EnumMap<HookShot.WatchedBool, Integer>(HookShot.WatchedBool.class);
        }

        public void tick(HookShot.WatchedBool key) {
            this.ticksRemain.computeIfPresent(key, (k, ticks) -> ticks > 0 ? ticks - 1 : 0);
        }

        public boolean expired(HookShot.WatchedBool key) {
            return this.ticksRemain(key) == 0;
        }

        public boolean maxxed(HookShot.WatchedBool key) {
            return this.ticksRemain(key) == this.ticksMax(key);
        }

        public int ticksRemain(HookShot.WatchedBool key) {
            return Optional.ofNullable(this.ticksRemain.get((Object)key)).orElse(0);
        }

        public int ticksMax(HookShot.WatchedBool key) {
            return Optional.ofNullable(this.ticksMax.get((Object)key)).orElse(10);
        }

        public void set(HookShot.WatchedBool key, int ticks) {
            if (ticks != 0 && ticks != 10) {
                this.ticksMax.put(key, ticks);
            }
            this.ticksRemain.put(key, Math.max(ticks, 0));
        }

        public void reset(HookShot.WatchedBool key) {
            this.set(key, this.ticksMax(key));
        }

        public void zero(HookShot.WatchedBool key) {
            this.set(key, 0);
        }

        public void tickIfTrueElseZero(HookShot.WatchedBool key, Predicate<HookShot.WatchedBool> predicate) {
            if (predicate.test(key)) {
                this.tick(key);
            } else {
                this.zero(key);
            }
        }
    }

    public static class WatchedStates {
        protected final Hand hand;
        protected final Map<HookShot.WatchedBool, Boolean> bools;

        public WatchedStates(Hand hand) {
            this.hand = hand;
            this.bools = new EnumMap<HookShot.WatchedBool, Boolean>(HookShot.WatchedBool.class);
        }

        public boolean get(HookShot.WatchedBool action) {
            return this.bools.computeIfAbsent(action, a -> false);
        }

        public void updateAndSync(HookShot.WatchedBool action, Function<HookShot.WatchedBool, Boolean> newValueFunc) {
            boolean newValue;
            boolean oldValue = this.get(action);
            if (oldValue != (newValue = newValueFunc.apply(action).booleanValue())) {
                this.bools.put(action, newValue);
                WatchedBoolMsg.sendToServer(this.hand, action, newValue);
            }
        }
    }
}

