/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.units.UnitProperties;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.nbt.CompoundNBT;

public class Hook
extends ForgeItem
implements INBTSerializable<Hook> {
    public final HookType type;
    protected boolean affectsItems;
    protected boolean affectsNPCs;
    protected boolean affectsPlayers;
    protected boolean canHookAnyBlock;
    protected boolean breaksGlass;
    protected float strength;
    protected float damage;
    protected float resistance;

    public Hook(ForgeMod mod, UnitConfig config, HookType type, Properties<?> props) {
        super(mod, config, type.getName() + "_hook", new Item.Properties().func_200916_a(ItemGroup.field_78040_i));
        String category = this.getUnitCategory();
        this.type = type;
        this.strength = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"strength", (float)props.strength, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(20.0f)), (String)"Defines how heavy duty it can withstand.");
        this.damage = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"damage", (float)props.damage, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(100.0f)), (String)"Defines how much damage it will deal to entity on hit.");
        this.resistance = UnitConfig.getFloat((UnitConfig)config, (String)category, (String)"resistance", (float)props.resistance, (FloatBounds)FloatBounds.from((Float)Float.valueOf(0.0f), (Float)Float.valueOf(60.0f)), (String)"Defines how long it can be under fire influence (in seconds).");
        this.affectsItems = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"affectsItems", (boolean)props.affectsItems, (String)"Defines interaction with dropped items on the ground.");
        this.affectsNPCs = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"affectsNPCs", (boolean)props.affectsNPCs, (String)"Defines interaction with non-playable characters.");
        this.affectsPlayers = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"affectsPlayers", (boolean)props.affectsPlayers, (String)"Defines interaction with players.");
        this.canHookAnyBlock = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"canHookAnyBlock", (boolean)props.canHookAnyBlock, (String)"If true, you can hook any block regardless of its material and hardness.");
        this.breaksGlass = UnitConfig.getBool((UnitConfig)config, (String)category, (String)"breaksGlass", (boolean)props.breaksGlass, (String)"Defines whether this hook is able to break glass.");
    }

    protected boolean func_194125_a(ItemGroup group) {
        if (this.type == HookType.PROTOTYPE) {
            return false;
        }
        return super.func_194125_a(group);
    }

    public Hook readFrom(CompoundNBT compound) {
        this.affectsItems = compound.func_74767_n("affectsItems");
        this.affectsNPCs = compound.func_74767_n("affectsNPCs");
        this.affectsPlayers = compound.func_74767_n("affectsPlayers");
        this.breaksGlass = compound.func_74767_n("breaksGlass");
        this.canHookAnyBlock = compound.func_74767_n("canHookAnyBlock");
        this.strength = compound.func_74760_g("strength");
        this.damage = compound.func_74760_g("damage");
        this.resistance = compound.func_74760_g("resistance");
        return this;
    }

    public CompoundNBT writeTo(CompoundNBT compound) {
        compound.func_74757_a("affectsItems", this.affectsItems);
        compound.func_74757_a("affectsNPCs", this.affectsNPCs);
        compound.func_74757_a("affectsPlayers", this.affectsPlayers);
        compound.func_74757_a("breaksGlass", this.breaksGlass);
        compound.func_74757_a("canHookAnyBlock", this.canHookAnyBlock);
        compound.func_74776_a("strength", this.strength);
        compound.func_74776_a("damage", this.damage);
        compound.func_74776_a("resistance", this.resistance);
        return compound;
    }

    public boolean affectsItems() {
        return this.affectsItems;
    }

    public boolean affectsNPCs() {
        return this.affectsNPCs;
    }

    public boolean breaksGlass() {
        return this.breaksGlass;
    }

    public boolean affectsPlayers() {
        return this.affectsPlayers;
    }

    public boolean canHookAnyBlock() {
        return this.canHookAnyBlock;
    }

    public float getStrength() {
        return this.strength;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getResistance() {
        return this.resistance;
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public boolean affectsItems = true;
        public boolean affectsNPCs = true;
        public boolean affectsPlayers = true;
        public boolean canHookAnyBlock = false;
        public boolean breaksGlass = false;
        public float strength;
        public float damage;
        public float resistance;

        public static Properties<?> of() {
            return new Properties<Properties>(Properties.class);
        }

        protected Properties(Class<T> selfClass) {
            super(selfClass);
        }

        public T breaksGlass() {
            this.breaksGlass = true;
            return (T)((Object)((Properties)this.self));
        }

        public T ignoreItems() {
            this.affectsItems = false;
            return (T)((Object)((Properties)this.self));
        }

        public T ignoreNPCs() {
            this.affectsNPCs = false;
            return (T)((Object)((Properties)this.self));
        }

        public T ignorePlayers() {
            this.affectsPlayers = false;
            return (T)((Object)((Properties)this.self));
        }

        public T hookAnyBlock() {
            this.canHookAnyBlock = true;
            return (T)((Object)((Properties)this.self));
        }

        public T strength(float value) {
            this.strength = value;
            return (T)((Object)((Properties)this.self));
        }

        public T damage(float value) {
            this.damage = value;
            return (T)((Object)((Properties)this.self));
        }

        public T resistance(float value) {
            this.resistance = value;
            return (T)((Object)((Properties)this.self));
        }
    }
}

