/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.client;

import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.data.Names;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.Hand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;

@OnlyIn(value=Dist.CLIENT)
public class ControlBindings {
    private static final Map<Hand, Map<HookShot.WatchedBool, Optional<KeyBinding>>> keyBindingsByHand = new HashMap<Hand, Map<HookShot.WatchedBool, Optional<KeyBinding>>>();

    public static Optional<KeyBinding> getKeyBindingFor(Hand hand, HookShot.WatchedBool action) {
        return keyBindingsByHand.getOrDefault(hand, Collections.emptyMap()).getOrDefault((Object)action, Optional.empty());
    }

    public static boolean areKeysEqual(Optional<KeyBinding> bindingA, Optional<KeyBinding> bindingB) {
        if (bindingA.isPresent() && bindingB.isPresent()) {
            return bindingA.get().getKey().equals((Object)bindingB.get().getKey());
        }
        return bindingA.orElse(null) == bindingB.orElse(null);
    }

    public static boolean areSameForBothHands(HookShot.WatchedBool action) {
        return ControlBindings.areKeysEqual(ControlBindings.getKeyBindingFor(Hand.MAIN_HAND, action), ControlBindings.getKeyBindingFor(Hand.OFF_HAND, action));
    }

    public static boolean isKeyDownFor(Hand hand, HookShot.WatchedBool action) {
        return ControlBindings.getKeyBindingFor(hand, action).map(kb -> kb.func_151470_d()).orElse(false);
    }

    public static String getTextFor(Hand hand, HookShot.WatchedBool action) {
        return ControlBindings.getKeyBindingFor(hand, action).map(kb -> kb.func_238171_j_().getString()).orElse("");
    }

    private static void register(Hand hand, HookShot.WatchedBool action, KeyBinding defaultKeyBinding) {
        String handName = hand.name().toLowerCase(Locale.ROOT);
        String category = Names.dotted().join(new String[]{"key", "categories", "adhooks", handName});
        String description = Names.dotted().join(new String[]{"key", "adhooks", handName, action.getName()});
        KeyBinding keyBinding = new KeyBinding(description, (IKeyConflictContext)KeyConflictContext.GUI, defaultKeyBinding.getKey().func_197938_b(), defaultKeyBinding.getKey().func_197937_c(), category){

            public boolean isConflictContextAndModifierActive() {
                return true;
            }

            public boolean hasKeyCodeModifierConflict(KeyBinding other) {
                return true;
            }

            public boolean func_197983_b(KeyBinding other) {
                return false;
            }
        };
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        ControlBindings.add(hand, action, keyBinding);
    }

    private static void add(Hand hand, HookShot.WatchedBool action, KeyBinding keyBinding) {
        keyBindingsByHand.computeIfAbsent(hand, h -> new EnumMap(HookShot.WatchedBool.class)).put(action, Optional.of(keyBinding));
    }

    public static void initialize() {
        GameSettings gs = GameKeys.getGameSettings();
        for (Hand hand : Hand.values()) {
            KeyBinding kbAttackOrUse = hand == Hand.MAIN_HAND ? gs.field_74312_F : gs.field_74313_G;
            ControlBindings.register(hand, HookShot.WatchedBool.LAUNCHING, kbAttackOrUse);
            ControlBindings.register(hand, HookShot.WatchedBool.PULLING, kbAttackOrUse);
            ControlBindings.register(hand, HookShot.WatchedBool.JUMPING, gs.field_74314_A);
            ControlBindings.register(hand, HookShot.WatchedBool.LOOSENING, gs.field_151444_V);
            ControlBindings.register(hand, HookShot.WatchedBool.UNHOOKING, gs.field_228046_af_);
        }
    }
}

