/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jeresources.config.Settings;
import jeresources.json.ProfilingAdapter;
import jeresources.profiling.ChunkGetter;
import jeresources.profiling.DummyWorld;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.ProfilingBlacklist;
import jeresources.profiling.ProfilingExecutor;
import jeresources.profiling.ProfilingTimer;
import jeresources.util.DimensionHelper;
import jeresources.util.LogHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Profiler
implements Runnable {
    private final ConcurrentMap<RegistryKey<World>, ProfiledDimensionData> allDimensionData;
    private final ProfilingTimer timer;
    private final Entity sender;
    private final ProfilingBlacklist blacklist;
    private final int chunkCount;
    private final boolean allWorlds;
    private ProfilingExecutor currentExecutor;
    private static Profiler currentProfiler;

    private Profiler(Entity sender, int chunkCount, boolean allWorlds) {
        this.sender = sender;
        this.allDimensionData = new ConcurrentHashMap<RegistryKey<World>, ProfiledDimensionData>();
        this.chunkCount = chunkCount;
        this.timer = new ProfilingTimer((ICommandSource)sender, chunkCount);
        this.allWorlds = allWorlds;
        this.blacklist = new ProfilingBlacklist();
    }

    @Override
    public void run() {
        LogHelper.warn("There will be messages about world gen lag during the profiling, you can ignore these as that is what you get when profiling.", new Object[0]);
        if (!this.allWorlds) {
            RegistryKey worldKey = this.sender.field_70170_p.func_234923_W_();
            this.profileWorld((RegistryKey<World>)worldKey);
        } else {
            for (RegistryKey worldKey : this.sender.func_184102_h().func_240770_D_()) {
                this.profileWorld((RegistryKey<World>)worldKey);
            }
        }
        this.writeData();
        this.timer.complete();
    }

    private void profileWorld(RegistryKey<World> worldKey) {
        ProfilingExecutor executor;
        IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
        ServerWorld world = server.func_71218_a(worldKey);
        if (world == null) {
            String msg = "Unable to profile dimension " + DimensionHelper.getWorldName(worldKey) + ".  There is no world for it.";
            LogHelper.error(msg, new Object[0]);
            this.sender.func_145747_a((ITextComponent)new StringTextComponent(msg), Util.field_240973_b_);
            return;
        }
        ServerWorld worldServer = world;
        String msg = "Inspecting dimension " + DimensionHelper.getWorldName(worldKey) + ". ";
        this.sender.func_145747_a((ITextComponent)new StringTextComponent(msg), Util.field_240973_b_);
        LogHelper.info(msg, new Object[0]);
        if (Settings.excludedDimensions.contains(worldKey.func_240901_a_().toString())) {
            msg = "Skipped dimension " + DimensionHelper.getWorldName(worldKey) + " during profiling";
            LogHelper.info(msg, new Object[0]);
            this.sender.func_145747_a((ITextComponent)new StringTextComponent(msg), Util.field_240973_b_);
            return;
        }
        this.currentExecutor = executor = new ProfilingExecutor(this);
        this.allDimensionData.put(worldKey, new ProfiledDimensionData());
        DummyWorld dummyWorld = new DummyWorld(worldServer);
        ChunkGetter chunkGetter = new ChunkGetter(this.chunkCount, dummyWorld, executor);
        worldServer.func_73046_m().func_213165_a((Runnable)chunkGetter);
        executor.awaitTermination();
        this.currentExecutor = null;
        dummyWorld.clearChunks();
    }

    public ProfilingTimer getTimer() {
        return this.timer;
    }

    public ProfilingBlacklist getBlacklist() {
        return this.blacklist;
    }

    public ConcurrentMap<RegistryKey<World>, ProfiledDimensionData> getAllDimensionData() {
        return this.allDimensionData;
    }

    private void writeData() {
        HashMap<RegistryKey<World>, ProfilingAdapter.DimensionData> allData = new HashMap<RegistryKey<World>, ProfilingAdapter.DimensionData>();
        for (RegistryKey worldRegistryKey : this.allDimensionData.keySet()) {
            ProfiledDimensionData profiledData = (ProfiledDimensionData)this.allDimensionData.get(worldRegistryKey);
            ProfilingAdapter.DimensionData data = new ProfilingAdapter.DimensionData();
            data.dropsMap = profiledData.dropsMap;
            data.silkTouchMap = profiledData.silkTouchMap;
            for (Map.Entry entry : profiledData.distributionMap.entrySet()) {
                Float[] array = new Float[256];
                for (int i = 0; i < 256; ++i) {
                    array[i] = Float.valueOf((float)((Integer[])entry.getValue())[i].intValue() * 1.0f / (float)this.timer.getBlocksPerLayer((RegistryKey<World>)worldRegistryKey));
                }
                data.distribution.put((String)entry.getKey(), array);
            }
            allData.put((RegistryKey<World>)worldRegistryKey, data);
        }
        ProfilingAdapter.write(allData);
    }

    public static boolean init(Entity sender, int chunks, boolean allWorlds) {
        if (currentProfiler != null && !Profiler.currentProfiler.timer.isCompleted()) {
            return false;
        }
        currentProfiler = new Profiler(sender, chunks, allWorlds);
        new Thread(currentProfiler).start();
        return true;
    }

    public static boolean stop() {
        if (currentProfiler == null || Profiler.currentProfiler.timer.isCompleted()) {
            return false;
        }
        if (Profiler.currentProfiler.currentExecutor != null) {
            Profiler.currentProfiler.currentExecutor.shutdownNow();
        }
        currentProfiler.writeData();
        return true;
    }
}

