/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.world.GameWorld;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public interface IWaterLoggable
extends net.minecraft.block.IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public static FluidState getFluidState(BlockState state, boolean falling) {
        return IWaterLoggable.isWaterlogged(state) ? Fluids.field_204546_a.func_207204_a(falling) : Fluids.field_204541_a.func_207188_f();
    }

    public static BlockState getStateForPlacementAt(IWorldReader world, BlockPos pos, BlockState originalState) {
        if (originalState.func_235901_b_((Property)WATERLOGGED) && GameWorld.isWaterSource(world, pos)) {
            return (BlockState)originalState.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return originalState;
    }

    public static BlockState getStateForPlacement(BlockItemUseContext context, BlockState originalState) {
        return IWaterLoggable.getStateForPlacementAt((IWorldReader)context.func_195991_k(), context.func_195995_a(), originalState);
    }

    public static BlockState updateFluidPostPlacement(IWorld worldIn, BlockPos currentPos, BlockState stateIn) {
        if (IWaterLoggable.isWaterlogged(stateIn)) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn;
    }

    public static boolean isWaterlogged(BlockState state) {
        return state.func_235901_b_((Property)WATERLOGGED) && (Boolean)state.func_177229_b((Property)WATERLOGGED) != false;
    }
}

