/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.GamePath;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitProperties;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ForgeBlock
extends Block
implements IForgeUnit<Block> {
    public static final AxisAlignedBB FULL_BLOCK_AABB = VoxelShapes.func_197868_b().func_197752_a();
    private final UnitEnabled unitEnabled;
    private final UnitConfig config;
    private Map<Object, UnitVariant> variants = new HashMap<Object, UnitVariant>();
    private final UnitVariant defaultVariant;
    private ResourceLocation textureLocation;

    public ForgeBlock(ForgeMod mod, UnitConfig config, Properties<?> props) {
        this(mod, config, props.name, ((Properties)props.setBlockProps()).blockProps);
    }

    @Deprecated
    public ForgeBlock(ForgeMod mod, UnitConfig config, String name, AbstractBlock.Properties props) {
        super(props);
        this.setRegistryName(new ResourceLocation(mod.getId(), name));
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
        this.defaultVariant = UnitVariant.from(this.getRegistryName(), IForgeUnit.Variants.NORMAL);
        this.textureLocation = GamePath.blockTexture((ResourceLocation)this.getRegistryName(), (String[])new String[0]).location;
    }

    public static boolean isUnderRain(World world, BlockPos pos) {
        return world.func_175727_C(pos.func_177984_a());
    }

    public static boolean isUnderOpenSky(World world, BlockPos pos) {
        return world.func_226660_f_(pos.func_177984_a());
    }

    @Nullable
    public static Block getBlockOrNull(Item item) {
        return item instanceof BlockItem ? ((BlockItem)item).func_179223_d() : null;
    }

    public static <T extends Enum<T>> EnumProperty<T> createEnumProperty(Class<T> clazz) {
        return EnumProperty.func_177709_a((String)IForgeUnit.getClassRegName(clazz), clazz);
    }

    public static UnitConfig createDefaultConfig(ForgeMod mod, String blockName) {
        Path baseDir = mod.getConfigsDir().resolve("blocks");
        String configName = UnitId.dictToRegName(blockName);
        return UnitConfig.in(baseDir, configName);
    }

    public ResourceLocation getTextureLocationFor(BlockState state) {
        return this.textureLocation;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.isEnabled()) {
            super.func_149666_a(group, items);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    public static boolean isRegistered(Block block) {
        return ForgeRegistries.BLOCKS.containsValue((IForgeRegistryEntry)block);
    }

    public static float getHardnessFrom(UnitConfig config, String category, float defaultValue) {
        return UnitConfig.getFloat(config, category, "hardness", defaultValue, new FloatBounds(Float.valueOf(-1.0f), Float.valueOf(Float.MAX_VALUE)), "Defines how many hits it takes to break the block.\n -1 makes the block indestructible.");
    }

    public static float getResistanceFrom(UnitConfig config, String category, float defaultValue) {
        return UnitConfig.getFloat(config, category, "resistance", defaultValue, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Float.MAX_VALUE)), "Defines the block resistance to explosions.");
    }

    @Override
    public UnitConfig getConfig() {
        return this.config;
    }

    public boolean hasVariants() {
        return this.variants.size() > 1;
    }

    @Override
    public Map<Object, UnitVariant> getUnitVariants() {
        return this.variants;
    }

    @Override
    public UnitVariant getDefaultVariant() {
        return this.defaultVariant;
    }

    @Override
    public <E extends Enum<E>> void setUnitVariants(Class<E> clazz) {
        this.variants = this.createUnitVariants(clazz);
    }

    public static class Properties<T extends Properties<T>>
    extends UnitProperties<T> {
        public final String name;
        public final Material material;
        public final AbstractBlock.Properties blockProps;

        public static Properties<?> with(String name, Material material) {
            return new Properties<Properties>(Properties.class, name, material);
        }

        protected Properties(Class<T> selfClass, String name, Material material) {
            super(selfClass);
            this.name = name;
            this.material = material;
            this.blockProps = AbstractBlock.Properties.func_200945_a((Material)material);
        }

        public T setBlockProps() {
            return (T)((Properties)this.self);
        }
    }
}

