/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import twilightforest.util.FeatureUtil;
import twilightforest.world.feature.TFTreeGenerator;
import twilightforest.world.feature.config.TFTreeFeatureConfig;

public class TFGenLargeWinter
extends TFTreeGenerator<TFTreeFeatureConfig> {
    public TFGenLargeWinter(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    protected boolean generate(IWorld world, Random random, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, Set<BlockPos> branch, Set<BlockPos> root, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int treeHeight = 35;
        if (random.nextInt(3) == 0) {
            treeHeight += random.nextInt(10);
            if (random.nextInt(8) == 0) {
                treeHeight += random.nextInt(10);
            }
        }
        if (pos.func_177956_o() >= 256 - treeHeight) {
            return false;
        }
        BlockState state = world.func_180495_p(pos.func_177977_b());
        if (!state.func_177230_c().canSustainPlant(state, (IBlockReader)world, pos.func_177977_b(), Direction.UP, config.getSapling(random, pos))) {
            return false;
        }
        this.buildTrunk(world, random, pos, trunk, treeHeight, mbb, config);
        this.makeLeaves(world, random, pos, treeHeight, trunk, leaves, mbb, config);
        int numRoots = 4 + random.nextInt(3);
        float offset = random.nextFloat();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, random, pos, root, offset, b, mbb, config);
        }
        return true;
    }

    private void makeLeaves(IWorld world, Random random, BlockPos pos, int treeHeight, Set<BlockPos> trunk, Set<BlockPos> leaves, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int offGround = 3;
        int leafType = 1;
        for (int dy = 0; dy < treeHeight; ++dy) {
            int radius = this.leafRadius(treeHeight, dy, leafType);
            FeatureUtil.makeLeafCircle2(world, pos.func_177981_b(offGround + treeHeight - dy), radius, config.leavesProvider.func_225574_a_(random, pos.func_177981_b(offGround + treeHeight - dy)), leaves);
            this.makePineBranches(world, random, pos.func_177981_b(offGround + treeHeight - dy), trunk, radius, mbb, config);
        }
    }

    private void makePineBranches(IWorld world, Random rand, BlockPos pos, Set<BlockPos> trunk, int radius, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int branchLength = radius > 4 ? radius - 1 : radius - 2;
        switch (pos.func_177956_o() % 2) {
            case 0: {
                for (int i = 1; i <= branchLength; ++i) {
                    this.placeLogAt((IWorldGenerationReader)world, rand, pos.func_177982_a(-i, 0, 0), Direction.Axis.X, trunk, mbb, config);
                    this.placeLogAt((IWorldGenerationReader)world, rand, pos.func_177982_a(0, 0, i + 1), Direction.Axis.Z, trunk, mbb, config);
                    this.placeLogAt((IWorldGenerationReader)world, rand, pos.func_177982_a(i + 1, 0, 1), Direction.Axis.X, trunk, mbb, config);
                    this.placeLogAt((IWorldGenerationReader)world, rand, pos.func_177982_a(1, 0, -i), Direction.Axis.Z, trunk, mbb, config);
                }
                break;
            }
            case 1: {
                for (int i = 1; i <= branchLength; ++i) {
                    this.placeLogAt((IWorldGenerationReader)world, rand, pos.func_177982_a(-1, 0, 1), Direction.Axis.X, trunk, mbb, config);
                    this.placeLogAt((IWorldGenerationReader)world, rand, pos.func_177982_a(1, 0, i + 1), Direction.Axis.Z, trunk, mbb, config);
                    this.placeLogAt((IWorldGenerationReader)world, rand, pos.func_177982_a(i + 1, 0, 0), Direction.Axis.X, trunk, mbb, config);
                    this.placeLogAt((IWorldGenerationReader)world, rand, pos.func_177982_a(0, 0, -i), Direction.Axis.Z, trunk, mbb, config);
                }
                break;
            }
        }
    }

    private void placeLogAt(IWorldGenerationReader reader, Random rand, BlockPos pos, Direction.Axis axis, Set<BlockPos> logPos, MutableBoundingBox boundingBox, TFTreeFeatureConfig config) {
        this.setBlockState((IWorldWriter)reader, pos, (BlockState)config.trunkProvider.func_225574_a_(rand, pos).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axis), boundingBox);
        logPos.add(pos.func_185334_h());
    }

    private int leafRadius(int treeHeight, int dy, int functionType) {
        switch (functionType) {
            default: {
                return (dy - 1) % 4;
            }
            case 1: {
                return (int)(4.0f * (float)dy / (float)treeHeight + 0.75f * (float)dy % 3.0f);
            }
            case 99: 
        }
        return (treeHeight - dy / 2 - 1) % 4;
    }

    private void buildTrunk(IWorld world, Random rand, BlockPos pos, Set<BlockPos> trunk, int treeHeight, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        for (int dy = 0; dy < treeHeight; ++dy) {
            this.setLogBlockState(world, rand, pos.func_177982_a(0, dy, 0), trunk, mbb, config);
            this.setLogBlockState(world, rand, pos.func_177982_a(1, dy, 0), trunk, mbb, config);
            this.setLogBlockState(world, rand, pos.func_177982_a(0, dy, 1), trunk, mbb, config);
            this.setLogBlockState(world, rand, pos.func_177982_a(1, dy, 1), trunk, mbb, config);
        }
    }
}

