/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import twilightforest.block.TFBlocks;
import twilightforest.util.FeatureUtil;

public class TFGenFallenHollowLog
extends Feature<NoFeatureConfig> {
    final BlockState mossPatch = ((Block)TFBlocks.moss_patch.get()).func_176223_P();
    final BlockState oakLeaves = (BlockState)((Block)TFBlocks.oak_leaves.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(true));
    final BlockState oakLogWithZAxis = (BlockState)((RotatedPillarBlock)TFBlocks.oak_log.get()).func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
    final BlockState oakLogWithXAxis = (BlockState)((RotatedPillarBlock)TFBlocks.oak_log.get()).func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
    final BlockState grass = Blocks.field_196658_i.func_176223_P();
    final BlockState firefly = ((Block)TFBlocks.firefly.get()).func_176223_P();

    public TFGenFallenHollowLog(Codec<NoFeatureConfig> configIn) {
        super(configIn);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        return rand.nextBoolean() ? this.makeLog4Z((IWorld)world, rand, pos) : this.makeLog4X((IWorld)world, rand, pos);
    }

    private boolean makeLog4Z(IWorld world, Random rand, BlockPos pos) {
        if (!FeatureUtil.isAreaSuitable(world, pos, 9, 3, 4)) {
            return false;
        }
        this.makeNegativeZJaggy(world, pos, rand.nextInt(3), 0, 0);
        this.makeNegativeZJaggy(world, pos, rand.nextInt(3), 3, 0);
        this.makeNegativeZJaggy(world, pos, rand.nextInt(3), 0, 1);
        this.makeNegativeZJaggy(world, pos, rand.nextInt(3), 3, 1);
        this.makeNegativeZJaggy(world, pos, rand.nextInt(3), 1, 2);
        this.makeNegativeZJaggy(world, pos, rand.nextInt(3), 2, 2);
        this.makePositiveZJaggy(world, pos, rand.nextInt(3), 0, 0);
        this.makePositiveZJaggy(world, pos, rand.nextInt(3), 3, 0);
        this.makePositiveZJaggy(world, pos, rand.nextInt(3), 0, 1);
        this.makePositiveZJaggy(world, pos, rand.nextInt(3), 3, 1);
        this.makePositiveZJaggy(world, pos, rand.nextInt(3), 1, 2);
        this.makePositiveZJaggy(world, pos, rand.nextInt(3), 2, 2);
        for (int dz = 0; dz < 4; ++dz) {
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_177982_a(1, -1, dz + 3), this.oakLogWithZAxis, 3);
                if (rand.nextBoolean()) {
                    world.func_180501_a(pos.func_177982_a(1, 0, dz + 3), this.mossPatch, 3);
                }
            } else {
                world.func_180501_a(pos.func_177982_a(1, -1, dz + 3), this.grass, 3);
                world.func_180501_a(pos.func_177982_a(1, 0, dz + 3), this.mossPatch, 3);
            }
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_177982_a(2, -1, dz + 3), this.oakLogWithZAxis, 3);
                if (rand.nextBoolean()) {
                    world.func_180501_a(pos.func_177982_a(2, 0, dz + 3), this.mossPatch, 3);
                }
            } else {
                world.func_180501_a(pos.func_177982_a(2, -1, dz + 3), this.grass, 3);
                world.func_180501_a(pos.func_177982_a(2, 0, dz + 3), this.mossPatch, 3);
            }
            world.func_180501_a(pos.func_177982_a(0, 0, dz + 3), this.oakLogWithZAxis, 3);
            world.func_180501_a(pos.func_177982_a(3, 0, dz + 3), this.oakLogWithZAxis, 3);
            world.func_180501_a(pos.func_177982_a(0, 1, dz + 3), this.oakLogWithZAxis, 3);
            world.func_180501_a(pos.func_177982_a(3, 1, dz + 3), this.oakLogWithZAxis, 3);
            world.func_180501_a(pos.func_177982_a(1, 2, dz + 3), this.oakLogWithZAxis, 3);
            world.func_180501_a(pos.func_177982_a(2, 2, dz + 3), this.oakLogWithZAxis, 3);
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_177982_a(1, 3, dz + 3), this.mossPatch, 3);
            }
            if (!rand.nextBoolean()) continue;
            world.func_180501_a(pos.func_177982_a(2, 3, dz + 3), this.mossPatch, 3);
        }
        int offZ = rand.nextInt(3) + 2;
        boolean plusX = rand.nextBoolean();
        for (int dz = 0; dz < 3; ++dz) {
            if (!rand.nextBoolean()) continue;
            world.func_180501_a(pos.func_177982_a(plusX ? 3 : 0, 2, dz + offZ), this.oakLeaves, 3);
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_177982_a(plusX ? 3 : 0, 3, dz + offZ), this.oakLeaves, 3);
            }
            if (!rand.nextBoolean()) continue;
            world.func_180501_a(pos.func_177982_a(plusX ? 4 : -1, 2, dz + offZ), this.oakLeaves, 3);
        }
        world.func_180501_a(pos.func_177982_a(plusX ? 0 : 3, 2, rand.nextInt(4) + 3), this.firefly, 3);
        return true;
    }

    private void makeNegativeZJaggy(IWorld world, BlockPos pos, int length, int dx, int dy) {
        for (int dz = -length; dz < 0; ++dz) {
            world.func_180501_a(pos.func_177982_a(dx, dy, dz + 3), this.oakLogWithZAxis, 3);
        }
    }

    private void makePositiveZJaggy(IWorld world, BlockPos pos, int length, int dx, int dy) {
        for (int dz = 0; dz < length; ++dz) {
            world.func_180501_a(pos.func_177982_a(dx, dy, dz + 7), this.oakLogWithZAxis, 3);
        }
    }

    private boolean makeLog4X(IWorld world, Random rand, BlockPos pos) {
        if (!FeatureUtil.isAreaSuitable(world, pos, 4, 3, 9)) {
            return false;
        }
        this.makeNegativeXJaggy(world, pos, rand.nextInt(3), 0, 0);
        this.makeNegativeXJaggy(world, pos, rand.nextInt(3), 3, 0);
        this.makeNegativeXJaggy(world, pos, rand.nextInt(3), 0, 1);
        this.makeNegativeXJaggy(world, pos, rand.nextInt(3), 3, 1);
        this.makeNegativeXJaggy(world, pos, rand.nextInt(3), 1, 2);
        this.makeNegativeXJaggy(world, pos, rand.nextInt(3), 2, 2);
        this.makePositiveXJaggy(world, pos, rand.nextInt(3), 0, 0);
        this.makePositiveXJaggy(world, pos, rand.nextInt(3), 3, 0);
        this.makePositiveXJaggy(world, pos, rand.nextInt(3), 0, 1);
        this.makePositiveXJaggy(world, pos, rand.nextInt(3), 3, 1);
        this.makePositiveXJaggy(world, pos, rand.nextInt(3), 1, 2);
        this.makePositiveXJaggy(world, pos, rand.nextInt(3), 2, 2);
        for (int dx = 0; dx < 4; ++dx) {
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_177982_a(dx + 3, -1, 1), this.oakLogWithXAxis, 3);
                if (rand.nextBoolean()) {
                    world.func_180501_a(pos.func_177982_a(dx + 3, 0, 1), this.mossPatch, 3);
                }
            } else {
                world.func_180501_a(pos.func_177982_a(dx + 3, -1, 1), this.grass, 3);
                world.func_180501_a(pos.func_177982_a(dx + 3, 0, 1), this.mossPatch, 3);
            }
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_177982_a(dx + 3, -1, 2), this.oakLogWithXAxis, 3);
                if (rand.nextBoolean()) {
                    world.func_180501_a(pos.func_177982_a(dx + 3, 0, 2), this.mossPatch, 3);
                }
            } else {
                world.func_180501_a(pos.func_177982_a(dx + 3, -1, 2), this.grass, 3);
                world.func_180501_a(pos.func_177982_a(dx + 3, 0, 2), this.mossPatch, 3);
            }
            world.func_180501_a(pos.func_177982_a(dx + 3, 0, 0), this.oakLogWithXAxis, 3);
            world.func_180501_a(pos.func_177982_a(dx + 3, 0, 3), this.oakLogWithXAxis, 3);
            world.func_180501_a(pos.func_177982_a(dx + 3, 1, 0), this.oakLogWithXAxis, 3);
            world.func_180501_a(pos.func_177982_a(dx + 3, 1, 3), this.oakLogWithXAxis, 3);
            world.func_180501_a(pos.func_177982_a(dx + 3, 2, 1), this.oakLogWithXAxis, 3);
            world.func_180501_a(pos.func_177982_a(dx + 3, 2, 2), this.oakLogWithXAxis, 3);
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_177982_a(dx + 3, 3, 1), this.mossPatch, 3);
            }
            if (!rand.nextBoolean()) continue;
            world.func_180501_a(pos.func_177982_a(dx + 3, 3, 2), this.mossPatch, 3);
        }
        int offX = rand.nextInt(3) + 2;
        boolean plusZ = rand.nextBoolean();
        for (int dx = 0; dx < 3; ++dx) {
            if (!rand.nextBoolean()) continue;
            world.func_180501_a(pos.func_177982_a(dx + offX, 2, plusZ ? 3 : 0), this.oakLeaves, 3);
            if (rand.nextBoolean()) {
                world.func_180501_a(pos.func_177982_a(dx + offX, 3, plusZ ? 3 : 0), this.oakLeaves, 3);
            }
            if (!rand.nextBoolean()) continue;
            world.func_180501_a(pos.func_177982_a(dx + offX, 2, plusZ ? 4 : -1), this.oakLeaves, 3);
        }
        world.func_180501_a(pos.func_177982_a(rand.nextInt(4) + 3, 2, plusZ ? 0 : 3), this.firefly, 3);
        return true;
    }

    private void makeNegativeXJaggy(IWorld world, BlockPos pos, int length, int dz, int dy) {
        for (int dx = -length; dx < 0; ++dx) {
            world.func_180501_a(pos.func_177982_a(dx + 3, dy, dz), this.oakLogWithXAxis, 3);
        }
    }

    private void makePositiveXJaggy(IWorld world, BlockPos pos, int length, int dz, int dy) {
        for (int dx = 0; dx < length; ++dx) {
            world.func_180501_a(pos.func_177982_a(dx + 7, dy, dz), this.oakLogWithXAxis, 3);
        }
    }
}

