/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.network.NetworkEvent;
import twilightforest.TFMagicMapData;
import twilightforest.item.MagicMapItem;

public class MagicMapPacket {
    private final byte[] featureData;
    private final SMapDataPacket inner;

    public MagicMapPacket(TFMagicMapData mapData, SMapDataPacket inner) {
        this.featureData = mapData.serializeFeatures();
        this.inner = inner;
    }

    public MagicMapPacket(PacketBuffer buf) {
        this.featureData = buf.func_179251_a();
        this.inner = new SMapDataPacket();
        try {
            this.inner.func_148837_a(buf);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read inner SPacketMaps", e);
        }
    }

    public void encode(PacketBuffer buf) {
        buf.func_179250_a(this.featureData);
        try {
            this.inner.func_148840_b(buf);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't write inner SPacketMaps", e);
        }
    }

    public static class Handler {
        public static boolean onMessage(final MagicMapPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    MapItemRenderer mapitemrenderer = Minecraft.func_71410_x().field_71460_t.func_147701_i();
                    String s = MagicMapItem.getMapName(message.inner.func_149188_c());
                    TFMagicMapData mapdata = TFMagicMapData.getMagicMapData((World)Minecraft.func_71410_x().field_71441_e, s);
                    if (mapdata == null) {
                        MapData mapdata1;
                        mapdata = new TFMagicMapData(s);
                        if (mapitemrenderer.func_191205_a(s) != null && (mapdata1 = mapitemrenderer.func_191207_a(mapitemrenderer.func_191205_a(s))) instanceof TFMagicMapData) {
                            mapdata = (TFMagicMapData)mapdata1;
                        }
                        TFMagicMapData.registerMagicMapData((World)Minecraft.func_71410_x().field_71441_e, mapdata);
                    }
                    message.inner.func_179734_a((MapData)mapdata);
                    mapdata.deserializeFeatures(message.featureData);
                    LinkedHashMap saveVanilla = new LinkedHashMap(mapdata.field_76203_h);
                    mapdata.field_76203_h.clear();
                    for (TFMagicMapData.TFMapDecoration tfDecor : mapdata.tfDecorations) {
                        mapdata.field_76203_h.put(((Object)((Object)tfDecor)).toString(), tfDecor);
                    }
                    mapdata.field_76203_h.putAll(saveVanilla);
                    mapitemrenderer.func_148246_a((MapData)mapdata);
                }
            });
            return true;
        }
    }
}

