/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import twilightforest.TwilightForestMod;
import twilightforest.block.AbstractTrophyBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.TrophyBlock;
import twilightforest.block.TrophyWallBlock;
import twilightforest.client.model.tileentity.HydraTrophyModel;
import twilightforest.client.model.tileentity.KnightPhantomTrophyModel;
import twilightforest.client.model.tileentity.LichTrophyModel;
import twilightforest.client.model.tileentity.MinoshroomTrophyModel;
import twilightforest.client.model.tileentity.ModelTFYetiAlphaTrophy;
import twilightforest.client.model.tileentity.NagaTrophyModel;
import twilightforest.client.model.tileentity.PhantomArmorTrophyModel;
import twilightforest.client.model.tileentity.QuestRamTrophyModel;
import twilightforest.client.model.tileentity.SnowQueenTrophyModel;
import twilightforest.client.model.tileentity.UrGhastTrophyModel;
import twilightforest.enums.BossVariant;
import twilightforest.tileentity.TrophyTileEntity;

public class TrophyTileEntityRenderer
extends TileEntityRenderer<TrophyTileEntity> {
    private static final HydraTrophyModel hydraHead = new HydraTrophyModel();
    private static final ResourceLocation textureLocHydra = TwilightForestMod.getModelTexture("hydra4.png");
    private static final NagaTrophyModel nagaHead = new NagaTrophyModel();
    private static final ResourceLocation textureLocNaga = TwilightForestMod.getModelTexture("nagahead.png");
    private static final LichTrophyModel lichHead = new LichTrophyModel();
    private static final ResourceLocation textureLocLich = TwilightForestMod.getModelTexture("twilightlich64.png");
    private static final UrGhastTrophyModel ghastHead = new UrGhastTrophyModel();
    private static final ResourceLocation textureLocUrGhast = TwilightForestMod.getModelTexture("towerboss.png");
    private static final SnowQueenTrophyModel waifuHead = new SnowQueenTrophyModel();
    private static final ResourceLocation textureLocSnowQueen = TwilightForestMod.getModelTexture("snowqueen.png");
    private static final MinoshroomTrophyModel minoshroomHead = new MinoshroomTrophyModel();
    private static final ResourceLocation textureLocMinoshroom = TwilightForestMod.getModelTexture("minoshroomtaur.png");
    private static final KnightPhantomTrophyModel phantomHead = new KnightPhantomTrophyModel();
    private static final ResourceLocation textureLocKnightPhantom = TwilightForestMod.getModelTexture("phantomskeleton.png");
    private static final PhantomArmorTrophyModel phantomArmorModel = new PhantomArmorTrophyModel();
    private static final ResourceLocation textureLocKnightPhantomArmor = new ResourceLocation("twilightforest:textures/armor/phantom_1.png");
    private static final ModelTFYetiAlphaTrophy yetiHead = new ModelTFYetiAlphaTrophy();
    private static final ResourceLocation textureLocYeti = TwilightForestMod.getModelTexture("yetialpha.png");
    private static final QuestRamTrophyModel ramHead = new QuestRamTrophyModel();
    private static final ResourceLocation textureLocQuestRam = TwilightForestMod.getModelTexture("questram.png");
    private static final ResourceLocation textureLocQuestRamLines = TwilightForestMod.getModelTexture("questram_lines.png");
    public static ItemStack stack = new ItemStack((IItemProvider)TFBlocks.naga_trophy.get());

    public TrophyTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TrophyTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float f = tileEntityIn.getAnimationProgress(partialTicks);
        BlockState blockstate = tileEntityIn.func_195044_w();
        boolean flag = blockstate.func_177230_c() instanceof TrophyWallBlock;
        Direction direction = flag ? (Direction)blockstate.func_177229_b((Property)TrophyWallBlock.FACING) : null;
        float f1 = 22.5f * (float)(flag ? (2 + direction.func_176736_b()) * 4 : (Integer)blockstate.func_177229_b((Property)TrophyBlock.ROTATION));
        matrixStackIn.func_227860_a_();
        if (((AbstractTrophyBlock)blockstate.func_177230_c()).getVariant() == BossVariant.HYDRA && flag) {
            hydraHead.openMouthForTrophy(0.5f);
        } else {
            hydraHead.openMouthForTrophy(0.0f);
        }
        if (((AbstractTrophyBlock)blockstate.func_177230_c()).getVariant() == BossVariant.UR_GHAST) {
            ghastHead.setTranslate(matrixStackIn, 0.0f, 1.0f, 0.0f);
        }
        TrophyTileEntityRenderer.render(direction, f1, ((AbstractTrophyBlock)blockstate.func_177230_c()).getVariant(), f, matrixStackIn, bufferIn, combinedLightIn, ItemCameraTransforms.TransformType.NONE);
        matrixStackIn.func_227865_b_();
    }

    public static void render(@Nullable Direction directionIn, float y, BossVariant variant, float animationProgress, MatrixStack matrixStackIn, IRenderTypeBuffer buffer, int combinedLight, ItemCameraTransforms.TransformType camera) {
        matrixStackIn.func_227860_a_();
        if (directionIn == null || variant == BossVariant.UR_GHAST) {
            matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        } else {
            matrixStackIn.func_227861_a_((double)(0.5f - (float)directionIn.func_82601_c() * 0.25f), 0.25, (double)(0.5f - (float)directionIn.func_82599_e() * 0.25f));
        }
        matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
        switch (variant) {
            case HYDRA: {
                matrixStackIn.func_227862_a_(0.25f, 0.25f, 0.25f);
                matrixStackIn.func_227861_a_(0.0, -1.0, 0.0);
                if (camera == ItemCameraTransforms.TransformType.GUI) {
                    hydraHead.openMouthForTrophy(0.35f);
                }
                hydraHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder hydraVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocHydra));
                TrophyTileEntityRenderer.hydraHead.head.func_228309_a_(matrixStackIn, hydraVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case NAGA: {
                matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                matrixStackIn.func_227861_a_(0.0, 0.25, 0.0);
                nagaHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder nagaVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocNaga));
                TrophyTileEntityRenderer.nagaHead.head.func_228309_a_(matrixStackIn, nagaVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case LICH: {
                matrixStackIn.func_227861_a_(0.0, 0.25, 0.0);
                lichHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder lichVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocLich));
                TrophyTileEntityRenderer.lichHead.head.func_228309_a_(matrixStackIn, lichVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case UR_GHAST: {
                matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                ghastHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder ghastVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocUrGhast));
                TrophyTileEntityRenderer.ghastHead.body.func_228309_a_(matrixStackIn, ghastVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SNOW_QUEEN: {
                waifuHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder waifuVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocSnowQueen));
                TrophyTileEntityRenderer.waifuHead.head.func_228309_a_(matrixStackIn, waifuVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case MINOSHROOM: {
                matrixStackIn.func_227861_a_(0.0, (double)0.31f, 0.0);
                minoshroomHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder minoVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocMinoshroom));
                TrophyTileEntityRenderer.minoshroomHead.head.func_228309_a_(matrixStackIn, minoVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case KNIGHT_PHANTOM: {
                matrixStackIn.func_227861_a_(0.0, 0.25, 0.0);
                phantomHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder phantomVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocKnightPhantom));
                TrophyTileEntityRenderer.phantomHead.head.func_228309_a_(matrixStackIn, phantomVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.func_227862_a_(1.1f, 1.1f, 1.1f);
                matrixStackIn.func_227861_a_(0.0, (double)0.05f, 0.0);
                phantomArmorModel.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder phantomArmorVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocKnightPhantomArmor));
                TrophyTileEntityRenderer.phantomArmorModel.head.func_228309_a_(matrixStackIn, phantomArmorVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 0.0625f);
                break;
            }
            case ALPHA_YETI: {
                matrixStackIn.func_227862_a_(0.2f, 0.2f, 0.2f);
                matrixStackIn.func_227861_a_(0.0, -1.5, 0.0);
                yetiHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder yetiVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocYeti));
                TrophyTileEntityRenderer.yetiHead.main.func_228309_a_(matrixStackIn, yetiVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case QUEST_RAM: {
                matrixStackIn.func_227862_a_(0.7f, 0.7f, 0.7f);
                ramHead.setRotations(animationProgress * 4.5f, y, 0.0f);
                IVertexBuilder ramVertex = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocQuestRam));
                ramHead.func_225598_a_(matrixStackIn, ramVertex, combinedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
        }
        matrixStackIn.func_227865_b_();
    }
}

