/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrollsteinnBlock
extends Block {
    private static final BooleanProperty DOWN_LIT = BooleanProperty.func_177716_a((String)"down");
    private static final BooleanProperty UP_LIT = BooleanProperty.func_177716_a((String)"up");
    private static final BooleanProperty NORTH_LIT = BooleanProperty.func_177716_a((String)"north");
    private static final BooleanProperty SOUTH_LIT = BooleanProperty.func_177716_a((String)"south");
    private static final BooleanProperty WEST_LIT = BooleanProperty.func_177716_a((String)"west");
    private static final BooleanProperty EAST_LIT = BooleanProperty.func_177716_a((String)"east");
    private static final Map<Direction, BooleanProperty> PROPERTY_MAP = ImmutableMap.builder().put((Object)Direction.DOWN, (Object)DOWN_LIT).put((Object)Direction.UP, (Object)UP_LIT).put((Object)Direction.NORTH, (Object)NORTH_LIT).put((Object)Direction.SOUTH, (Object)SOUTH_LIT).put((Object)Direction.WEST, (Object)WEST_LIT).put((Object)Direction.EAST, (Object)EAST_LIT).build();
    private static final int LIGHT_THRESHHOLD = 7;

    TrollsteinnBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)DOWN_LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)UP_LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)NORTH_LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH_LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST_LIT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST_LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{DOWN_LIT, UP_LIT, NORTH_LIT, SOUTH_LIT, WEST_LIT, EAST_LIT});
    }

    public BlockState func_196271_a(BlockState state, Direction dirToNeighbor, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        boolean lit = world.func_201696_r(neighborPos) > 7;
        return (BlockState)state.func_206870_a((Property)PROPERTY_MAP.get(dirToNeighbor), (Comparable)Boolean.valueOf(lit));
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState ret = this.func_176223_P();
        for (Map.Entry<Direction, BooleanProperty> e : PROPERTY_MAP.entrySet()) {
            int light = ctx.func_195991_k().func_201696_r(ctx.func_195995_a().func_177972_a(e.getKey()));
            ret = (BlockState)ret.func_206870_a((Property)e.getValue(), (Comparable)Boolean.valueOf(light > 7));
        }
        return ret;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(2) == 0) {
            this.sparkle(world, pos);
        }
    }

    private void sparkle(World world, BlockPos pos) {
        Random random = world.field_73012_v;
        int threshhold = 7;
        for (Direction side : Direction.values()) {
            double rx = (float)pos.func_177958_n() + random.nextFloat();
            double ry = (float)pos.func_177956_o() + random.nextFloat();
            double rz = (float)pos.func_177952_p() + random.nextFloat();
            if (side == Direction.DOWN && !world.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)world, pos) && world.func_201696_r(pos.func_177977_b()) <= threshhold) {
                ry = (double)pos.func_177956_o() - 0.0625;
            }
            if (side == Direction.UP && !world.func_180495_p(pos.func_177984_a()).func_200015_d((IBlockReader)world, pos) && world.func_201696_r(pos.func_177984_a()) <= threshhold) {
                ry = (double)pos.func_177956_o() + 0.0625 + 1.0;
            }
            if (side == Direction.NORTH && !world.func_180495_p(pos.func_177978_c()).func_200015_d((IBlockReader)world, pos) && world.func_201696_r(pos.func_177978_c()) <= threshhold) {
                rz = (double)pos.func_177952_p() - 0.0625;
            }
            if (side == Direction.SOUTH && !world.func_180495_p(pos.func_177968_d()).func_200015_d((IBlockReader)world, pos) && world.func_201696_r(pos.func_177968_d()) <= threshhold) {
                rz = (double)pos.func_177952_p() + 0.0625 + 1.0;
            }
            if (side == Direction.WEST && !world.func_180495_p(pos.func_177976_e()).func_200015_d((IBlockReader)world, pos) && world.func_201696_r(pos.func_177976_e()) <= threshhold) {
                rx = (double)pos.func_177958_n() - 0.0625;
            }
            if (side == Direction.EAST && !world.func_180495_p(pos.func_177974_f()).func_200015_d((IBlockReader)world, pos) && world.func_201696_r(pos.func_177974_f()) <= threshhold) {
                rx = (double)pos.func_177958_n() + 0.0625 + 1.0;
            }
            if (!(rx < (double)pos.func_177958_n() || rx > (double)(pos.func_177958_n() + 1) || ry < 0.0 || ry > (double)(pos.func_177956_o() + 1) || rz < (double)pos.func_177952_p()) && !(rz > (double)(pos.func_177952_p() + 1))) continue;
            world.func_195594_a((IParticleData)new RedstoneParticleData(0.0f, random.nextFloat(), 1.0f, 1.0f), rx, ry, rz, 0.25, -1.0, 0.5);
        }
    }
}

