/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import twilightforest.enums.Diagonals;

public class SpiralBrickBlock
extends Block {
    public static final EnumProperty<Diagonals> DIAGONAL = EnumProperty.func_177709_a((String)"diagonal", Diagonals.class);
    public static final EnumProperty<Direction.Axis> AXIS_FACING = EnumProperty.func_177709_a((String)"axis", Direction.Axis.class);

    public SpiralBrickBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_235861_h_().func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(DIAGONAL, (Comparable)((Object)Diagonals.TOP_RIGHT))).func_206870_a(AXIS_FACING, (Comparable)Direction.Axis.X));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{AXIS_FACING, DIAGONAL});
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return super.getLightValue(state, world, pos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d()));
        if (!context.func_195999_j().func_225608_bj_() && context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d())).func_177230_c() instanceof SpiralBrickBlock) {
            Direction.Axis axis = (Direction.Axis)state.func_177229_b(AXIS_FACING);
            return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a(AXIS_FACING, (Comparable)axis)).func_206870_a(DIAGONAL, (Comparable)((Object)Diagonals.mirror((Diagonals)((Object)state.func_177229_b(DIAGONAL)), context.func_196000_l().func_176740_k() == Direction.Axis.X ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK)));
        }
        Direction playerFacing = context.func_196010_d().func_176734_d();
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a(AXIS_FACING, (Comparable)playerFacing.func_176740_k())).func_206870_a(DIAGONAL, (Comparable)((Object)SpiralBrickBlock.getDiagonalFromPlayerPlacement((LivingEntity)context.func_195999_j(), context.func_196000_l())));
    }

    private static Diagonals getDiagonalFromPlayerPlacement(LivingEntity placer, Direction facing) {
        int angleX = (int)((placer.field_70125_A + 180.0f) / 180.0f) & 1;
        int angleY = (int)((placer.field_70177_z + 180.0f) / 90.0f) & 3;
        switch (facing) {
            case DOWN: 
            case UP: {
                switch (angleY) {
                    default: {
                        return Diagonals.TOP_RIGHT;
                    }
                    case 1: {
                        return Diagonals.BOTTOM_RIGHT;
                    }
                    case 2: {
                        return Diagonals.BOTTOM_LEFT;
                    }
                    case 3: 
                }
                return Diagonals.TOP_LEFT;
            }
            case NORTH: {
                return Diagonals.getDiagonalFromUpDownLeftRight(SpiralBrickBlock.isEast(angleY), angleX < 1);
            }
            case SOUTH: {
                return Diagonals.getDiagonalFromUpDownLeftRight(!SpiralBrickBlock.isEast(angleY), angleX < 1);
            }
            case EAST: {
                return Diagonals.getDiagonalFromUpDownLeftRight(SpiralBrickBlock.isNorth(angleY), angleX < 1);
            }
            case WEST: {
                return Diagonals.getDiagonalFromUpDownLeftRight(!SpiralBrickBlock.isNorth(angleY), angleX < 1);
            }
        }
        return Diagonals.TOP_RIGHT;
    }

    private static boolean isNorth(int intIn) {
        return intIn == 0 || intIn == 3;
    }

    private static boolean isEast(int intIn) {
        return intIn == 0 || intIn == 1;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        if (rot == Rotation.NONE) {
            return state;
        }
        Direction.Axis axis = (Direction.Axis)state.func_177229_b(AXIS_FACING);
        if (axis == Direction.Axis.Y) {
            return (BlockState)state.func_206870_a(DIAGONAL, (Comparable)((Object)Diagonals.rotate((Diagonals)((Object)state.func_177229_b(DIAGONAL)), rot)));
        }
        if (rot == Rotation.CLOCKWISE_180 || axis == Direction.Axis.X && rot == Rotation.COUNTERCLOCKWISE_90 || axis == Direction.Axis.Z && rot == Rotation.CLOCKWISE_90) {
            state = (BlockState)state.func_206870_a(DIAGONAL, (Comparable)((Object)Diagonals.mirror((Diagonals)((Object)state.func_177229_b(DIAGONAL)), Mirror.LEFT_RIGHT)));
        }
        return rot.ordinal() % 2 == 0 ? state : (BlockState)state.func_206870_a(AXIS_FACING, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
    }

    @Deprecated
    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a(DIAGONAL, (Comparable)((Object)Diagonals.mirrorOn((Direction.Axis)state.func_177229_b(AXIS_FACING), (Diagonals)((Object)state.func_177229_b(DIAGONAL)), mirrorIn)));
    }
}

