/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import twilightforest.TFSounds;
import twilightforest.client.particle.TFParticleType;
import twilightforest.enums.BossVariant;
import twilightforest.item.TFItems;
import twilightforest.tileentity.TrophyTileEntity;

public abstract class AbstractTrophyBlock
extends ContainerBlock {
    private final BossVariant variant;
    private final int comparatorValue;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    protected AbstractTrophyBlock(BossVariant variant, int value, AbstractBlock.Properties builder) {
        super(builder);
        this.variant = variant;
        this.comparatorValue = value;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public int getComparatorValue() {
        return this.comparatorValue;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = worldIn.func_175640_z(pos)) != (Boolean)state.func_177229_b((Property)POWERED)) {
            if (flag) {
                this.playSound(worldIn, pos);
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hit) {
        this.playSound(worldIn, pos);
        this.createParticle(worldIn, pos);
        return ActionResultType.SUCCESS;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TrophyTileEntity();
    }

    public BossVariant getVariant() {
        return this.variant;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }

    public void playSound(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te instanceof TrophyTileEntity) {
            SoundEvent sound = null;
            float volume = 1.0f;
            float pitch = 0.9f;
            switch (this.variant) {
                case NAGA: {
                    sound = TFSounds.NAGA_RATTLE;
                    volume = 1.25f;
                    pitch = 1.2f;
                    break;
                }
                case LICH: {
                    sound = TFSounds.LICH_AMBIENT;
                    volume = 0.35f;
                    pitch = 1.1f;
                    break;
                }
                case HYDRA: {
                    sound = TFSounds.HYDRA_GROWL;
                    pitch = 1.2f;
                    break;
                }
                case UR_GHAST: {
                    sound = TFSounds.URGHAST_AMBIENT;
                    pitch = 0.6f;
                    break;
                }
                case SNOW_QUEEN: {
                    sound = TFSounds.SNOW_QUEEN_AMBIENT;
                    break;
                }
                case KNIGHT_PHANTOM: {
                    sound = TFSounds.PHANTOM_AMBIENT;
                    pitch = 1.1f;
                    break;
                }
                case MINOSHROOM: {
                    sound = TFSounds.MINOSHROOM_AMBIENT;
                    volume = 0.75f;
                    pitch = 0.7f;
                    break;
                }
                case ALPHA_YETI: {
                    sound = world.field_73012_v.nextInt(50) == 0 ? TFSounds.ALPHAYETI_ROAR : TFSounds.ALPHAYETI_GROWL;
                    volume = 0.75f;
                    pitch = 0.75f;
                    break;
                }
                case QUEST_RAM: {
                    sound = TFSounds.QUEST_RAM_AMBIENT;
                    pitch = 0.7f;
                    break;
                }
            }
            if (sound != null) {
                world.func_184133_a((PlayerEntity)null, pos, sound, SoundCategory.BLOCKS, volume, world.field_73012_v.nextFloat() * 0.1f + pitch);
            }
        }
    }

    public void createParticle(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrophyTileEntity) {
            Random rand = world.func_201674_k();
            if (world instanceof ServerWorld) {
                switch (this.variant) {
                    case NAGA: {
                        for (int daze = 0; daze < 10; ++daze) {
                            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197614_g, (double)pos.func_177958_n() + (double)rand.nextFloat() * 0.5 * 2.0, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + (double)rand.nextFloat() * 0.5 * 2.0, 1, 0.0, 0.0, 0.0, rand.nextGaussian() * 0.02);
                        }
                        break;
                    }
                    case LICH: {
                        for (int a = 0; a < 5; ++a) {
                            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197609_b, (double)pos.func_177958_n() + (double)rand.nextFloat() * 0.5 * 2.0, (double)pos.func_177956_o() + 0.5 + (double)rand.nextFloat() * 0.25, (double)pos.func_177952_p() + (double)rand.nextFloat() * 0.5 * 2.0, 1, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02, 0.0);
                        }
                        break;
                    }
                    case MINOSHROOM: {
                        for (int g = 0; g < 10; ++g) {
                            ((ServerWorld)world).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, world.func_180495_p(pos.func_177977_b())), (double)pos.func_177958_n() + (double)(rand.nextFloat() * 10.0f) - 5.0, (double)pos.func_177956_o() + (double)0.1f + (double)(rand.nextFloat() * 0.3f), (double)pos.func_177952_p() + (double)(rand.nextFloat() * 10.0f) - 5.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case KNIGHT_PHANTOM: {
                        for (int brek = 0; brek < 10; ++brek) {
                            ((ServerWorld)world).func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)TFItems.knightmetal_sword.get())), (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5), (double)((float)pos.func_177956_o() + rand.nextFloat()) + 0.5, (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5), 1, 0.0, 0.25, 0.0, 0.0);
                        }
                        break;
                    }
                    case UR_GHAST: {
                        for (int red = 0; red < 10; ++red) {
                            ((ServerWorld)world).func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + rand.nextDouble() * 1.0 - 0.25, (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5, (double)pos.func_177952_p() + rand.nextDouble() * 1.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case ALPHA_YETI: {
                        for (int sweat = 0; sweat < 10; ++sweat) {
                            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_218422_X, (double)pos.func_177958_n() + rand.nextDouble() * 1.0 - 0.25, (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5, (double)pos.func_177952_p() + rand.nextDouble() * 1.0, 1, 0.0, 0.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case SNOW_QUEEN: {
                        for (int b = 0; b < 20; ++b) {
                            ((ServerWorld)world).func_195598_a((IParticleData)TFParticleType.SNOW_WARNING.get(), (double)pos.func_177958_n() - 1.0 + rand.nextDouble() * 3.25, (double)pos.func_177956_o() + 5.0, (double)pos.func_177952_p() - 1.0 + rand.nextDouble() * 3.25, 1, 0.0, 1.0, 0.0, 0.0);
                        }
                        break;
                    }
                    case QUEST_RAM: {
                        for (int p = 0; p < 10; ++p) {
                            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197625_r, (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5), (double)pos.func_177956_o() + (rand.nextDouble() - 0.5), (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5), 1, (double)rand.nextFloat(), (double)rand.nextFloat(), (double)rand.nextFloat(), 1.0);
                        }
                        break;
                    }
                }
            }
        }
    }
}

