/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.customgamerules.event;

import com.lothrazar.customgamerules.PacketHungerRuleSync;
import com.lothrazar.customgamerules.RuleRegistry;
import com.lothrazar.customgamerules.util.UtilWorld;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.EyeOfEnderEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class RuleEvents {
    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getPlayer().field_70170_p;
        if (RuleRegistry.isEnabled(event.getWorld(), RuleRegistry.disablePortalCreationEnd) && world.func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150378_br && event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == Items.field_151061_bv) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPortalSpawnEvent(BlockEvent.PortalSpawnEvent event) {
        if (RuleRegistry.isEnabled(event.getWorld(), RuleRegistry.disablePortalCreationNether)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityStruckByLightningEvent(EntityStruckByLightningEvent event) {
        Entity target = event.getEntity();
        if (RuleRegistry.isEnabled(target.field_70170_p, RuleRegistry.disableLightningTransform)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        LivingEntity attacker = event.getEntityLiving();
        if (event.getTarget() instanceof PlayerEntity && RuleRegistry.isEnabled(attacker.field_70170_p, RuleRegistry.disableTargetingPlayers)) {
            attacker.func_70604_c(null);
            attacker.func_130011_c(null);
            if (attacker instanceof MobEntity) {
                MobEntity mob = (MobEntity)attacker;
                mob.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public void onFarmlandTrampleEvent(BlockEvent.FarmlandTrampleEvent event) {
        if (RuleRegistry.isEnabled(event.getWorld(), RuleRegistry.disableFarmlandTrampling)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onFluidPlaceBlockEvent(BlockEvent.FluidPlaceBlockEvent event) {
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        World world = (World)event.getWorld();
        Block newBlock = event.getNewState().func_177230_c();
        if (newBlock == Blocks.field_150343_Z && RuleRegistry.isEnabled(world, RuleRegistry.disableGenerateObsidian)) {
            event.setNewState(event.getOriginalState());
        }
        if ((newBlock == Blocks.field_150347_e || newBlock == Blocks.field_150348_b) && RuleRegistry.isEnabled(world, RuleRegistry.disableGenerateStone)) {
            event.setNewState(event.getOriginalState());
        }
    }

    @SubscribeEvent
    public void onPlayerXpEvent(PlayerXpEvent event) {
        PlayerEntity player = event.getPlayer();
        if (RuleRegistry.isEnabled(player.field_70170_p, RuleRegistry.doInstantExp) && player.field_71090_bL > 0) {
            player.field_71090_bL = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlayEvent(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.FOOD) {
            boolean hide;
            boolean bl = hide = RuleRegistry.isEnabled(Minecraft.func_71410_x().field_71439_g.field_70170_p, RuleRegistry.disableHunger) || Minecraft.func_71410_x().field_71439_g.getPersistentData().func_74767_n("disableHungerHACK");
            if (hide) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        boolean disableHunger = RuleRegistry.isEnabled(player.field_70170_p, RuleRegistry.disableHunger);
        if (System.currentTimeMillis() % 40L == 0L && !player.field_70170_p.field_72995_K) {
            RuleRegistry.sendToAllClients(player.field_70170_p, new PacketHungerRuleSync(disableHunger));
        }
        if (disableHunger && player.func_71024_bL().func_75121_c()) {
            player.func_71024_bL().func_75122_a(1, 1.0f);
        }
    }

    @SubscribeEvent
    public void onLivingEntityUseItemEvent(LivingEntityUseItemEvent.Tick event) {
        Entity entity = event.getEntity();
        if (event.getItem().func_222117_E() && RuleRegistry.isEnabled(entity.field_70170_p, RuleRegistry.doInstantEating) && event.getDuration() > 0) {
            event.setDuration(1);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (RuleRegistry.isEnabled(event.getWorld(), RuleRegistry.disableVillagerTrading) && event.getEntity() instanceof PlayerEntity && event.getTarget() instanceof VillagerEntity) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        MobEntity mob;
        if (RuleRegistry.isEnabled(event.getWorld(), RuleRegistry.disableMobItemPickup) && event.getEntity() instanceof MobEntity && (mob = (MobEntity)event.getEntity()).func_98052_bS()) {
            mob.func_98053_h(false);
        }
    }

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (!RuleRegistry.isEnabled(event.getWorld(), RuleRegistry.doArmorStandWeapons)) {
            return;
        }
        if (event.getTarget() == null || !(event.getTarget() instanceof ArmorStandEntity)) {
            return;
        }
        ArmorStandEntity stand = (ArmorStandEntity)event.getTarget();
        PlayerEntity player = event.getPlayer();
        if (!player.func_225608_bj_()) {
            return;
        }
        event.setCanceled(true);
        this.swapArmorStand(stand, player, Hand.MAIN_HAND);
        this.swapArmorStand(stand, player, Hand.OFF_HAND);
        boolean showArms = !stand.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() || !stand.func_184582_a(EquipmentSlotType.OFFHAND).func_190926_b();
        stand.func_175413_k(showArms);
    }

    private void swapArmorStand(ArmorStandEntity stand, PlayerEntity player, Hand hand) {
        ItemStack heldPlayer = player.func_184586_b(hand).func_77946_l();
        ItemStack heldStand = stand.func_184586_b(hand).func_77946_l();
        EquipmentSlotType slot = hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
        stand.func_184201_a(slot, heldPlayer);
        player.func_184201_a(slot, heldStand);
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        Entity entity = event.getEntity();
        if (RuleRegistry.isEnabled(entity.field_70170_p, RuleRegistry.doFriendlyIronGolems) && event.getEntityLiving() instanceof IronGolemEntity && event.getEntityLiving().func_94060_bK() instanceof PlayerEntity) {
            IronGolemEntity golem = (IronGolemEntity)event.getEntityLiving();
            golem.func_70624_b(null);
            golem.func_70604_c(null);
            golem.func_130011_c(null);
        }
        if (entity.field_70137_T > 128.0 && UtilWorld.dimensionToString(entity.field_70170_p).equalsIgnoreCase("minecraft:the_nether") && RuleRegistry.isEnabled(entity.field_70170_p, RuleRegistry.doNetherVoidAbove) && entity.func_70089_S()) {
            entity.func_70097_a(DamageSource.field_76380_i, 0.5f);
        }
    }

    @SubscribeEvent
    public void onNonLivingEntityTick(EntityEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || entity.field_70170_p == null) {
            return;
        }
        if (entity instanceof EyeOfEnderEntity) {
            EyeOfEnderEntity eye = (EyeOfEnderEntity)event.getEntity();
            if (eye.field_70221_f && RuleRegistry.isEnabled(eye.field_70170_p, RuleRegistry.doEyesAlwaysBreak)) {
                eye.field_70221_f = false;
            }
        }
    }

    @SubscribeEvent
    public void onCropGrowEvent(BlockEvent.CropGrowEvent.Pre event) {
        if (RuleRegistry.isEnabled(event.getWorld(), RuleRegistry.disableCropGrowth)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTreeEvent(SaplingGrowTreeEvent event) {
        if (event.getWorld() instanceof World && RuleRegistry.isEnabled((World)event.getWorld(), RuleRegistry.disableSaplingGrowth)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onCriticalHitEvent(CriticalHitEvent event) {
        World world = event.getEntity().field_70170_p;
        if (event.isVanillaCritical() && RuleRegistry.isEnabled(world, RuleRegistry.disableCriticalHits)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEnderTeleportEvent(EnderTeleportEvent event) {
        World world = event.getEntity().field_70170_p;
        if (event.getEntityLiving() instanceof EndermanEntity && RuleRegistry.isEnabled(world, RuleRegistry.disableEndermanTeleport)) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving() instanceof ShulkerEntity && RuleRegistry.isEnabled(world, RuleRegistry.disableShulkerTeleport)) {
            event.setCanceled(true);
        }
        if (event.getEntityLiving() instanceof PlayerEntity && !RuleRegistry.isEnabled(world, RuleRegistry.pearlDamage)) {
            event.setAttackDamage(0.0f);
        }
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingAttackEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        if (RuleRegistry.isEnabled(world, RuleRegistry.disablePetFriendlyFire) && event.getSource().func_76346_g() instanceof PlayerEntity) {
            TameableEntity pet;
            AbstractHorseEntity horse;
            PlayerEntity dmgOwner = (PlayerEntity)event.getSource().func_76346_g();
            if (event.getEntityLiving() instanceof AbstractHorseEntity && (horse = (AbstractHorseEntity)event.getEntityLiving()).func_110248_bS() && horse.func_184780_dh() != null && horse.func_184780_dh().equals(dmgOwner.func_110124_au())) {
                event.setCanceled(true);
            }
            if (event.getEntityLiving() instanceof TameableEntity && (pet = (TameableEntity)event.getEntityLiving()).func_70909_n() && pet.func_184753_b() != null && pet.func_184753_b().equals(dmgOwner.func_110124_au())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamageEvent(LivingDamageEvent event) {
        World world = event.getEntityLiving().field_70170_p;
        if (event.getSource() == DamageSource.field_76368_d && !RuleRegistry.isEnabled(world, RuleRegistry.suffocationDamage)) {
            event.setCanceled(true);
        }
        if (event.getSource() == DamageSource.field_76367_g && !RuleRegistry.isEnabled(world, RuleRegistry.cactusDamage)) {
            event.setCanceled(true);
        }
        if (event.getSource() == DamageSource.field_220302_v && !RuleRegistry.isEnabled(world, RuleRegistry.berryDamage)) {
            event.setCanceled(true);
        }
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (event.getSource() == DamageSource.field_76379_h && RuleRegistry.isEnabled(world, RuleRegistry.doLilypadsBreak) && world.func_180495_p(player.func_233580_cy_()).func_177230_c() == Blocks.field_196651_dG) {
            world.func_225521_a_(player.func_233580_cy_(), true, (Entity)player);
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public void onEntityMobGriefingEvent(EntityMobGriefingEvent event) {
        if (event == null || event.getEntity() == null || event.getEntity().field_70170_p == null) {
            return;
        }
        Entity ent = event.getEntity();
        World world = ent.field_70170_p;
        if (!RuleRegistry.isEnabled(world, (GameRules.RuleKey<GameRules.BooleanValue>)GameRules.field_223599_b)) {
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingSnowgolem) && ent instanceof SnowGolemEntity) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingCreeper) && ent instanceof CreeperEntity) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingZombie) && ent instanceof ZombieEntity) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingEnderman) && ent instanceof EndermanEntity) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingWither) && (ent instanceof WitherEntity || ent instanceof WitherSkullEntity)) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingRavager) && ent instanceof RavagerEntity) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingSilverfish) && ent instanceof SilverfishEntity) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingGhast) && (ent instanceof FireballEntity || ent instanceof GhastEntity)) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingBlaze) && ent instanceof SmallFireballEntity) {
            event.setResult(Event.Result.DENY);
            return;
        }
        if (!RuleRegistry.isEnabled(world, RuleRegistry.mobGriefingVillager) && ent instanceof VillagerEntity) {
            event.setResult(Event.Result.DENY);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerDeath(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        World world = player.field_70170_p;
        if (RuleRegistry.isEnabled(world, (GameRules.RuleKey<GameRules.BooleanValue>)GameRules.field_223600_c) && RuleRegistry.isEnabled(world, RuleRegistry.keepInventoryExperience)) {
            player.field_71106_cc = 0.0f;
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
        }
    }

    @SubscribeEvent
    public void onPlayerDrops(LivingDropsEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        World world = player.field_70170_p;
        if (RuleRegistry.isEnabled(world, (GameRules.RuleKey<GameRules.BooleanValue>)GameRules.field_223600_c) && RuleRegistry.isEnabled(world, RuleRegistry.keepInventoryArmor)) {
            for (ItemStack is : player.func_184193_aE()) {
                event.getDrops().add(new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), is.func_77946_l()));
                is.func_190920_e(0);
            }
        }
    }
}

