/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.core.endimator;

import com.google.common.collect.Maps;
import com.minecraftabnormals.abnormals_core.client.ClientInfo;
import com.minecraftabnormals.abnormals_core.core.AbnormalsCore;
import com.minecraftabnormals.abnormals_core.core.endimator.Endimation;
import com.minecraftabnormals.abnormals_core.core.endimator.entity.EndimatorModelRenderer;
import com.minecraftabnormals.abnormals_core.core.endimator.entity.IEndimatedEntity;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public final class Endimator<E extends Entity> {
    private final Map<EndimatorModelRenderer, BoxValues> prevBoxValues = Maps.newHashMap();
    private final Map<EndimatorModelRenderer, BoxValues> boxValues = Maps.newHashMap();
    private E entity;
    private int prevTickDuration;
    private int tickDuration;

    public void tick(E entity) {
        this.entity = entity;
        this.prevTickDuration = 0;
        this.tickDuration = 0;
        this.prevBoxValues.clear();
        this.boxValues.clear();
    }

    public void setEndimationToPlay(Endimation endimationToPlay) {
        this.updateBoxValueMap();
        this.prevTickDuration = 0;
        this.tickDuration = 0;
        if (((IEndimatedEntity)this.entity).getPlayingEndimation() != endimationToPlay) {
            AbnormalsCore.LOGGER.warn("Endimation to be played doesn't match the Endimation playing on the entity!");
        }
    }

    public boolean tryToPlayEndimation(Endimation endimationToPlay) {
        if (((IEndimatedEntity)this.entity).isEndimationPlaying(endimationToPlay)) {
            this.setEndimationToPlay(endimationToPlay);
            return true;
        }
        return false;
    }

    public void startKeyframe(int tickDuration) {
        this.prevTickDuration = this.tickDuration;
        this.tickDuration += tickDuration;
    }

    public void setStaticKeyframe(int tickDuration) {
        this.startKeyframe(tickDuration);
        if (this.shouldEndimateBoxes()) {
            this.prevBoxValues.forEach((endimatorModelRenderer, values) -> values.addValuesToBox((EndimatorModelRenderer)((Object)endimatorModelRenderer)));
        }
    }

    public void endKeyframe() {
        if (this.shouldEndimateBoxes()) {
            float increment = MathHelper.func_76126_a((float)((float)((double)(((float)(((IEndimatedEntity)this.entity).getAnimationTick() - this.prevTickDuration) + ClientInfo.getPartialTicks()) / (float)(this.tickDuration - this.prevTickDuration)) * Math.PI / 2.0)));
            this.prevBoxValues.forEach((endimatorModelRenderer, prevValues) -> prevValues.addValuesToBoxWithMultiplier((EndimatorModelRenderer)((Object)endimatorModelRenderer), 1.0f - increment));
            this.boxValues.forEach((endimatorModelRenderer, values) -> values.addValuesToBoxWithMultiplier((EndimatorModelRenderer)((Object)endimatorModelRenderer), increment));
        }
        this.updateBoxValueMap();
    }

    public void resetKeyframe(int tickDuration) {
        this.startKeyframe(tickDuration);
        this.endKeyframe();
    }

    public void move(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).setPosition(x, y, z);
    }

    public void moveAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).addPosition(x, y, z);
    }

    public void offset(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).setOffset(x, y, z);
    }

    public void offsetAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).addOffset(x, y, z);
    }

    public void rotate(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).setRotation(x, y, z);
    }

    public void rotateAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).addRotation(x, y, z);
    }

    public void scale(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).setScale(x, y, z);
    }

    public void scaleAdditive(EndimatorModelRenderer model, float x, float y, float z) {
        this.getBoxValues(model).addScale(x, y, z);
    }

    private boolean shouldEndimateBoxes() {
        int animationTick = ((IEndimatedEntity)this.entity).getAnimationTick();
        return animationTick < this.tickDuration && animationTick >= this.prevTickDuration;
    }

    public BoxValues getBoxValues(EndimatorModelRenderer model) {
        return this.boxValues.computeIfAbsent(model, modelRenderer -> new BoxValues());
    }

    private void updateBoxValueMap() {
        this.prevBoxValues.clear();
        this.prevBoxValues.putAll(this.boxValues);
        this.boxValues.clear();
    }

    public static class BoxValues {
        private float posX;
        private float posY;
        private float posZ;
        private float offsetX;
        private float offsetY;
        private float offsetZ;
        private float angleX;
        private float angleY;
        private float angleZ;
        private float scaleX;
        private float scaleY;
        private float scaleZ;

        public BoxValues(float posX, float posY, float posZ, float offsetX, float offsetY, float offsetZ, float angleX, float angleY, float angleZ, float scaleX, float scaleY, float scaleZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.angleX = angleX;
            this.angleY = angleY;
            this.angleZ = angleZ;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.scaleZ = scaleZ;
        }

        public BoxValues() {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        public void setPosition(float posX, float posY, float posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
        }

        public void addPosition(float posX, float posY, float posZ) {
            this.posX += posX;
            this.posY += posY;
            this.posZ += posZ;
        }

        public void setOffset(float offsetX, float offsetY, float offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }

        public void addOffset(float offsetX, float offsetY, float offsetZ) {
            this.offsetX += offsetX;
            this.offsetY += offsetY;
            this.offsetZ += offsetZ;
        }

        public void setRotation(float angleX, float angleY, float angleZ) {
            this.angleX = angleX;
            this.angleY = angleY;
            this.angleZ = angleZ;
        }

        public void addRotation(float angleX, float angleY, float angleZ) {
            this.angleX += angleX;
            this.angleY += angleY;
            this.angleZ += angleZ;
        }

        public void setScale(float scaleX, float scaleY, float scaleZ) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.scaleZ = scaleZ;
        }

        public void addScale(float scaleX, float scaleY, float scaleZ) {
            this.scaleX += scaleX;
            this.scaleY += scaleY;
            this.scaleZ += scaleZ;
        }

        public void addValuesToBox(EndimatorModelRenderer modelRenderer) {
            modelRenderer.field_78800_c += this.posX;
            modelRenderer.field_78797_d += this.posY;
            modelRenderer.field_78798_e += this.posZ;
            modelRenderer.offsetX += this.offsetX;
            modelRenderer.offsetY += this.offsetY;
            modelRenderer.offsetZ += this.offsetZ;
            modelRenderer.field_78795_f += this.angleX;
            modelRenderer.field_78796_g += this.angleY;
            modelRenderer.field_78808_h += this.angleZ;
            modelRenderer.scaleX += this.scaleX;
            modelRenderer.scaleY += this.scaleY;
            modelRenderer.scaleZ += this.scaleZ;
        }

        public void addValuesToBoxWithMultiplier(EndimatorModelRenderer modelRenderer, float multiplier) {
            modelRenderer.field_78800_c += multiplier * this.posX;
            modelRenderer.field_78797_d += multiplier * this.posY;
            modelRenderer.field_78798_e += multiplier * this.posZ;
            modelRenderer.offsetX += multiplier * this.offsetX;
            modelRenderer.offsetY += multiplier * this.offsetY;
            modelRenderer.offsetZ += multiplier * this.offsetZ;
            modelRenderer.field_78795_f += multiplier * this.angleX;
            modelRenderer.field_78796_g += multiplier * this.angleY;
            modelRenderer.field_78808_h += multiplier * this.angleZ;
            modelRenderer.scaleX += multiplier * this.scaleX;
            modelRenderer.scaleY += multiplier * this.scaleY;
            modelRenderer.scaleZ += multiplier * this.scaleZ;
        }
    }
}

