/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.loot.modification;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecraftabnormals.abnormals_core.common.loot.modification.LootModifiers;
import com.minecraftabnormals.abnormals_core.core.AbnormalsCore;
import com.minecraftabnormals.abnormals_core.core.util.modification.ModificationManager;
import com.minecraftabnormals.abnormals_core.core.util.modification.TargetedModifier;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootPredicateManager;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.RandomRanges;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="abnormals_core")
public final class LootModificationManager
extends ModificationManager<LootTableLoadEvent, Gson, Pair<Gson, LootPredicateManager>> {
    private static final Gson GSON = LootSerializers.func_237388_c_().registerTypeAdapter(LootPool.class, (Object)new LootPoolSerializer()).create();
    private static LootModificationManager INSTANCE = null;
    private final LootPredicateManager lootPredicateManager;

    private LootModificationManager(LootPredicateManager lootPredicateManager) {
        super(GSON, "modifiers/loot_tables");
        this.lootPredicateManager = lootPredicateManager;
    }

    public static LootModificationManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        List configuredModifiers = INSTANCE.getModifiers(event.getName());
        if (configuredModifiers != null) {
            configuredModifiers.forEach(configuredModifier -> configuredModifier.modify(event));
        }
    }

    @SubscribeEvent
    public static void onReloadListener(AddReloadListenerEvent event) {
        List initTaskQueue;
        DataPackRegistries dataPackRegistries = event.getDataPackRegistries();
        INSTANCE = new LootModificationManager(dataPackRegistries.func_240964_b_());
        SimpleReloadableResourceManager simpleReloadableResourceManager = (SimpleReloadableResourceManager)dataPackRegistries.func_240970_h_();
        List reloadListeners = (List)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)simpleReloadableResourceManager, (String)"field_199015_d");
        if (reloadListeners != null) {
            reloadListeners.add(2, INSTANCE);
        }
        if ((initTaskQueue = (List)ObfuscationReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)simpleReloadableResourceManager, (String)"field_219539_d")) != null) {
            initTaskQueue.add(2, INSTANCE);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, IResourceManager resourceManager, IProfiler profiler) {
        this.reset();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation resourcelocation = entry.getKey();
            if (resourcelocation.func_110623_a().startsWith("_")) continue;
            try {
                TargetedModifier<LootTableLoadEvent, Gson, Pair<Gson, LootPredicateManager>> targetedModifier = TargetedModifier.deserialize(entry.getValue().getAsJsonObject(), Pair.of((Object)GSON, (Object)this.lootPredicateManager), LootModifiers.REGISTRY);
                this.addModifiers(targetedModifier.getTarget(), targetedModifier.getConfiguredModifiers());
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                AbnormalsCore.LOGGER.error("Parsing error loading Loot Modifier: {}", (Object)resourcelocation, (Object)jsonparseexception);
            }
        }
        AbnormalsCore.LOGGER.info("Loot Modification Manager has loaded {} sets of modifiers", (Object)this.size());
    }

    static class LootPoolSerializer
    extends LootPool.Serializer {
        private static Constructor<LootPool> LOOT_POOL_CONSTRUCTOR;

        LootPoolSerializer() {
        }

        public LootPool deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_deserialize_1_, (String)"loot pool");
            LootEntry[] alootentry = (LootEntry[])JSONUtils.func_188174_a((JsonObject)jsonobject, (String)"entries", (JsonDeserializationContext)p_deserialize_3_, LootEntry[].class);
            ILootCondition[] ailootcondition = (ILootCondition[])JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"conditions", (Object)new ILootCondition[0], (JsonDeserializationContext)p_deserialize_3_, ILootCondition[].class);
            ILootFunction[] ailootfunction = (ILootFunction[])JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"functions", (Object)new ILootFunction[0], (JsonDeserializationContext)p_deserialize_3_, ILootFunction[].class);
            IRandomRange irandomrange = RandomRanges.func_216130_a((JsonElement)jsonobject.get("rolls"), (JsonDeserializationContext)p_deserialize_3_);
            RandomValueRange randomvaluerange = (RandomValueRange)JSONUtils.func_188177_a((JsonObject)jsonobject, (String)"bonus_rolls", (Object)new RandomValueRange(0.0f, 0.0f), (JsonDeserializationContext)p_deserialize_3_, RandomValueRange.class);
            if (jsonobject.has("name")) {
                try {
                    return LOOT_POOL_CONSTRUCTOR.newInstance(alootentry, ailootcondition, ailootfunction, irandomrange, randomvaluerange, JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"name"));
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    e.printStackTrace();
                    throw new JsonParseException("Could not initialize a new loot pool: " + e);
                }
            }
            throw new JsonParseException("Missing name for loot pool!");
        }

        static {
            try {
                LOOT_POOL_CONSTRUCTOR = LootPool.class.getDeclaredConstructor(LootEntry[].class, ILootCondition[].class, ILootFunction[].class, IRandomRange.class, RandomValueRange.class, String.class);
                LOOT_POOL_CONSTRUCTOR.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }
}

