/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers;

import com.google.common.collect.Maps;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.AdvancementModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers.CriteriaModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers.DisplayInfoModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers.IndexedRequirementsModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers.ParentModifier;
import com.minecraftabnormals.abnormals_core.common.advancement.modification.modifiers.RewardsModifier;
import java.util.Map;
import javax.annotation.Nullable;

public final class AdvancementModifiers {
    private static final Map<String, AdvancementModifier<?>> REGISTRY = Maps.newHashMap();
    public static final ParentModifier PARENT_MODIFIER = AdvancementModifiers.register("parent", new ParentModifier());
    public static final RewardsModifier REWARDS_MODIFIER = AdvancementModifiers.register("rewards", new RewardsModifier());
    public static final DisplayInfoModifier DISPLAY_INFO_MODIFIER = AdvancementModifiers.register("display", new DisplayInfoModifier());
    public static final CriteriaModifier CRITERIA_MODIFIER = AdvancementModifiers.register("criteria", new CriteriaModifier());
    public static final IndexedRequirementsModifier INDEXED_REQUIREMENTS_MODIFIER = AdvancementModifiers.register("indexed_requirements", new IndexedRequirementsModifier());
    public static final EffectsChangedModifier EFFECTS_CHANGED_MODIFIER = AdvancementModifiers.register("effects_changed", new EffectsChangedModifier());

    public static synchronized <C, M extends AdvancementModifier<C>> M register(String name, M modifier) {
        if (REGISTRY.containsKey(name)) {
            throw new IllegalArgumentException("A modifier with name '" + name + "' is already registered!");
        }
        REGISTRY.put(name, modifier);
        return modifier;
    }

    @Nullable
    public static AdvancementModifier<?> getModifier(String name) {
        return REGISTRY.get(name);
    }
}

