/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.materials;

import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.instancing.InstanceData;
import com.jozufozu.flywheel.backend.instancing.Instancer;
import com.jozufozu.flywheel.core.materials.IFlatLight;

public abstract class BasicData
extends InstanceData
implements IFlatLight<BasicData> {
    protected byte blockLight;
    protected byte skyLight;
    protected byte r = (byte)-1;
    protected byte g = (byte)-1;
    protected byte b = (byte)-1;
    protected byte a = (byte)-1;

    public BasicData(Instancer<?> owner) {
        super(owner);
    }

    @Override
    public BasicData setBlockLight(int blockLight) {
        this.blockLight = (byte)(blockLight << 4);
        this.markDirty();
        return this;
    }

    @Override
    public BasicData setSkyLight(int skyLight) {
        this.skyLight = (byte)(skyLight << 4);
        this.markDirty();
        return this;
    }

    public BasicData setColor(int color) {
        return this.setColor(color, false);
    }

    public BasicData setColor(int color, boolean alpha) {
        byte r = (byte)(color >> 16 & 0xFF);
        byte g = (byte)(color >> 8 & 0xFF);
        byte b = (byte)(color & 0xFF);
        if (alpha) {
            byte a = (byte)(color >> 24 & 0xFF);
            return this.setColor(r, g, b, a);
        }
        return this.setColor(r, g, b);
    }

    public BasicData setColor(int r, int g, int b) {
        return this.setColor((byte)r, (byte)g, (byte)b);
    }

    public BasicData setColor(byte r, byte g, byte b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.markDirty();
        return this;
    }

    public BasicData setColor(byte r, byte g, byte b, byte a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.markDirty();
        return this;
    }

    @Override
    public void write(MappedBuffer buf) {
        buf.putByteArray(new byte[]{this.blockLight, this.skyLight, this.r, this.g, this.b, this.a});
    }
}

