/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.pyramid;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.blocks.QuandaryBlock;
import com.teammetallurgy.atum.blocks.SandLayersBlock;
import com.teammetallurgy.atum.blocks.base.ChestBaseBlock;
import com.teammetallurgy.atum.blocks.lighting.AtumTorchUnlitBlock;
import com.teammetallurgy.atum.blocks.stone.limestone.LimestoneBrickBlock;
import com.teammetallurgy.atum.blocks.trap.TrapBlock;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.init.AtumStructurePieces;
import com.teammetallurgy.atum.world.gen.structure.StructureHelper;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinPieces;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class PyramidPieces {
    public static final ResourceLocation PYRAMID = new ResourceLocation("atum", "pyramid");
    private static final int MAZE_SIZE_X = 27;
    private static final int MAZE_SIZE_Z = 25;

    static List<StructurePiece> getComponents(TemplateManager manager, BlockPos pos, Rotation rotation) {
        ArrayList components = Lists.newArrayList();
        PyramidTemplate template = new PyramidTemplate(manager, pos, rotation);
        Maze maze = new Maze(PyramidPieces.getMazeBounds(template.func_74874_b(), template.rotation), template.func_186165_e());
        components.add(template);
        components.add(maze);
        return components;
    }

    private static MutableBoundingBox getMazeBounds(MutableBoundingBox pyramidBounds, Rotation rotation) {
        int width = 27;
        int depth = 25;
        int xOffset = 2;
        int zOffset = 5;
        if (rotation == Rotation.CLOCKWISE_90) {
            zOffset = 2;
            width = 25;
            depth = 27;
        } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
            xOffset = 5;
            zOffset = 3;
            width = 25;
            depth = 27;
        } else if (rotation == Rotation.CLOCKWISE_180) {
            xOffset = 3;
            zOffset = 6;
        }
        return MutableBoundingBox.func_175899_a((int)(pyramidBounds.field_78897_a + xOffset), (int)(pyramidBounds.field_78895_b + 6), (int)(pyramidBounds.field_78896_c + zOffset), (int)(pyramidBounds.field_78897_a + xOffset + width - 1), (int)(pyramidBounds.field_78895_b + 7), (int)(pyramidBounds.field_78896_c + zOffset + depth - 1));
    }

    public static class Maze
    extends StructurePiece {
        private boolean[][] maze = null;

        public Maze(MutableBoundingBox boundingBox, Direction componentType) {
            super(AtumStructurePieces.PYRAMID_MAZE, 0);
            this.func_186164_a(componentType);
            this.field_74887_e = boundingBox;
        }

        public Maze(TemplateManager manager, CompoundNBT nbt) {
            super(AtumStructurePieces.PYRAMID_MAZE, nbt);
        }

        public boolean func_230383_a_(@Nonnull ISeedReader world, @Nonnull StructureManager manager, @Nonnull ChunkGenerator generator, @Nonnull Random random, @Nonnull MutableBoundingBox box, @Nonnull ChunkPos chunkPos, BlockPos pos) {
            this.addMaze(world, random, box);
            return true;
        }

        private void addMaze(ISeedReader world, Random random, MutableBoundingBox validBounds) {
            if (this.maze == null) {
                this.maze = this.generateMaze(new Random(world.func_72905_C() * (long)this.field_74887_e.field_78897_a * (long)this.field_74887_e.field_78896_c), this.field_74887_e.func_78883_b(), this.field_74887_e.func_78880_d());
            }
            for (int x = 0; x < this.field_74887_e.func_78883_b(); ++x) {
                for (int z = 0; z < this.field_74887_e.func_78880_d(); ++z) {
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, 0, z, validBounds);
                    this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, 1, z, validBounds);
                    if (this.func_175807_a((IBlockReader)world, x, -1, z, validBounds).func_177230_c() instanceof LadderBlock) {
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, 0, z, validBounds);
                        this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), x, 1, z, validBounds);
                        continue;
                    }
                    if (!this.maze[x][z]) {
                        this.func_175811_a(world, PyramidTemplate.CARVED_BRICK, x, 0, z, validBounds);
                        this.func_175811_a(world, PyramidTemplate.CARVED_BRICK, x, 1, z, validBounds);
                        if (!(random.nextDouble() <= 0.1)) continue;
                        this.placeTrap(world, this.maze, x, z, random, validBounds);
                        continue;
                    }
                    int layers = MathHelper.func_76136_a((Random)random, (int)1, (int)2);
                    this.func_175811_a(world, (BlockState)AtumBlocks.SAND_LAYERED.func_176223_P().func_206870_a((Property)SandLayersBlock.LAYERS, (Comparable)Integer.valueOf(layers)), x, 0, z, validBounds);
                }
            }
        }

        protected void func_175811_a(@Nonnull ISeedReader world, @Nonnull BlockState state, int x, int y, int z, @Nonnull MutableBoundingBox box) {
            BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (box.func_175898_b((Vector3i)pos) && !(world.func_180495_p(pos).func_177230_c() instanceof LadderBlock)) {
                super.func_175811_a(world, state, x, y, z, box);
            }
        }

        private void placeTrap(ISeedReader world, boolean[][] maze, int x, int z, Random random, MutableBoundingBox validBounds) {
            BlockState trapState = PyramidTemplate.FLOOR_TRAPS.get(random.nextInt(PyramidTemplate.FLOOR_TRAPS.size())).func_176223_P();
            ArrayList<Direction> validDirections = new ArrayList<Direction>();
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                if (x + facing.func_82601_c() < 0 || x + facing.func_82601_c() >= maze.length || z + facing.func_82599_e() < 0 || z + facing.func_82599_e() >= maze[0].length || !maze[x + facing.func_82601_c()][z + facing.func_82599_e()]) continue;
                validDirections.add(facing.func_176734_d());
            }
            if (!validDirections.isEmpty()) {
                trapState = (BlockState)trapState.func_206870_a((Property)TrapBlock.FACING, (Comparable)((Direction)validDirections.get(random.nextInt(validDirections.size()))));
                this.func_175811_a(world, trapState, x, 0, z, validBounds);
            }
        }

        private boolean[][] generateMaze(Random random, int sizeX, int sizeZ) {
            boolean[][] array = new boolean[sizeX][sizeZ];
            return this.generateMazeRecursive(array, random, 1, 1);
        }

        private boolean[][] generateMazeRecursive(boolean[][] array, Random random, int x, int z) {
            ArrayList<Pair> choices = new ArrayList<Pair>();
            do {
                int innerSizeX = array.length - 1;
                int innerSizeZ = array[0].length - 1;
                choices.clear();
                if (x + 2 < innerSizeX && !array[x + 2][z]) {
                    choices.add(new Pair(2, 0));
                }
                if (x - 2 >= 0 && !array[x - 2][z]) {
                    choices.add(new Pair(-2, 0));
                }
                if (z + 2 < innerSizeZ && !array[x][z + 2]) {
                    choices.add(new Pair(0, 2));
                }
                if (z - 2 >= 0 && !array[x][z - 2]) {
                    choices.add(new Pair(0, -2));
                }
                if (choices.size() <= 0) continue;
                int xMin = random.nextInt(choices.size());
                Pair choice = (Pair)choices.get(xMin);
                choices.remove(xMin);
                array[choice.x + x][choice.y + z] = true;
                array[x + choice.x / 2][z + choice.y / 2] = true;
                this.generateMazeRecursive(array, random, x + choice.x, z + choice.y);
            } while (choices.size() > 0);
            return array;
        }

        protected void func_143011_b(@Nonnull CompoundNBT compound) {
        }

        static class Pair {
            public int x;
            public int y;

            Pair(int x, int y) {
                this.x = x;
                this.y = y;
            }

            public boolean equals(Object p) {
                return p instanceof Pair && ((Pair)p).x == this.x && ((Pair)p).y == this.y;
            }
        }
    }

    public static class PyramidTemplate
    extends TemplateStructurePiece {
        public static final List<Block> FLOOR_TRAPS = Arrays.asList(AtumBlocks.BURNING_TRAP, AtumBlocks.POISON_TRAP, AtumBlocks.SMOKE_TRAP, AtumBlocks.TAR_TRAP);
        static final BlockState CARVED_BRICK = (BlockState)AtumBlocks.LIMESTONE_BRICK_CARVED.func_176223_P().func_206870_a((Property)LimestoneBrickBlock.UNBREAKABLE, (Comparable)Boolean.valueOf(true));
        private static final EntityType<?> UNDEAD_SPAWNER_PAIR = RuinPieces.RuinTemplate.UNDEAD.get(new Random().nextInt(RuinPieces.RuinTemplate.UNDEAD.size()));
        private final Rotation rotation;

        public PyramidTemplate(TemplateManager manager, BlockPos pos, Rotation rotation) {
            super(AtumStructurePieces.PYRAMID, 0);
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.loadTemplate(manager);
        }

        public PyramidTemplate(TemplateManager manager, CompoundNBT nbt) {
            super(AtumStructurePieces.PYRAMID, nbt);
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.loadTemplate(manager);
        }

        private void loadTemplate(TemplateManager templateManager) {
            Template template = templateManager.func_200219_b(PYRAMID);
            PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_186223_a(this.field_74887_e).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(@Nonnull String function, @Nonnull BlockPos pos, @Nonnull IServerWorld world, @Nonnull Random rand, @Nonnull MutableBoundingBox box) {
            if (function.startsWith("Arrow")) {
                Rotation rotation = this.field_186177_b.func_186215_c();
                BlockState arrowTrap = AtumBlocks.ARROW_TRAP.func_176223_P();
                if (rand.nextDouble() <= 0.3) {
                    switch (function) {
                        case "ArrowWest": {
                            arrowTrap = (BlockState)arrowTrap.func_206870_a((Property)TrapBlock.FACING, (Comparable)rotation.func_185831_a(Direction.WEST));
                            break;
                        }
                        case "ArrowEast": {
                            arrowTrap = (BlockState)arrowTrap.func_206870_a((Property)TrapBlock.FACING, (Comparable)rotation.func_185831_a(Direction.EAST));
                            break;
                        }
                        case "ArrowSouth": {
                            arrowTrap = (BlockState)arrowTrap.func_206870_a((Property)TrapBlock.FACING, (Comparable)rotation.func_185831_a(Direction.SOUTH));
                            break;
                        }
                        case "ArrowNorth": {
                            arrowTrap = (BlockState)arrowTrap.func_206870_a((Property)TrapBlock.FACING, (Comparable)rotation.func_185831_a(Direction.NORTH));
                        }
                    }
                    world.func_180501_a(pos, arrowTrap, 2);
                } else {
                    world.func_180501_a(pos, CARVED_BRICK, 2);
                }
            } else if (function.startsWith("Floor")) {
                switch (function) {
                    case "FloorTrap": {
                        if (rand.nextDouble() <= 0.5) {
                            Block trap = FLOOR_TRAPS.get(rand.nextInt(FLOOR_TRAPS.size()));
                            world.func_180501_a(pos, (BlockState)trap.func_176223_P().func_206870_a((Property)TrapBlock.FACING, (Comparable)Direction.UP), 2);
                            break;
                        }
                        world.func_180501_a(pos, CARVED_BRICK, 2);
                        break;
                    }
                    case "FloorCopy": {
                        this.setTrapsCopy((IWorld)world, pos, rand, box, 2);
                        break;
                    }
                    case "FloorBox": 
                    case "FloorSpace": {
                        this.setTrapsCopy((IWorld)world, pos, rand, box, 3);
                    }
                }
            } else if (function.contains("Spawner")) {
                if (function.equals("SpawnerUndead")) {
                    if (box.func_175898_b((Vector3i)pos)) {
                        world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                        TileEntity tileEntity = world.func_175625_s(pos);
                        if (tileEntity instanceof MobSpawnerTileEntity) {
                            EntityType<?> entityType = RuinPieces.RuinTemplate.UNDEAD.get(rand.nextInt(RuinPieces.RuinTemplate.UNDEAD.size()));
                            ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(entityType);
                        }
                    }
                } else if (function.equals("SpawnerUndeadPair") && box.func_175898_b((Vector3i)pos)) {
                    world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    if (tileEntity instanceof MobSpawnerTileEntity) {
                        ((MobSpawnerTileEntity)tileEntity).func_145881_a().func_200876_a(UNDEAD_SPAWNER_PAIR);
                    }
                }
            } else if (function.equals("CrateChance")) {
                if (box.func_175898_b((Vector3i)pos)) {
                    if (rand.nextDouble() <= 0.2) {
                        world.func_180501_a(pos, ChestBaseBlock.correctFacing((IBlockReader)world, pos, AtumBlocks.DEADWOOD_CRATE.func_176223_P(), AtumBlocks.DEADWOOD_CRATE), 2);
                        LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos, (ResourceLocation)AtumLootTables.CRATE);
                    } else {
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            } else if (function.equals("Chest")) {
                BlockPos posDown = pos.func_177977_b();
                if (box.func_175898_b((Vector3i)posDown)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)posDown, (ResourceLocation)AtumLootTables.PYRAMID_CHEST);
                }
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("Sarcophagus")) {
                BlockPos posDown = pos.func_177977_b();
                if (box.func_175898_b((Vector3i)posDown)) {
                    LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)posDown, (ResourceLocation)AtumLootTables.PHARAOH);
                }
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            } else if (function.equals("NebuTorch")) {
                if (box.func_175898_b((Vector3i)pos)) {
                    if (rand.nextDouble() <= 0.25) {
                        world.func_180501_a(pos, ((Block)AtumTorchUnlitBlock.UNLIT.get(AtumBlocks.NEBU_TORCH)).func_176223_P(), 2);
                    } else {
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    }
                }
            } else if (function.equals("EntrancePuzzle") && box.func_175898_b((Vector3i)pos)) {
                world.func_180501_a(pos, (BlockState)((BlockState)AtumBlocks.QUANDARY_BLOCK.func_176223_P().func_206870_a((Property)QuandaryBlock.UNBREAKABLE, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)QuandaryBlock.FACING, (Comparable)StructureHelper.getDirectionFromRotation(this.func_214809_Y_())), 2);
            }
        }

        private void setTrapsCopy(IWorld world, BlockPos pos, Random rand, MutableBoundingBox box, int range) {
            if (rand.nextDouble() <= 0.5) {
                BlockState copy = null;
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    for (int xMin = 0; xMin <= range; ++xMin) {
                        BlockState adjacent;
                        BlockPos posOffset = pos.func_177967_a(horizontal, xMin);
                        if (!box.func_175898_b((Vector3i)posOffset) || !((adjacent = world.func_180495_p(pos.func_177967_a(horizontal, xMin))).func_177230_c() instanceof TrapBlock)) continue;
                        copy = adjacent;
                    }
                }
                if (copy != null) {
                    world.func_180501_a(pos, copy, 2);
                } else {
                    Block trap = FLOOR_TRAPS.get(rand.nextInt(FLOOR_TRAPS.size()));
                    world.func_180501_a(pos, (BlockState)trap.func_176223_P().func_206870_a((Property)TrapBlock.FACING, (Comparable)Direction.UP), 2);
                }
            } else {
                world.func_180501_a(pos, CARVED_BRICK, 2);
            }
        }

        protected void func_143011_b(@Nonnull CompoundNBT compound) {
            super.func_143011_b(compound);
            compound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
        }
    }
}

