/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.feature.tree;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.init.AtumBlocks;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;

public class AtumTreeFeature
extends TreeFeature {
    public AtumTreeFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    protected boolean func_225557_a_(@Nonnull IWorldGenerationReader genReader, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull Set<BlockPos> logs, @Nonnull Set<BlockPos> leaves, @Nonnull MutableBoundingBox box, BaseTreeFeatureConfig config) {
        BlockPos blockpos;
        int trunk = config.field_236678_g_.func_236917_a_(rand);
        int foliage = config.field_236677_f_.func_230374_a_(rand, trunk, config);
        int k = trunk - foliage;
        int l = config.field_236677_f_.func_230376_a_(rand, k);
        if (!config.field_227372_q_) {
            int i = genReader.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos).func_177956_o();
            int j = genReader.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o();
            if (j - i > config.field_236680_i_) {
                return false;
            }
            int k1 = config.field_236682_l_ == Heightmap.Type.OCEAN_FLOOR ? i : (config.field_236682_l_ == Heightmap.Type.WORLD_SURFACE ? j : genReader.func_205770_a(config.field_236682_l_, pos).func_177956_o());
            blockpos = new BlockPos(pos.func_177958_n(), k1, pos.func_177952_p());
        } else {
            blockpos = pos;
        }
        if (blockpos.func_177956_o() >= 1 && blockpos.func_177956_o() + trunk + 1 <= 256) {
            if (!AtumTreeFeature.isSoilOrFarm((IWorldGenerationBaseReader)genReader, blockpos.func_177977_b())) {
                return false;
            }
            OptionalInt optionalInt = config.field_236679_h_.func_236710_c_();
            int l1 = this.func_241521_a_((IWorldGenerationBaseReader)genReader, trunk, blockpos, config);
            if (l1 >= trunk || optionalInt.isPresent() && l1 >= optionalInt.getAsInt()) {
                List list = config.field_236678_g_.func_230382_a_(genReader, rand, l1, blockpos, logs, box, config);
                list.forEach(p_236407_8_ -> config.field_236677_f_.func_236752_a_(genReader, rand, config, l1, p_236407_8_, foliage, l, leaves, box));
                return true;
            }
            return false;
        }
        return false;
    }

    protected static boolean isSoilOrFarm(IWorldGenerationBaseReader reader, @Nonnull BlockPos pos) {
        return AtumTreeFeature.isDirtOrFarmlandAt(reader, pos) || reader.func_217375_a(pos, state -> state.func_177230_c() == AtumBlocks.LIMESTONE_GRAVEL) || reader.func_217375_a(pos, state -> state.func_177230_c() == AtumBlocks.FERTILE_SOIL);
    }

    private static boolean isDirtOrFarmlandAt(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return AtumTreeFeature.func_227250_b_((Block)block) || block instanceof FarmlandBlock;
        });
    }
}

