/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.network;

import com.teammetallurgy.atum.network.packet.OpenWolfGuiPacket;
import com.teammetallurgy.atum.network.packet.StormStrengthPacket;
import com.teammetallurgy.atum.network.packet.SyncHandStackSizePacket;
import com.teammetallurgy.atum.network.packet.WeatherPacket;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("atum", "atum_channel")).clientAcceptedVersions(v -> true).serverAcceptedVersions(v -> true).networkProtocolVersion(() -> "ATUM1").simpleChannel();

    public static void initialize() {
        CHANNEL.registerMessage(0, OpenWolfGuiPacket.class, OpenWolfGuiPacket::encode, OpenWolfGuiPacket::decode, OpenWolfGuiPacket.Handler::handle);
        CHANNEL.registerMessage(1, WeatherPacket.class, WeatherPacket::encode, WeatherPacket::decode, WeatherPacket.Handler::handle);
        CHANNEL.registerMessage(2, StormStrengthPacket.class, StormStrengthPacket::encode, StormStrengthPacket::decode, StormStrengthPacket.Handler::handle);
        CHANNEL.registerMessage(3, SyncHandStackSizePacket.class, SyncHandStackSizePacket::encode, SyncHandStackSizePacket::decode, SyncHandStackSizePacket.Handler::handle);
    }

    public static void sendTo(ServerPlayerEntity playerMP, Object toSend) {
        CHANNEL.sendTo(toSend, playerMP.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToServer(Object msg) {
        CHANNEL.sendToServer(msg);
    }

    public static void sendToDimension(Object packet, ServerWorld serverWorld, RegistryKey<World> dimension) {
        PlayerList playerList = serverWorld.func_73046_m().func_184103_al();
        for (int i = 0; i < playerList.func_72394_k(); ++i) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)playerList.func_181057_v().get(i);
            if (serverPlayer.field_70170_p.func_234923_W_() != dimension) continue;
            NetworkHandler.sendTo(serverPlayer, packet);
        }
    }

    public static void sendToTracking(ServerWorld world, BlockPos blockPos, IPacket<?> packet, boolean boundaryOnly) {
        world.func_72863_F().field_217237_a.func_219097_a(new ChunkPos(blockPos), boundaryOnly).forEach(p -> p.field_71135_a.func_147359_a(packet));
    }
}

