/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.food;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.misc.StackHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EmmerFlourItem
extends Item {
    public EmmerFlourItem() {
        super(new Item.Properties().func_200916_a(Atum.GROUP));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        BlockRayTraceResult rayTrace = EmmerFlourItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (rayTrace.func_216346_c() == RayTraceResult.Type.MISS) {
            return new ActionResult(ActionResultType.PASS, (Object)heldStack);
        }
        if (rayTrace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)heldStack);
        }
        BlockRayTraceResult blockRayTrace = rayTrace;
        BlockPos pos = blockRayTrace.func_216350_a();
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos, blockRayTrace.func_216354_b(), heldStack)) {
            Fluid fluid;
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof CauldronBlock) {
                CauldronBlock cauldron = (CauldronBlock)state.func_177230_c();
                int level = (Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a);
                if (level > 0) {
                    cauldron.func_176590_a(world, pos, state, level - 1);
                    this.giveDough(player, hand, heldStack);
                    return new ActionResult(ActionResultType.SUCCESS, (Object)heldStack);
                }
                return new ActionResult(ActionResultType.FAIL, (Object)heldStack);
            }
            if (state.func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, pos, state)).func_207185_a((ITag)FluidTags.field_206959_a)) {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
                this.giveDough(player, hand, heldStack);
                return new ActionResult(ActionResultType.SUCCESS, (Object)heldStack);
            }
            return new ActionResult(ActionResultType.FAIL, (Object)heldStack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)heldStack);
    }

    private void giveDough(PlayerEntity player, Hand hand, @Nonnull ItemStack heldStack) {
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        player.func_184185_a(SoundEvents.field_187916_gp, 1.0f, 1.0f);
        StackHelper.giveItem(player, hand, new ItemStack((IItemProvider)AtumItems.EMMER_DOUGH));
        heldStack.func_190918_g(1);
    }
}

