/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.inventory.container.slot;

import com.teammetallurgy.atum.api.recipe.IAtumRecipeType;
import com.teammetallurgy.atum.api.recipe.recipes.KilnRecipe;
import com.teammetallurgy.atum.misc.StackHelper;
import com.teammetallurgy.atum.misc.recipe.RecipeHelper;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class KilnOutputSlot
extends Slot {
    private final PlayerEntity player;
    private int removeCount;

    public KilnOutputSlot(PlayerEntity player, IInventory inventoryIn, int slotIndex, int xPosition, int yPosition) {
        super(inventoryIn, slotIndex, xPosition, yPosition);
        this.player = player;
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return false;
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        if (this.func_75216_d()) {
            this.removeCount += Math.min(amount, this.func_75211_c().func_190916_E());
        }
        return super.func_75209_a(amount);
    }

    @Nonnull
    public ItemStack func_190901_a(@Nonnull PlayerEntity player, @Nonnull ItemStack stack) {
        this.func_75208_c(stack);
        super.func_190901_a(player, stack);
        return stack;
    }

    protected void func_75210_a(@Nonnull ItemStack stack, int amount) {
        this.removeCount += amount;
        this.func_75208_c(stack);
    }

    protected void func_75208_c(@Nonnull ItemStack stack) {
        stack.func_77980_a(this.player.field_70170_p, this.player, this.removeCount);
        World world = this.player.field_70170_p;
        if (!world.func_201670_d() && world instanceof ServerWorld) {
            this.spawnAllOrbs((ServerWorld)world, stack, this.removeCount);
        }
        this.removeCount = 0;
    }

    private void spawnAllOrbs(ServerWorld serverWorld, @Nonnull ItemStack stack, int removeCount) {
        ArrayList<KilnRecipe> recipes = new ArrayList<KilnRecipe>(RecipeHelper.getRecipes(serverWorld.func_199532_z(), IAtumRecipeType.KILN));
        recipes.addAll(RecipeHelper.getKilnRecipesFromFurnace(serverWorld.func_199532_z()));
        for (KilnRecipe kilnRecipe : recipes) {
            if (!StackHelper.areStacksEqualIgnoreSize(stack, kilnRecipe.func_77571_b())) continue;
            this.spawnExpOrbs(this.player, removeCount, kilnRecipe.getExperience());
        }
    }

    private void spawnExpOrbs(PlayerEntity player, int count, float experience) {
        if (experience == 0.0f) {
            count = 0;
        } else if (experience < 1.0f) {
            int expCount = MathHelper.func_76141_d((float)((float)count * experience));
            if (expCount < MathHelper.func_76123_f((float)((float)count * experience)) && Math.random() < (double)((float)count * experience - (float)expCount)) {
                ++expCount;
            }
            count = expCount;
        }
        while (count > 0) {
            int xpSplit = ExperienceOrbEntity.func_70527_a((int)count);
            count -= xpSplit;
            player.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, xpSplit));
        }
    }
}

