/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.curios;

import com.teammetallurgy.atum.integration.curios.ISimpleCurioItem;
import com.teammetallurgy.atum.integration.curios.SimpleCurioItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="atum")
public class CuriosImplementation {
    @SubscribeEvent
    public static void attachStackCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ISimpleCurioItem item;
        ItemStack stack = (ItemStack)event.getObject();
        if (stack.func_77973_b() instanceof ISimpleCurioItem && (item = (ISimpleCurioItem)stack.func_77973_b()).hasCurioCapability(stack)) {
            SimpleCurioItem simpleCurioItem = new SimpleCurioItem(item, stack);
            event.addCapability(CuriosCapability.ID_ITEM, CuriosImplementation.createProvider(simpleCurioItem));
        }
    }

    public static ICapabilityProvider createProvider(ICurio curio) {
        return new Provider(curio);
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        Provider(ICurio curio) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }
}

