/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.mojang.serialization.Codec;
import com.teammetallurgy.atum.misc.AtumConfig;
import com.teammetallurgy.atum.world.gen.feature.pool.AtumJigsaw;
import com.teammetallurgy.atum.world.gen.feature.pool.GatehousePools;
import com.teammetallurgy.atum.world.gen.feature.pool.GenericVillagePools;
import com.teammetallurgy.atum.world.gen.structure.GatehouseStructure;
import com.teammetallurgy.atum.world.gen.structure.girafitomb.GirafiTombStructure;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftConfig;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.AtumMineshaftStructure;
import com.teammetallurgy.atum.world.gen.structure.pyramid.PyramidStructure;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinStructure;
import com.teammetallurgy.atum.world.gen.structure.tomb.TombStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtumStructures {
    private static final List<Structure<?>> STRUCTURES = new ArrayList();
    public static final Structure<NoFeatureConfig> GIRAFI_TOMB_STRUCTURE = AtumStructures.register("girafi_tomb", new GirafiTombStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<NoFeatureConfig> TOMB_STRUCTURE = AtumStructures.register("tomb", new TombStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final Structure<NoFeatureConfig> RUIN_STRUCTURE = AtumStructures.register("ruin", new RuinStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<NoFeatureConfig> PYRAMID_STRUCTURE = AtumStructures.register("pyramid", new PyramidStructure((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final Structure<AtumMineshaftConfig> MINESHAFT_STRUCTURE = AtumStructures.register("mineshaft", new AtumMineshaftStructure(AtumMineshaftConfig.CODEC), GenerationStage.Decoration.UNDERGROUND_STRUCTURES);
    public static final Structure<VillageConfig> GATEHOUSE = AtumStructures.register("gatehouse", new GatehouseStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> GIRAFI_TOMB_FEATURE = AtumStructures.register("girafi_tomb", GIRAFI_TOMB_STRUCTURE, NoFeatureConfig.field_236559_b_);
    public static final StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> TOMB_FEATURE = AtumStructures.register("tomb", TOMB_STRUCTURE, NoFeatureConfig.field_236559_b_);
    public static final StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> RUIN_FEATURE = AtumStructures.register("ruin", RUIN_STRUCTURE, NoFeatureConfig.field_236559_b_);
    public static final StructureFeature<NoFeatureConfig, ? extends Structure<NoFeatureConfig>> PYRAMID_FEATURE = AtumStructures.register("pyramid", PYRAMID_STRUCTURE, NoFeatureConfig.field_236559_b_);
    public static final StructureFeature<AtumMineshaftConfig, ? extends Structure<AtumMineshaftConfig>> MINESHAFT_DEADWOOD_FEATURE = AtumStructures.register("mineshaft_deadwood", MINESHAFT_STRUCTURE, new AtumMineshaftConfig(((Double)AtumConfig.WORLD_GEN.mineshaftProbability.get()).floatValue(), AtumMineshaftStructure.Type.DEADWOOD));
    public static final StructureFeature<AtumMineshaftConfig, ? extends Structure<AtumMineshaftConfig>> MINESHAFT_LIMESTONE_FEATURE = AtumStructures.register("mineshaft_limestone", MINESHAFT_STRUCTURE, new AtumMineshaftConfig(((Double)AtumConfig.WORLD_GEN.mineshaftProbability.get()).floatValue(), AtumMineshaftStructure.Type.LIMESTONE));
    public static final StructureFeature<AtumMineshaftConfig, ? extends Structure<AtumMineshaftConfig>> MINESHAFT_DEADWOOD_SURFACE_FEATURE = AtumStructures.register("mineshaft_deadwood_surface", MINESHAFT_STRUCTURE, new AtumMineshaftConfig(((Double)AtumConfig.WORLD_GEN.mineshaftProbability.get()).floatValue(), AtumMineshaftStructure.Type.DEADWOOD_SURFACE));
    public static final StructureFeature<AtumMineshaftConfig, ? extends Structure<AtumMineshaftConfig>> MINESHAFT_LIMESTONE_SURFACE_FEATURE = AtumStructures.register("mineshaft_limestone_surface", MINESHAFT_STRUCTURE, new AtumMineshaftConfig(((Double)AtumConfig.WORLD_GEN.mineshaftProbability.get()).floatValue(), AtumMineshaftStructure.Type.LIMESTONE_SURFACE));
    public static final StructureFeature<VillageConfig, ? extends Structure<VillageConfig>> GATEHOUSE_FEATURE = AtumStructures.register("gatehouse", GATEHOUSE, new VillageConfig(() -> GatehousePools.POOL, 5));
    public static final StructureFeature<VillageConfig, ? extends Structure<VillageConfig>> GENERIC_VILLAGE = AtumStructures.register("village_generic", Structure.field_236381_q_, new VillageConfig(() -> GenericVillagePools.POOL, 6));

    private static <F extends Structure<?>> F register(String name, F structure, GenerationStage.Decoration generationStage) {
        ResourceLocation id = new ResourceLocation("atum", name);
        structure.setRegistryName(id);
        STRUCTURES.add(structure);
        Structure.field_236365_a_.put((Object)id.toString().toLowerCase(Locale.ROOT), structure);
        Structure.field_236385_u_.put(structure, generationStage);
        return structure;
    }

    private static <FC extends IFeatureConfig, F extends Structure<FC>> StructureFeature<FC, ?> register(String name, F structure, FC fc) {
        return (StructureFeature)WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243654_f, (ResourceLocation)new ResourceLocation("atum", name), (Object)structure.func_236391_a_(fc));
    }

    @SubscribeEvent
    public static void registerStructure(RegistryEvent.Register<Structure<?>> event) {
        for (Structure<?> feature : STRUCTURES) {
            event.getRegistry().register(feature);
        }
        AtumJigsaw.registerJigsaws();
    }
}

