/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.teammetallurgy.atum.entity.animal.CamelEntity;
import com.teammetallurgy.atum.entity.animal.DesertRabbitEntity;
import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import com.teammetallurgy.atum.entity.animal.QuailEntity;
import com.teammetallurgy.atum.entity.animal.ScarabEntity;
import com.teammetallurgy.atum.entity.animal.ServalEntity;
import com.teammetallurgy.atum.entity.animal.TarantulaEntity;
import com.teammetallurgy.atum.entity.bandit.AssassinEntity;
import com.teammetallurgy.atum.entity.bandit.BanditBaseEntity;
import com.teammetallurgy.atum.entity.bandit.BarbarianEntity;
import com.teammetallurgy.atum.entity.bandit.BrigandEntity;
import com.teammetallurgy.atum.entity.bandit.NomadEntity;
import com.teammetallurgy.atum.entity.bandit.SergeantEntity;
import com.teammetallurgy.atum.entity.bandit.WarlordEntity;
import com.teammetallurgy.atum.entity.projectile.CamelSpitEntity;
import com.teammetallurgy.atum.entity.projectile.PharaohOrbEntity;
import com.teammetallurgy.atum.entity.projectile.QuailEggEntity;
import com.teammetallurgy.atum.entity.projectile.SmallBoneEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.ArrowDoubleEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.ArrowExplosiveEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.ArrowFireEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.ArrowPoisonEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.ArrowQuickdrawEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.ArrowRainEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.ArrowSlownessEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.ArrowStraightEntity;
import com.teammetallurgy.atum.entity.projectile.arrow.TefnutsCallEntity;
import com.teammetallurgy.atum.entity.stone.StoneBaseEntity;
import com.teammetallurgy.atum.entity.stone.StoneguardEntity;
import com.teammetallurgy.atum.entity.stone.StonewardenEntity;
import com.teammetallurgy.atum.entity.undead.BonestormEntity;
import com.teammetallurgy.atum.entity.undead.ForsakenEntity;
import com.teammetallurgy.atum.entity.undead.MummyEntity;
import com.teammetallurgy.atum.entity.undead.PharaohEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.entity.undead.WraithEntity;
import com.teammetallurgy.atum.entity.villager.AtumVillagerEntity;
import com.teammetallurgy.atum.misc.AtumRegistry;
import com.teammetallurgy.atum.world.DimensionHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="atum")
@Mod.EventBusSubscriber(modid="atum", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AtumEntities {
    public static final EntityType<AssassinEntity> ASSASSIN = AtumRegistry.registerMob("assassin", 4405041, 14258720, EntityType.Builder.func_220322_a(AssassinEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<BarbarianEntity> BARBARIAN = AtumRegistry.registerMob("barbarian", 10253145, 0x8C8C8C, EntityType.Builder.func_220322_a(BarbarianEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<BonestormEntity> BONESTORM = AtumRegistry.registerMob("bonestorm", 7627598, 11244662, EntityType.Builder.func_220322_a(BonestormEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<BrigandEntity> BRIGAND = AtumRegistry.registerMob("brigand", 0xC2C2C2, 266117, EntityType.Builder.func_220322_a(BrigandEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<CamelEntity> CAMEL = AtumRegistry.registerMob("camel", 11371356, 6833702, EntityType.Builder.func_220322_a(CamelEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.87f).func_233606_a_(10));
    public static final EntityType<DesertRabbitEntity> DESERT_RABBIT = AtumRegistry.registerMob("desert_rabbit", 11437650, 6900777, EntityType.Builder.func_220322_a(DesertRabbitEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.5f).func_233606_a_(8));
    public static final EntityType<DesertWolfEntity> DESERT_WOLF = AtumRegistry.registerMob("desert_wolf", 15195080, 11375719, EntityType.Builder.func_220322_a(DesertWolfEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.8f).func_233606_a_(10));
    public static final EntityType<ForsakenEntity> FORSAKEN = AtumRegistry.registerMob("forsaken", 11902077, 7298115, EntityType.Builder.func_220322_a(ForsakenEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<MummyEntity> MUMMY = AtumRegistry.registerMob("mummy", 5331000, 8818539, EntityType.Builder.func_220322_a(MummyEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<NomadEntity> NOMAD = AtumRegistry.registerMob("nomad", 0xC2C2C2, 8260620, EntityType.Builder.func_220322_a(NomadEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<PharaohEntity> PHARAOH = AtumRegistry.registerMob("pharaoh", 13941815, 3820512, EntityType.Builder.func_220322_a(PharaohEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_220320_c().func_233606_a_(10));
    public static final EntityType<QuailEntity> QUAIL = AtumRegistry.registerMob("quail", 13409138, 10777929, EntityType.Builder.func_220322_a(QuailEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.35f, 0.525f).func_233606_a_(10));
    public static final EntityType<ScarabEntity> SCARAB = AtumRegistry.registerMob("scarab", 6373676, 3087632, EntityType.Builder.func_220322_a(ScarabEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.4f, 0.3f).func_233606_a_(8));
    public static final EntityType<SergeantEntity> SERGEANT = AtumRegistry.registerMob("sergeant", 0x444444, 0xC2C2C2, EntityType.Builder.func_220322_a(SergeantEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<ServalEntity> SERVAL = AtumRegistry.registerMob("serval", 16769202, 10582884, EntityType.Builder.func_220322_a(ServalEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.8f).func_233606_a_(8));
    public static final EntityType<StoneguardEntity> STONEGUARD = AtumRegistry.registerMob("stoneguard", 9536340, 6905143, EntityType.Builder.func_220322_a(StoneguardEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_220320_c().func_233606_a_(10));
    public static final EntityType<StoneguardEntity> STONEGUARD_FRIENDLY = AtumRegistry.registerEntity("stoneguard_friendly", EntityType.Builder.func_220322_a(StoneguardEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.8f).func_220320_c().func_233606_a_(10));
    public static final EntityType<StonewardenEntity> STONEWARDEN = AtumRegistry.registerMob("stonewarden", 9536340, 6905143, EntityType.Builder.func_220322_a(StonewardenEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.4f, 2.7f).func_220320_c().func_233606_a_(10));
    public static final EntityType<StonewardenEntity> STONEWARDEN_FRIENDLY = AtumRegistry.registerEntity("stonewarden_friendly", EntityType.Builder.func_220322_a(StonewardenEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.4f, 2.7f).func_220320_c().func_233606_a_(10));
    public static final EntityType<TarantulaEntity> TARANTULA = AtumRegistry.registerMob("tarantula", 7625799, 13808019, EntityType.Builder.func_220322_a(TarantulaEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.85f, 0.55f).func_233606_a_(8));
    public static final EntityType<WarlordEntity> BANDIT_WARLORD = AtumRegistry.registerMob("bandit_warlord", 10890523, 15047202, EntityType.Builder.func_220322_a(WarlordEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f).func_233606_a_(8));
    public static final EntityType<WraithEntity> WRAITH = AtumRegistry.registerMob("wraith", 5524788, 4077863, EntityType.Builder.func_220322_a(WraithEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.8f));
    public static final EntityType<AtumVillagerEntity> VILLAGER_MALE = AtumRegistry.registerEntity("villager_male", EntityType.Builder.func_220322_a(AtumVillagerEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.85f).func_233606_a_(10));
    public static final EntityType<AtumVillagerEntity> VILLAGER_FEMALE = AtumRegistry.registerEntity("villager_female", EntityType.Builder.func_220322_a(AtumVillagerEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.6f, 1.85f).func_233606_a_(10));
    public static final EntityType<CamelSpitEntity> CAMEL_SPIT = AtumRegistry.registerEntity("camel_spit", EntityType.Builder.func_220322_a(CamelSpitEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(10).setShouldReceiveVelocityUpdates(false).setCustomClientFactory(CamelSpitEntity::new));
    public static final EntityType<SmallBoneEntity> SMALL_BONE = AtumRegistry.registerEntity("small_bone", EntityType.Builder.func_220322_a(SmallBoneEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.3125f, 0.3125f).setTrackingRange(4).setUpdateInterval(10).setCustomClientFactory(SmallBoneEntity::new));
    public static final EntityType<ArrowDoubleEntity> DOUBLE_ARROW = AtumRegistry.registerArrow("arrow_double", ArrowDoubleEntity::new, ArrowDoubleEntity::new);
    public static final EntityType<ArrowExplosiveEntity> EXPLOSIVE_ARROW = AtumRegistry.registerArrow("arrow_explosive", ArrowExplosiveEntity::new, ArrowExplosiveEntity::new);
    public static final EntityType<ArrowFireEntity> FIRE_ARROW = AtumRegistry.registerArrow("arrow_fire", ArrowFireEntity::new, ArrowFireEntity::new);
    public static final EntityType<ArrowPoisonEntity> POISON_ARROW = AtumRegistry.registerArrow("arrow_poison", ArrowPoisonEntity::new, ArrowPoisonEntity::new);
    public static final EntityType<ArrowQuickdrawEntity> QUICKDRAW_ARROW = AtumRegistry.registerArrow("arrow_quickdraw", ArrowQuickdrawEntity::new, ArrowQuickdrawEntity::new);
    public static final EntityType<ArrowRainEntity> RAIN_ARROW = AtumRegistry.registerArrow("arrow_rain", ArrowRainEntity::new, ArrowRainEntity::new);
    public static final EntityType<ArrowSlownessEntity> SLOWNESS_ARROW = AtumRegistry.registerArrow("arrow_slowness", ArrowSlownessEntity::new, ArrowSlownessEntity::new);
    public static final EntityType<ArrowStraightEntity> STRAIGHT_ARROW = AtumRegistry.registerArrow("arrow_straight", ArrowStraightEntity::new, ArrowStraightEntity::new);
    public static final EntityType<PharaohOrbEntity> PHARAOH_ORB = AtumRegistry.registerEntity("pharaoh_orb", EntityType.Builder.func_220322_a(PharaohOrbEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(4).func_233608_b_(20).setCustomClientFactory(PharaohOrbEntity::new));
    public static final EntityType<QuailEggEntity> QUAIL_EGG = AtumRegistry.registerEntity("quail_egg", EntityType.Builder.func_220322_a(QuailEggEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).func_233606_a_(4).func_233608_b_(10).setCustomClientFactory(QuailEggEntity::new));
    public static final EntityType<TefnutsCallEntity> TEFNUTS_CALL = AtumRegistry.registerEntity("tefnuts_call", EntityType.Builder.func_220322_a(TefnutsCallEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).func_220320_c().setCustomClientFactory(TefnutsCallEntity::new));

    public static void registerSpawnPlacement() {
        EntitySpawnPlacementRegistry.func_209343_a(ASSASSIN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BanditBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(BANDIT_WARLORD, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BanditBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(BARBARIAN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BanditBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(BONESTORM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, UndeadBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(BRIGAND, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BanditBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(CAMEL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AtumEntities::canAnimalSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(DESERT_RABBIT, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AtumEntities::canAnimalSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(DESERT_WOLF, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, DesertWolfEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(FORSAKEN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, UndeadBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(MUMMY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, UndeadBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(NOMAD, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BanditBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(PHARAOH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, UndeadBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(QUAIL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AtumEntities::canAnimalSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(SCARAB, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, ScarabEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(SERGEANT, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, BanditBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(SERVAL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, AtumEntities::canAnimalSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(STONEGUARD, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StoneBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(STONEGUARD_FRIENDLY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StoneBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(STONEWARDEN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StoneBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(STONEWARDEN_FRIENDLY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, StoneBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(TARANTULA, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, TarantulaEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(WRAITH, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, UndeadBaseEntity::canSpawn);
        EntitySpawnPlacementRegistry.func_209343_a(VILLAGER_MALE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
        EntitySpawnPlacementRegistry.func_209343_a(VILLAGER_FEMALE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(ASSASSIN, AssassinEntity.getAttributes().func_233813_a_());
        event.put(BANDIT_WARLORD, WarlordEntity.getAttributes().func_233813_a_());
        event.put(BARBARIAN, BarbarianEntity.getAttributes().func_233813_a_());
        event.put(BONESTORM, BonestormEntity.getAttributes().func_233813_a_());
        event.put(BRIGAND, BrigandEntity.getAttributes().func_233813_a_());
        event.put(CAMEL, CamelEntity.getAttributes().func_233813_a_());
        event.put(DESERT_RABBIT, DesertRabbitEntity.getAttributes().func_233813_a_());
        event.put(DESERT_WOLF, DesertWolfEntity.getAttributes().func_233813_a_());
        event.put(FORSAKEN, ForsakenEntity.getAttributes().func_233813_a_());
        event.put(MUMMY, MummyEntity.getAttributes().func_233813_a_());
        event.put(NOMAD, NomadEntity.getAttributes().func_233813_a_());
        event.put(PHARAOH, PharaohEntity.getAttributes().func_233813_a_());
        event.put(QUAIL, QuailEntity.getAttributes().func_233813_a_());
        event.put(SCARAB, ScarabEntity.getAttributes().func_233813_a_());
        event.put(SERGEANT, SergeantEntity.getAttributes().func_233813_a_());
        event.put(SERVAL, ServalEntity.func_234184_eY_().func_233813_a_());
        event.put(STONEGUARD, StoneguardEntity.getAttributes().func_233813_a_());
        event.put(STONEGUARD_FRIENDLY, StoneguardEntity.getAttributes().func_233813_a_());
        event.put(STONEWARDEN, StonewardenEntity.getAttributes().func_233813_a_());
        event.put(STONEWARDEN_FRIENDLY, StoneguardEntity.getAttributes().func_233813_a_());
        event.put(TARANTULA, TarantulaEntity.getAttributes().func_233813_a_());
        event.put(WRAITH, WraithEntity.getAttributes().func_233813_a_());
        event.put(VILLAGER_MALE, AtumVillagerEntity.func_234551_eU_().func_233813_a_());
        event.put(VILLAGER_FEMALE, AtumVillagerEntity.func_234551_eU_().func_233813_a_());
    }

    public static boolean canAnimalSpawn(EntityType<? extends AnimalEntity> animal, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        Block spawnBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return (spawnBlock.func_203417_a((ITag)BlockTags.field_203436_u) || spawnBlock.func_203417_a((ITag)Tags.Blocks.SAND) || DimensionHelper.SURFACE_BLOCKS.contains(spawnBlock) || spawnBlock == Blocks.field_196658_i) && world.func_226659_b_(pos, 0) > 8;
    }
}

