/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.villager;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teammetallurgy.atum.entity.villager.AtumVillagerProfession;
import com.teammetallurgy.atum.entity.villager.Race;
import com.teammetallurgy.atum.misc.AtumRegistry;
import com.teammetallurgy.atum.misc.ForgeRegistryEntryCodec;
import javax.annotation.Nonnull;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.util.IStringSerializable;

public class AtumVillagerData
extends VillagerData {
    public static final Codec<AtumVillagerProfession> VILLAGER_PROFESSION_CODEC = ForgeRegistryEntryCodec.getOrCreate(AtumRegistry.VILLAGER_PROFESSION.get());
    public static final Codec<AtumVillagerData> CODEC = RecordCodecBuilder.create(dataInstance -> dataInstance.group((App)VILLAGER_PROFESSION_CODEC.fieldOf("profession").orElseGet(AtumVillagerProfession.NONE).forGetter(data -> data.profession), (App)Codec.INT.fieldOf("level").orElse((Object)1).forGetter(data -> data.level), (App)IStringSerializable.func_233023_a_(Race::values, Race::getTypeFromName).fieldOf("race").orElse((Object)Race.HUMAN).forGetter(data -> data.race)).apply((Applicative)dataInstance, AtumVillagerData::new));
    private final AtumVillagerProfession profession;
    private final int level;
    private final Race race;

    public AtumVillagerData(AtumVillagerProfession profession, int level, Race race) {
        super(null, VillagerProfession.field_221162_l, level);
        this.profession = profession;
        this.level = Math.max(1, level);
        this.race = race;
    }

    public AtumVillagerProfession getAtumProfession() {
        return this.profession;
    }

    public Race getRace() {
        return this.race;
    }

    public int func_221132_c() {
        return this.level;
    }

    @Nonnull
    public AtumVillagerData withProfession(@Nonnull AtumVillagerProfession profession) {
        return new AtumVillagerData(profession, this.func_221132_c(), this.getRace());
    }

    @Nonnull
    public AtumVillagerData withLevel(int level) {
        return new AtumVillagerData(this.getAtumProfession(), level, this.getRace());
    }

    @Nonnull
    public AtumVillagerData withRace(Race race) {
        return new AtumVillagerData(this.getAtumProfession(), this.func_221132_c(), race);
    }

    @Nonnull
    @Deprecated
    public VillagerType func_221129_a() {
        return super.func_221129_a();
    }

    @Nonnull
    @Deprecated
    public VillagerProfession func_221130_b() {
        return super.func_221130_b();
    }

    @Nonnull
    @Deprecated
    public VillagerData func_221134_a(VillagerType type) {
        return super.func_221134_a(type);
    }

    @Nonnull
    @Deprecated
    public VillagerData func_221126_a(VillagerProfession profession) {
        return super.func_221126_a(profession);
    }
}

