/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.undead;

import com.teammetallurgy.atum.entity.ITexture;
import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import com.teammetallurgy.atum.entity.animal.TarantulaEntity;
import com.teammetallurgy.atum.entity.bandit.BanditBaseEntity;
import com.teammetallurgy.atum.entity.stone.StoneBaseEntity;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UndeadBaseEntity
extends MonsterEntity
implements ITexture {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(UndeadBaseEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private String texturePath;

    public UndeadBaseEntity(EntityType<? extends UndeadBaseEntity> entityType, World world) {
        super(entityType, world);
        new GroundPathNavigator((MobEntity)this, world).func_189566_q().func_186317_a(true);
    }

    boolean hasSkinVariants() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.applyEntityAI();
    }

    void applyEntityAI() {
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{UndeadBaseEntity.class}));
        boolean checkSight = this.func_184222_aU();
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, checkSight));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BanditBaseEntity.class, checkSight));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, StoneBaseEntity.class, checkSight));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, DesertWolfEntity.class, checkSight));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WolfEntity.class, checkSight));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ZombifiedPiglinEntity.class, checkSight));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, TarantulaEntity.class, checkSight));
    }

    public boolean func_213358_a(@Nonnull EntityType<?> type) {
        return type != this.func_200600_R() && super.func_213358_a(type);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        if (this.hasSkinVariants()) {
            this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        }
    }

    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT nbt) {
        livingData = super.func_213386_a(world, difficulty, spawnReason, livingData, nbt);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        if (this.hasSkinVariants() && spawnReason != SpawnReason.CONVERSION) {
            int variant = MathHelper.func_76136_a((Random)world.func_201674_k(), (int)0, (int)this.getVariantAmount());
            this.setVariantWithAbilities(variant, difficulty);
        }
        return livingData;
    }

    int getVariantAmount() {
        return 6;
    }

    public void setVariantWithAbilities(int variant, DifficultyInstance difficulty) {
        this.setVariant(variant);
        this.setVariantAbilities(difficulty, variant);
    }

    void setVariantAbilities(DifficultyInstance difficulty, int variant) {
    }

    public boolean func_70687_e(@Nonnull EffectInstance potionEffect) {
        return potionEffect.func_188419_a() != Effects.field_76436_u && super.func_70687_e(potionEffect);
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(@Nonnull DamageSource damageSource) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
    }

    public void func_70636_d() {
        if (this.func_70089_S() && this.shouldBurnInDay() && this.func_204609_dp()) {
            this.func_70015_d(8);
        }
        super.func_70636_d();
    }

    public void func_70030_z() {
        if (this.func_223314_ad() > 0) {
            int fire = this.func_223314_ad();
            if (!this.func_230279_az_()) {
                if (this.func_223314_ad() % 20 == 0) {
                    this.func_70097_a(DamageSource.field_76370_b, this.getBurnDamage());
                }
                this.func_241209_g_(--fire);
            }
        }
        super.func_70030_z();
    }

    float getBurnDamage() {
        return 1.0f;
    }

    boolean shouldBurnInDay() {
        return true;
    }

    @Nonnull
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    public boolean func_213380_a(@Nonnull IWorld world, @Nonnull SpawnReason spawnReason) {
        return spawnReason == SpawnReason.SPAWNER || super.func_213380_a(world, spawnReason);
    }

    public static boolean canSpawn(EntityType<? extends UndeadBaseEntity> undeadBase, IServerWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return (spawnReason == SpawnReason.SPAWNER || pos.func_177956_o() > 62) && UndeadBaseEntity.func_223325_c(undeadBase, (IServerWorld)world, (SpawnReason)spawnReason, (BlockPos)pos, (Random)random);
    }

    void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            String entityName = Objects.requireNonNull(this.func_200600_R().getRegistryName()).func_110623_a();
            this.texturePath = this.hasSkinVariants() ? new ResourceLocation("atum", "textures/entity/" + entityName + "_" + this.getVariant()) + ".png" : new ResourceLocation("atum", "textures/entity/" + entityName) + ".png";
        }
        return this.texturePath;
    }

    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.hasSkinVariants()) {
            compound.func_74768_a("Variant", this.getVariant());
        }
    }

    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.hasSkinVariants()) {
            this.setVariant(compound.func_74762_e("Variant"));
        }
    }
}

