/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.undead;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.api.event.AtumEvents;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.SarcophagusTileEntity;
import com.teammetallurgy.atum.entity.ai.goal.OpenAnyDoorGoal;
import com.teammetallurgy.atum.entity.ai.goal.OrbAttackGoal;
import com.teammetallurgy.atum.entity.projectile.PharaohOrbEntity;
import com.teammetallurgy.atum.entity.undead.MummyEntity;
import com.teammetallurgy.atum.entity.undead.UndeadBaseEntity;
import com.teammetallurgy.atum.init.AtumEffects;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.items.tools.ScepterItem;
import com.teammetallurgy.atum.misc.AtumConfig;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PharaohEntity
extends UndeadBaseEntity
implements IRangedAttackMob {
    private static final String[] PREFIXES = new String[]{"Ama", "Ata", "Ato", "Bak", "Cal", "Djet", "Eje", "For", "Gol", "Gut", "Hop", "Hor", "Huni", "Iam", "Jor", "Kal", "Khas", "Khor", "Lat", "Mal", "Not", "Oap", "Pra", "Qo", "Ras", "Shas", "Thoth", "Tui", "Uld", "Ver", "Wot", "Xo", "Yat", "Zyt", "Khep"};
    private static final String[] SUFFIXES = new String[]{"Ahat", "Amesh", "Amon", "Anut", "Baroom", "Chanta", "Erant", "Funam", "Daresh", "Djer", "Hotesh", "Khaden", "Kron", "Gorkum", "Ialenter", "Ma'at", "Narmer", "Radeem", "Jaloom", "Lepsha", "Quor", "Oleshet", "Peput", "Talat", "Ulam", "Veresh", "Ranesh", "Snef", "Wollolo", "Hathor", "Intef", "Neferk", "Khatne", "Tepy", "Moret"};
    private static final String[] NUMERALS = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV"};
    private static final DataParameter<Integer> PREFIX = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SUFFIX = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> NUMERAL = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<BlockPos>> SARCOPHAGUS_POS = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Boolean> DROP_GOD_SPECIFIC_LOOT = EntityDataManager.func_187226_a(PharaohEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.YELLOW, BossInfo.Overlay.NOTCHED_10).func_186743_c(true);
    private final OrbAttackGoal<PharaohEntity> aiOrbAttack = new OrbAttackGoal<PharaohEntity>(this, 1.2, 20, 24.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.2, true){

        public void func_75251_c() {
            super.func_75251_c();
            PharaohEntity.this.func_213395_q(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            PharaohEntity.this.func_213395_q(true);
        }
    };
    private int stage;
    private int suffixID = 0;
    private int prefixID = 0;
    private int numID = 0;
    private int regenTime = 0;
    private String texturePath;
    private boolean dropsGodSpecificLoot;

    public PharaohEntity(EntityType<? extends PharaohEntity> entityType, World world) {
        super(entityType, world);
        this.func_70606_j(this.func_110138_aP());
        this.field_70728_aV = 250;
        this.stage = 0;
        this.func_98053_h(false);
        this.setCombatTask();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected boolean hasSkinVariants() {
        return true;
    }

    @Override
    protected int getVariantAmount() {
        return God.values().length - 1;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new OpenAnyDoorGoal((MobEntity)this, false, true));
    }

    @Override
    protected void applyEntityAI() {
        super.applyEntityAI();
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 300.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233823_f_, 8.0).func_233815_a_(Attributes.field_233819_b_, 36.0).func_233815_a_(Attributes.field_233826_i_, 10.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREFIX, (Object)0);
        this.field_70180_af.func_187214_a(SUFFIX, (Object)0);
        this.field_70180_af.func_187214_a(NUMERAL, (Object)0);
        this.field_70180_af.func_187214_a(SARCOPHAGUS_POS, Optional.empty());
        this.field_70180_af.func_187214_a(DROP_GOD_SPECIFIC_LOOT, (Object)false);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191268_hm;
    }

    @Override
    protected boolean shouldBurnInDay() {
        return false;
    }

    protected int func_225508_e_(float distance, float damageMultiplier) {
        return 0;
    }

    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
        ScepterItem scepter = ScepterItem.getScepter(God.getGod(this.getVariant()));
        if (scepter != null) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)scepter));
        }
    }

    public void func_184201_a(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        super.func_184201_a(slot, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected void func_213333_a(@Nonnull DamageSource source, int looting, boolean recentlyHit) {
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        if (this.dropsGodSpecificLoot()) {
            return new ResourceLocation("atum", "gods/" + God.getGod(this.getVariant()).getName());
        }
        return AtumLootTables.GODS_ALL;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getTexture() {
        if (this.texturePath == null) {
            this.texturePath = new ResourceLocation("atum", "textures/entity/pharaoh_" + God.getGod(this.getVariant()).getName()) + ".png";
        }
        return this.texturePath;
    }

    @Override
    protected void setVariant(int variant) {
        super.setVariant(variant);
        this.texturePath = null;
    }

    @Override
    protected void setVariantAbilities(DifficultyInstance difficulty, int variant) {
        super.setVariantAbilities(difficulty, variant);
        this.prefixID = this.field_70146_Z.nextInt(PREFIXES.length);
        this.suffixID = this.field_70146_Z.nextInt(SUFFIXES.length);
        this.numID = this.field_70146_Z.nextInt(NUMERALS.length);
        this.setPharaohName(this.prefixID, this.suffixID, this.numID);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
    }

    @Override
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData livingData, @Nullable CompoundNBT nbt) {
        this.setCombatTask();
        return super.func_213386_a(world, difficulty, spawnReason, livingData, nbt);
    }

    private void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a(this.aiOrbAttack);
            ItemStack heldItem = this.func_184586_b(Hand.MAIN_HAND);
            if (heldItem.func_77973_b() instanceof ScepterItem) {
                int cooldown = 18;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    cooldown = 32;
                }
                this.aiOrbAttack.setAttackCooldown(cooldown);
                this.field_70714_bg.func_75776_a(4, this.aiOrbAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public void func_82196_d(@Nonnull LivingEntity target, float distanceFactor) {
        PharaohOrbEntity orb = new PharaohOrbEntity(this.field_70170_p, this, God.getGod(this.getVariant()));
        double x = target.func_226277_ct_() - this.func_226277_ct_();
        double y = target.func_226283_e_(0.3333333333333333) - orb.func_226278_cu_();
        double z = target.func_226281_cx_() - this.func_226281_cx_();
        double height = MathHelper.func_76133_a((double)(x * x + z * z));
        orb.func_70186_c(x, y + height * 0.2, z, 1.6f, 1.0f);
        this.func_184185_a(SoundEvents.field_187557_bK, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)orb);
    }

    public BlockPos getSarcophagusPos() {
        return ((Optional)this.field_70180_af.func_187225_a(SARCOPHAGUS_POS)).orElse(null);
    }

    public void setSarcophagusPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, Optional.ofNullable(pos));
    }

    public boolean dropsGodSpecificLoot() {
        return this.dropsGodSpecificLoot;
    }

    public void setDropsGodSpecificLoot(boolean dropsGodSpecificLoot) {
        this.dropsGodSpecificLoot = dropsGodSpecificLoot;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_213392_I() {
        return true;
    }

    public void func_70645_a(@Nonnull DamageSource source) {
        Entity killer;
        BlockPos sarcophagusPos;
        if (!this.field_70170_p.field_72995_K && (sarcophagusPos = this.getSarcophagusPos()) != null) {
            TileEntity tileEntity = this.field_70170_p.func_175625_s(sarcophagusPos);
            if (tileEntity instanceof SarcophagusTileEntity) {
                ((SarcophagusTileEntity)tileEntity).setOpenable();
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    TileEntity tileEntityOffset = this.field_70170_p.func_175625_s(sarcophagusPos.func_177972_a(horizontal));
                    if (!(tileEntityOffset instanceof SarcophagusTileEntity)) continue;
                    ((SarcophagusTileEntity)tileEntityOffset).setOpenable();
                }
                AtumEvents.onPharaohBeaten(this, source);
            } else {
                Atum.LOG.error("Unable to find sarcophagus coordinates for " + this.func_200200_C_() + " on " + sarcophagusPos);
            }
        }
        if (((Boolean)AtumConfig.MOBS.displayPharaohSlainMessage.get()).booleanValue() && source.field_76373_n.equals("player")) {
            PlayerEntity slayer = (PlayerEntity)source.func_76346_g();
            if (!this.field_70170_p.field_72995_K && slayer != null) {
                List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
                for (PlayerEntity player : players) {
                    player.func_145747_a((ITextComponent)this.func_200200_C_().func_230532_e_().func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("chat.atum.kill_pharaoh")).func_240702_b_(" " + slayer.func_146103_bH().getName()).func_230530_a_(this.func_200200_C_().func_150256_b().func_240718_a_(God.getGod(this.getVariant()).getColor())), Util.field_240973_b_);
                }
            }
        }
        if ((killer = source.func_76346_g()) instanceof PlayerEntity) {
            ((PlayerEntity)killer).func_195064_c(new EffectInstance(AtumEffects.MARKED_FOR_DEATH, 2400, 0, false, false, true));
        }
        super.func_70645_a(source);
    }

    public void func_184178_b(@Nonnull ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(@Nonnull ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nonnull
    public ITextComponent func_200200_C_() {
        int p = (Integer)this.field_70180_af.func_187225_a(PREFIX);
        int s = (Integer)this.field_70180_af.func_187225_a(SUFFIX);
        int n = (Integer)this.field_70180_af.func_187225_a(NUMERAL);
        return new TranslationTextComponent(this.func_200600_R().func_210760_d()).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("entity.atum.pharaoh." + PREFIXES[p])).func_230529_a_((ITextComponent)new TranslationTextComponent("entity.atum.pharaoh." + SUFFIXES[s].toLowerCase(Locale.ROOT))).func_240702_b_(" " + NUMERALS[n]);
    }

    public void func_233627_a_(float strength, double xRatio, double zRatio) {
        if (God.getGod(this.getVariant()) != God.PTAH) {
            super.func_233627_a_(strength *= 0.2f, xRatio, zRatio);
        }
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (this.func_110143_aJ() < this.func_110138_aP() * 0.75f && this.stage == 0) {
                ++this.stage;
                this.spawnGuards(this.func_233580_cy_());
            } else if (this.stage == 1 && this.func_110143_aJ() < this.func_110138_aP() * 0.5f) {
                ++this.stage;
                this.spawnGuards(this.func_233580_cy_());
            } else if (this.stage == 2 && this.func_110143_aJ() < this.func_110138_aP() * 0.25f) {
                ++this.stage;
                this.spawnGuards(this.func_233580_cy_());
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.setBossInfo(this.getVariant());
        }
        if (this.field_70170_p.func_175659_aa().func_151525_a() == 0) {
            TileEntity te;
            if (this.getSarcophagusPos() != null && (te = this.field_70170_p.func_175625_s(this.getSarcophagusPos())) instanceof SarcophagusTileEntity) {
                ((SarcophagusTileEntity)te).hasSpawned = false;
            }
            this.func_70106_y();
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    @Override
    public void func_70636_d() {
        if (this.regenTime++ > 60) {
            this.regenTime = 0;
            this.func_70691_i(God.getGod(this.getVariant()) == God.OSIRIS ? 6.0f : 1.0f);
        }
        super.func_70636_d();
    }

    @Override
    public void func_213281_b(@Nonnull CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("prefix", this.prefixID);
        compound.func_74768_a("suffix", this.suffixID);
        compound.func_74768_a("numeral", this.numID);
        compound.func_74757_a("dropGodSpecificLoot", this.dropsGodSpecificLoot());
        BlockPos sarcophagusPos = this.getSarcophagusPos();
        if (sarcophagusPos != null) {
            compound.func_74768_a("sarcophagus_x", sarcophagusPos.func_177958_n());
            compound.func_74768_a("sarcophagus_y", sarcophagusPos.func_177956_o());
            compound.func_74768_a("sarcophagus_z", sarcophagusPos.func_177952_p());
        }
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.prefixID = compound.func_74762_e("prefix");
        this.suffixID = compound.func_74762_e("suffix");
        this.numID = compound.func_74762_e("numeral");
        this.dropsGodSpecificLoot = compound.func_74767_n("dropGodSpecificLoot");
        if (compound.func_74764_b("sarcophagus_x")) {
            int x = compound.func_74762_e("sarcophagus_x");
            int y = compound.func_74762_e("sarcophagus_y");
            int z = compound.func_74762_e("sarcophagus_z");
            this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, Optional.of(new BlockPos(x, y, z)));
        } else {
            this.field_70180_af.func_187227_b(SARCOPHAGUS_POS, Optional.empty());
        }
        this.setPharaohName(compound.func_74762_e("prefix"), compound.func_74762_e("suffix"), compound.func_74762_e("numeral"));
        this.setCombatTask();
    }

    private void setPharaohName(int prefix, int suffix, int numeral) {
        this.field_70180_af.func_187227_b(PREFIX, (Object)prefix);
        this.field_70180_af.func_187227_b(SUFFIX, (Object)suffix);
        this.field_70180_af.func_187227_b(NUMERAL, (Object)numeral);
    }

    public void spawnGuards(BlockPos pos) {
        Direction facing = Direction.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(this.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        this.trySpawnMummy(pos, facing);
        this.trySpawnMummy(pos, facing.func_176746_e().func_176746_e());
    }

    private void trySpawnMummy(BlockPos pos, Direction facing) {
        MummyEntity mummy;
        BlockPos base = pos.func_177972_a(facing);
        if (WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)this.field_70170_p, (BlockPos)base, AtumEntities.MUMMY) && (mummy = (MummyEntity)AtumEntities.MUMMY.func_200721_a(this.field_70170_p)) != null) {
            if (this.field_70170_p instanceof ServerWorld) {
                mummy.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(base), SpawnReason.TRIGGERED, null, null);
                mummy.func_70012_b((double)base.func_177958_n() + 0.5, base.func_177956_o(), (double)base.func_177952_p() + 0.5, 0.0f, 0.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)mummy);
                }
            }
            mummy.func_70656_aK();
            return;
        }
        for (Direction offset : Direction.Plane.HORIZONTAL) {
            MummyEntity mummy2;
            BlockPos newPos = base.func_177972_a(offset);
            if (!WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)this.field_70170_p, (BlockPos)newPos, AtumEntities.MUMMY) || (mummy2 = (MummyEntity)AtumEntities.MUMMY.func_200721_a(this.field_70170_p)) == null) continue;
            if (this.field_70170_p instanceof ServerWorld) {
                mummy2.func_213386_a((IServerWorld)this.field_70170_p, this.field_70170_p.func_175649_E(base), SpawnReason.TRIGGERED, null, null);
                mummy2.func_70012_b((double)newPos.func_177958_n() + 0.5, newPos.func_177956_o(), (double)newPos.func_177952_p() + 0.5, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)mummy2);
                }
            }
            mummy2.func_70656_aK();
            return;
        }
    }

    private void setBossInfo(int variant) {
        this.bossInfo.func_186739_a((ITextComponent)this.func_145748_c_().func_230532_e_().func_230530_a_(this.func_145748_c_().func_150256_b().func_240718_a_(God.getGod(variant).getColor())));
    }
}

