/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.bandit;

import com.teammetallurgy.atum.entity.ai.goal.CustomRangedBowAttackGoal;
import com.teammetallurgy.atum.entity.bandit.BanditBaseEntity;
import com.teammetallurgy.atum.init.AtumItems;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class NomadEntity
extends BanditBaseEntity
implements IRangedAttackMob {
    private final CustomRangedBowAttackGoal<NomadEntity> aiArrowAttack = new CustomRangedBowAttackGoal<NomadEntity>(this, 0.75, 35, 12.0f);
    private final MeleeAttackGoal aiAttackOnCollide = new MeleeAttackGoal((CreatureEntity)this, 1.0, false){

        public void func_75251_c() {
            super.func_75251_c();
            NomadEntity.this.func_213395_q(false);
        }

        public void func_75249_e() {
            super.func_75249_e();
            NomadEntity.this.func_213395_q(true);
        }
    };

    public NomadEntity(EntityType<? extends NomadEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 6;
        this.setCombatTask();
    }

    @Override
    protected int getVariantAmount() {
        return 6;
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return NomadEntity.getBaseAttributes().func_233815_a_(Attributes.field_233818_a_, 13.0).func_233815_a_(Attributes.field_233821_d_, 0.2).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233826_i_, 2.0);
    }

    @Override
    protected void func_180481_a(@Nonnull DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)AtumItems.SHORT_BOW));
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(@Nonnull IServerWorld world, @Nonnull DifficultyInstance difficulty, @Nonnull SpawnReason spawnReason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT nbt) {
        livingdata = super.func_213386_a(world, difficulty, spawnReason, livingdata, nbt);
        this.setCombatTask();
        return livingdata;
    }

    private void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiAttackOnCollide);
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack heldBow = this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)AtumItems.SHORT_BOW));
            if (heldBow.func_77973_b() instanceof BowItem) {
                int cooldown = 20;
                if (this.field_70170_p.func_175659_aa() != Difficulty.HARD) {
                    cooldown = 35;
                }
                this.aiArrowAttack.setAttackCooldown(cooldown);
                this.field_70714_bg.func_75776_a(4, this.aiArrowAttack);
            } else {
                this.field_70714_bg.func_75776_a(4, (Goal)this.aiAttackOnCollide);
            }
        }
    }

    public void func_82196_d(@Nonnull LivingEntity target, float distanceFactor) {
        ItemStack ammo = this.func_213356_f(this.func_184586_b(ProjectileHelper.func_221274_a((LivingEntity)this, (Item)AtumItems.SHORT_BOW)));
        AbstractArrowEntity arrow = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)ammo, (float)distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof BowItem) {
            arrow = ((BowItem)this.func_184614_ca().func_77973_b()).customArrow(arrow);
        }
        double x = target.func_226277_ct_() - this.func_226277_ct_();
        double y = target.func_226283_e_(0.3333333333333333) - arrow.func_226278_cu_();
        double z = target.func_226281_cx_() - this.func_226281_cx_();
        double height = MathHelper.func_76133_a((double)(x * x + z * z));
        arrow.func_70186_c(x, y + height * 0.2, z, 1.6f, (float)(12 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)arrow);
    }

    @Override
    public void func_70037_a(@Nonnull CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setCombatTask();
    }

    public void func_184201_a(@Nonnull EquipmentSlotType slot, @Nonnull ItemStack stack) {
        super.func_184201_a(slot, stack);
        if (!this.field_70170_p.field_72995_K) {
            this.setCombatTask();
        }
    }

    public float func_213307_e(@Nonnull Pose pose) {
        return 1.74f;
    }

    public double func_70033_W() {
        return -0.35;
    }
}

