/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.animal;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.CatLieOnBedGoal;
import net.minecraft.entity.ai.goal.CatSitOnBlockGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NonTamedTargetGoal;
import net.minecraft.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ServalEntity
extends CatEntity {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{AtumItems.SKELETAL_FISH});
    private CatEntity.TemptGoal temptGoal;
    public static final Map<Integer, ResourceLocation> SERVAL_TEXTURE_BY_ID = (Map)Util.func_200696_a((Object)Maps.newHashMap(), m -> {
        m.put(0, new ResourceLocation("atum", "textures/entity/serval/black.png"));
        m.put(1, new ResourceLocation("atum", "textures/entity/serval/white.png"));
        m.put(2, new ResourceLocation("atum", "textures/entity/serval/white_spotted.png"));
        m.put(3, new ResourceLocation("atum", "textures/entity/serval/beige.png"));
        m.put(4, new ResourceLocation("atum", "textures/entity/serval/beige_spotted.png"));
    });

    public ServalEntity(EntityType<? extends CatEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.temptGoal = new CatEntity.TemptGoal((CatEntity)this, 0.6, BREEDING_ITEMS, true);
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new ServalMorningGiftGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)this.temptGoal);
        this.field_70714_bg.func_75776_a(5, (Goal)new CatLieOnBedGoal((CatEntity)this, 1.1, 8));
        this.field_70714_bg.func_75776_a(6, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 10.0f, 5.0f, false));
        this.field_70714_bg.func_75776_a(7, (Goal)new CatSitOnBlockGoal((CatEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (Goal)new LeapAtTargetGoal((MobEntity)this, 0.3f));
        this.field_70714_bg.func_75776_a(9, (Goal)new OcelotAttackGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(10, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(11, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(12, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new NonTamedTargetGoal((TameableEntity)this, RabbitEntity.class, false, null));
        this.field_70715_bh.func_75776_a(1, (Goal)new NonTamedTargetGoal((TameableEntity)this, TurtleEntity.class, false, TurtleEntity.field_203029_bx));
    }

    public boolean func_70877_b(@Nonnull ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    protected float func_213348_b(@Nonnull Pose pose, @Nonnull EntitySize size) {
        return size.field_220316_b * 0.9f;
    }

    @Nonnull
    public ResourceLocation func_213423_ee() {
        return SERVAL_TEXTURE_BY_ID.getOrDefault(this.func_213413_ef(), SERVAL_TEXTURE_BY_ID.get(0));
    }

    public void func_213422_r(int type) {
        if (type < 0 || type > SERVAL_TEXTURE_BY_ID.size()) {
            type = this.field_70146_Z.nextInt(SERVAL_TEXTURE_BY_ID.size());
        }
        this.field_70180_af.func_187227_b(field_213427_bF, (Object)type);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.temptGoal != null && this.temptGoal.func_75277_f() && !this.func_70909_n() && this.field_70173_aa % 100 == 0) {
            this.func_184185_a(SoundEvents.field_219608_aI, 1.0f, 1.0f);
        }
    }

    public CatEntity func_241840_a(@Nonnull ServerWorld serverWorld, @Nonnull AgeableEntity ageableEntity) {
        ServalEntity serval = (ServalEntity)AtumEntities.SERVAL.func_200721_a((World)serverWorld);
        if (serval != null && ageableEntity instanceof ServalEntity) {
            if (this.field_70146_Z.nextBoolean()) {
                serval.func_213422_r(this.func_213413_ef());
            } else {
                serval.func_213422_r(((ServalEntity)ageableEntity).func_213413_ef());
            }
            if (this.func_70909_n()) {
                serval.func_184754_b(this.func_184753_b());
                serval.func_70903_f(true);
                if (this.field_70146_Z.nextBoolean()) {
                    serval.func_213417_a(this.func_213414_ei());
                } else {
                    serval.func_213417_a(((ServalEntity)ageableEntity).func_213414_ei());
                }
            }
        }
        return serval;
    }

    static class ServalMorningGiftGoal
    extends CatEntity.MorningGiftGoal {
        private final CatEntity cat;

        public ServalMorningGiftGoal(CatEntity cat) {
            super(cat);
            this.cat = cat;
        }

        public void func_75251_c() {
            this.cat.func_213419_u(false);
            float f = this.cat.field_70170_p.func_242415_f(1.0f);
            if (this.field_220807_b.func_71060_bI() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.cat.field_70170_p.func_201674_k().nextFloat() < 0.7) {
                this.giveGift();
            }
            this.field_220809_d = 0;
            this.cat.func_213415_v(false);
            this.cat.func_70661_as().func_75499_g();
        }

        private void giveGift() {
            Random random = this.cat.func_70681_au();
            BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            mutablePos.func_189533_g((Vector3i)this.cat.func_233580_cy_());
            this.cat.func_213373_a((double)(mutablePos.func_177958_n() + random.nextInt(11) - 5), (double)(mutablePos.func_177956_o() + random.nextInt(5) - 2), (double)(mutablePos.func_177952_p() + random.nextInt(11) - 5), false);
            mutablePos.func_189533_g((Vector3i)this.cat.func_233580_cy_());
            LootTable lootTable = this.cat.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(AtumLootTables.GAMEPLAY_SERVAL_MORNING_GIFT);
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.cat.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)this.cat.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)this.cat).func_216023_a(random);
            for (ItemStack stack : lootTable.func_216113_a(builder.func_216022_a(LootParameterSets.field_216264_e))) {
                this.cat.field_70170_p.func_217376_c((Entity)new ItemEntity(this.cat.field_70170_p, (double)mutablePos.func_177958_n() - (double)MathHelper.func_76126_a((float)(this.cat.field_70761_aq * ((float)Math.PI / 180))), (double)mutablePos.func_177956_o(), (double)mutablePos.func_177952_p() + (double)MathHelper.func_76134_b((float)(this.cat.field_70761_aq * ((float)Math.PI / 180))), stack));
            }
        }
    }
}

