/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.ai.brain.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.teammetallurgy.atum.api.AtumAPI;
import com.teammetallurgy.atum.entity.ai.brain.task.AtumAssignProfessionTask;
import com.teammetallurgy.atum.entity.ai.brain.task.AtumChangeJobTask;
import com.teammetallurgy.atum.entity.ai.brain.task.AtumFarmTask;
import com.teammetallurgy.atum.entity.ai.brain.task.AtumFarmerWorkTask;
import com.teammetallurgy.atum.entity.ai.brain.task.AtumFindJobTask;
import com.teammetallurgy.atum.entity.ai.brain.task.AtumShareItemsTask;
import com.teammetallurgy.atum.entity.ai.brain.task.CreateBabyVillagerWithGenderTask;
import com.teammetallurgy.atum.entity.ai.brain.task.CuratorAdmireItemTask;
import com.teammetallurgy.atum.entity.ai.brain.task.CuratorStartAdmiringItemTask;
import com.teammetallurgy.atum.entity.ai.brain.task.SwitchAtumVillagerJobTask;
import com.teammetallurgy.atum.entity.villager.AtumVillagerEntity;
import com.teammetallurgy.atum.entity.villager.AtumVillagerProfession;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.items.RelicItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.task.BeginRaidTask;
import net.minecraft.entity.ai.brain.task.BoneMealCropsTask;
import net.minecraft.entity.ai.brain.task.ClearHurtTask;
import net.minecraft.entity.ai.brain.task.CongregateTask;
import net.minecraft.entity.ai.brain.task.DummyTask;
import net.minecraft.entity.ai.brain.task.ExpireHidingTask;
import net.minecraft.entity.ai.brain.task.ExpirePOITask;
import net.minecraft.entity.ai.brain.task.FindHidingPlaceTask;
import net.minecraft.entity.ai.brain.task.FindInteractionAndLookTargetTask;
import net.minecraft.entity.ai.brain.task.FindPotentialJobTask;
import net.minecraft.entity.ai.brain.task.FindWalkTargetTask;
import net.minecraft.entity.ai.brain.task.FirstShuffledTask;
import net.minecraft.entity.ai.brain.task.GatherPOITask;
import net.minecraft.entity.ai.brain.task.GiveHeroGiftsTask;
import net.minecraft.entity.ai.brain.task.HideFromRaidOnBellRingTask;
import net.minecraft.entity.ai.brain.task.InteractWithDoorTask;
import net.minecraft.entity.ai.brain.task.InteractWithEntityTask;
import net.minecraft.entity.ai.brain.task.JumpOnBedTask;
import net.minecraft.entity.ai.brain.task.LookAtEntityTask;
import net.minecraft.entity.ai.brain.task.LookTask;
import net.minecraft.entity.ai.brain.task.MultiTask;
import net.minecraft.entity.ai.brain.task.PanicTask;
import net.minecraft.entity.ai.brain.task.PickupWantedItemTask;
import net.minecraft.entity.ai.brain.task.RunAwayTask;
import net.minecraft.entity.ai.brain.task.ShowWaresTask;
import net.minecraft.entity.ai.brain.task.SleepAtHomeTask;
import net.minecraft.entity.ai.brain.task.SpawnGolemTask;
import net.minecraft.entity.ai.brain.task.StayNearPointTask;
import net.minecraft.entity.ai.brain.task.SwimTask;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.TradeTask;
import net.minecraft.entity.ai.brain.task.UpdateActivityTask;
import net.minecraft.entity.ai.brain.task.WakeUpTask;
import net.minecraft.entity.ai.brain.task.WalkRandomlyInsideTask;
import net.minecraft.entity.ai.brain.task.WalkToHouseTask;
import net.minecraft.entity.ai.brain.task.WalkToPOITask;
import net.minecraft.entity.ai.brain.task.WalkToTargetTask;
import net.minecraft.entity.ai.brain.task.WalkToVillagerBabiesTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsLookTargetTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsPosTask;
import net.minecraft.entity.ai.brain.task.WalkTowardsRandomSecondaryPosTask;
import net.minecraft.entity.ai.brain.task.WorkTask;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.village.PointOfInterestType;

public class AtumVillagerTasks {
    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> core(EntityType<? extends AtumVillagerEntity> entityType, AtumVillagerProfession profession, float f) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new SwimTask(0.8f)), (Object)Pair.of((Object)0, (Object)new InteractWithDoorTask()), (Object)Pair.of((Object)0, (Object)new LookTask(45, 90)), (Object)Pair.of((Object)0, (Object)new PanicTask()), (Object)Pair.of((Object)0, (Object)new WakeUpTask()), (Object)Pair.of((Object)0, (Object)new HideFromRaidOnBellRingTask()), (Object)Pair.of((Object)0, (Object)new BeginRaidTask()), (Object)Pair.of((Object)0, (Object)new ExpirePOITask(profession.getPointOfInterest(), MemoryModuleType.field_220942_c)), (Object)Pair.of((Object)0, (Object)new ExpirePOITask(profession.getPointOfInterest(), MemoryModuleType.field_234101_d_)), (Object)Pair.of((Object)1, (Object)new WalkToTargetTask()), (Object)Pair.of((Object)2, (Object)((Object)new SwitchAtumVillagerJobTask(profession))), (Object)Pair.of((Object)3, (Object)new TradeTask(f)), (Object[])new Pair[]{Pair.of((Object)3, new CuratorStartAdmiringItemTask()), Pair.of((Object)3, new CuratorAdmireItemTask(80)), Pair.of((Object)5, (Object)new PickupWantedItemTask(f, profession == AtumVillagerProfession.CURATOR.get(), profession == AtumVillagerProfession.CURATOR.get() ? 9 : 4)), Pair.of((Object)6, (Object)new GatherPOITask(profession.getPointOfInterest(), MemoryModuleType.field_220942_c, MemoryModuleType.field_234101_d_, true, Optional.empty())), Pair.of((Object)7, (Object)new FindPotentialJobTask(f)), Pair.of((Object)8, (Object)((Object)new AtumFindJobTask(f))), Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221069_q, MemoryModuleType.field_220941_b, false, Optional.of((byte)14))), Pair.of((Object)10, (Object)new GatherPOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d, true, Optional.of((byte)14))), Pair.of((Object)10, (Object)((Object)new AtumAssignProfessionTask())), Pair.of((Object)10, (Object)((Object)new AtumChangeJobTask()))});
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> work(EntityType<? extends AtumVillagerEntity> entityType, AtumVillagerProfession profession, float p_220639_1_) {
        AtumFarmerWorkTask spawngolemtask = profession == AtumVillagerProfession.FARMER.get() ? new AtumFarmerWorkTask() : new SpawnGolemTask();
        return ImmutableList.of(AtumVillagerTasks.lookAtPlayerOrVillager(entityType), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)((Object)spawngolemtask), (Object)7), (Object)Pair.of((Object)new WorkTask(MemoryModuleType.field_220942_c, 0.4f, 4), (Object)2), (Object)Pair.of((Object)new WalkTowardsPosTask(MemoryModuleType.field_220942_c, 0.4f, 1, 10), (Object)5), (Object)Pair.of((Object)new WalkTowardsRandomSecondaryPosTask(MemoryModuleType.field_220944_e, p_220639_1_, 1, 6, MemoryModuleType.field_220942_c), (Object)5), (Object)Pair.of((Object)((Object)new AtumFarmTask()), (Object)(profession == AtumVillagerProfession.FARMER.get() ? 2 : 5)), (Object)Pair.of((Object)new BoneMealCropsTask(), (Object)(profession == AtumVillagerProfession.FARMER.get() ? 4 : 7))))), (Object)Pair.of((Object)10, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)2, (Object)new StayNearPointTask(MemoryModuleType.field_220942_c, p_220639_1_, 9, 100, 1200)), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> play(EntityType<? extends AtumVillagerEntity> entityType, float walkingSpeed) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new WalkToTargetTask(80, 120)), AtumVillagerTasks.lookAtMany(entityType), (Object)Pair.of((Object)5, (Object)new WalkToVillagerBabiesTask()), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220947_h, (Object)MemoryModuleStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)InteractWithEntityTask.func_220445_a(entityType, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)walkingSpeed, (int)2), (Object)2), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a(AtumEntities.SERVAL, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)walkingSpeed, (int)2), (Object)1), (Object)Pair.of((Object)new FindWalkTargetTask(walkingSpeed), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(walkingSpeed, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(walkingSpeed), (Object)2), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> rest(EntityType<? extends AtumVillagerEntity> entityType, float walkingSpeed) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new StayNearPointTask(MemoryModuleType.field_220941_b, walkingSpeed, 1, 150, 1200)), (Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.field_221069_q, MemoryModuleType.field_220941_b)), (Object)Pair.of((Object)3, (Object)new SleepAtHomeTask()), (Object)Pair.of((Object)5, (Object)new FirstShuffledTask((Map)ImmutableMap.of((Object)MemoryModuleType.field_220941_b, (Object)MemoryModuleStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)new WalkToHouseTask(walkingSpeed), (Object)1), (Object)Pair.of((Object)new WalkRandomlyInsideTask(walkingSpeed), (Object)4), (Object)Pair.of((Object)new WalkToPOITask(walkingSpeed, 4), (Object)2), (Object)Pair.of((Object)new DummyTask(20, 40), (Object)2)))), AtumVillagerTasks.lookAtPlayerOrVillager(entityType), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> meet(EntityType<? extends AtumVillagerEntity> entityType, float p_220637_1_) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new WorkTask(MemoryModuleType.field_220943_d, 0.4f, 40), (Object)2), (Object)Pair.of((Object)new CongregateTask(), (Object)2)))), (Object)Pair.of((Object)10, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)10, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)2, (Object)new StayNearPointTask(MemoryModuleType.field_220943_d, p_220637_1_, 6, 100, 200)), (Object)Pair.of((Object)3, (Object)new GiveHeroGiftsTask(100)), (Object)Pair.of((Object)3, (Object)new ExpirePOITask(PointOfInterestType.field_221070_r, MemoryModuleType.field_220943_d)), (Object)Pair.of((Object)3, (Object)new MultiTask((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.field_220952_m), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)((Object)new AtumShareItemsTask()), (Object)1)))), AtumVillagerTasks.lookAtMany(entityType), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> idle(EntityType<? extends AtumVillagerEntity> entityType, float f) {
        return ImmutableList.of((Object)Pair.of((Object)2, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)InteractWithEntityTask.func_220445_a(entityType, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)f, (int)2), (Object)2), (Object)Pair.of((Object)new InteractWithEntityTask(entityType == AtumEntities.VILLAGER_MALE ? AtumEntities.VILLAGER_FEMALE : AtumEntities.VILLAGER_MALE, 8, AgeableEntity::func_213743_em, AgeableEntity::func_213743_em, MemoryModuleType.field_220953_n, f, 2), (Object)1), (Object)Pair.of((Object)InteractWithEntityTask.func_220445_a(AtumEntities.SERVAL, (int)8, (MemoryModuleType)MemoryModuleType.field_220952_m, (float)f, (int)2), (Object)1), (Object)Pair.of((Object)new FindWalkTargetTask(f), (Object)1), (Object)Pair.of((Object)new WalkTowardsLookTargetTask(f, 2), (Object)1), (Object)Pair.of((Object)new JumpOnBedTask(f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)1)))), (Object)Pair.of((Object)3, (Object)new GiveHeroGiftsTask(100)), (Object)Pair.of((Object)3, (Object)new FindInteractionAndLookTargetTask(EntityType.field_200729_aH, 4)), (Object)Pair.of((Object)3, (Object)new ShowWaresTask(400, 1600)), (Object)Pair.of((Object)3, (Object)new MultiTask((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.field_220952_m), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)((Object)new AtumShareItemsTask()), (Object)1)))), (Object)Pair.of((Object)3, (Object)new MultiTask((Map)ImmutableMap.of(), (Set)ImmutableSet.of((Object)MemoryModuleType.field_220953_n), MultiTask.Ordering.ORDERED, MultiTask.RunType.RUN_ONE, (List)ImmutableList.of((Object)Pair.of((Object)((Object)new CreateBabyVillagerWithGenderTask()), (Object)1)))), AtumVillagerTasks.lookAtMany(entityType), (Object)Pair.of((Object)99, (Object)new UpdateActivityTask()));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> panic(EntityType<? extends AtumVillagerEntity> entityType, float f1) {
        float f = f1 * 1.5f;
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new ClearHurtTask()), (Object)Pair.of((Object)1, (Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_220959_t, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)1, (Object)RunAwayTask.func_233965_b_((MemoryModuleType)MemoryModuleType.field_220958_s, (float)f, (int)6, (boolean)false)), (Object)Pair.of((Object)3, (Object)new FindWalkTargetTask(f, 2, 2)), AtumVillagerTasks.lookAtPlayerOrVillager(entityType));
    }

    public static ImmutableList<Pair<Integer, ? extends Task<? super VillagerEntity>>> hide(EntityType<? extends AtumVillagerEntity> entityType, float f) {
        return ImmutableList.of((Object)Pair.of((Object)0, (Object)new ExpireHidingTask(15, 3)), (Object)Pair.of((Object)1, (Object)new FindHidingPlaceTask(32, f * 1.25f, 2)), AtumVillagerTasks.lookAtPlayerOrVillager(entityType));
    }

    private static Pair<Integer, Task<LivingEntity>> lookAtMany(EntityType<? extends AtumVillagerEntity> entityType) {
        return Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(AtumEntities.SERVAL, 8.0f), (Object)8), (Object)Pair.of((Object)new LookAtEntityTask(entityType, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.WATER_CREATURE, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.WATER_AMBIENT, 8.0f), (Object)1), (Object)Pair.of((Object)new LookAtEntityTask(EntityClassification.MONSTER, 8.0f), (Object)1), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)2))));
    }

    private static Pair<Integer, Task<LivingEntity>> lookAtPlayerOrVillager(EntityType<? extends AtumVillagerEntity> entityType) {
        return Pair.of((Object)5, (Object)new FirstShuffledTask((List)ImmutableList.of((Object)Pair.of((Object)new LookAtEntityTask(entityType, 8.0f), (Object)2), (Object)Pair.of((Object)new LookAtEntityTask(EntityType.field_200729_aH, 8.0f), (Object)2), (Object)Pair.of((Object)new DummyTask(30, 60), (Object)8))));
    }

    protected static void trade(VillagerEntity entity, boolean shouldTrade) {
        ItemStack heldStack = entity.func_184586_b(Hand.OFF_HAND);
        entity.func_184611_a(Hand.OFF_HAND, ItemStack.field_190927_a);
        if (!entity.func_70631_g_()) {
            boolean flag1;
            boolean isCurrency = heldStack.func_77973_b().func_206844_a(AtumAPI.Tags.RELIC_NON_DIRTY);
            if (shouldTrade && isCurrency) {
                AtumVillagerTasks.spawnItem(entity, AtumVillagerTasks.getCuratorTrades(heldStack));
            } else if (!isCurrency && !(flag1 = entity.func_233665_g_(heldStack))) {
                AtumVillagerTasks.addItemToInventory(entity, heldStack);
            }
        }
    }

    private static void spawnItem(VillagerEntity entity, List<ItemStack> stacks) {
        Optional optional = entity.func_213375_cj().func_218207_c(MemoryModuleType.field_220949_j);
        if (optional.isPresent()) {
            AtumVillagerTasks.spawnItemNearPlayer(entity, (PlayerEntity)optional.get(), stacks);
        } else {
            AtumVillagerTasks.spawnItemOnGround(entity, stacks);
        }
    }

    private static List<ItemStack> getCuratorTrades(ItemStack relicStack) {
        ArrayList<ItemStack> trades = new ArrayList<ItemStack>();
        if (relicStack.func_77973_b() instanceof RelicItem) {
            RelicItem.Type type = RelicItem.getType(relicStack.func_77973_b());
            RelicItem.Quality quality = RelicItem.getQuality(relicStack.func_77973_b());
            trades.add(new ItemStack((IItemProvider)AtumItems.GOLD_COIN, AtumVillagerTasks.getCoinAmount(type, quality)));
        }
        return trades;
    }

    private static int getCoinAmount(RelicItem.Type type, RelicItem.Quality quality) {
        double modifier = AtumVillagerTasks.getCoinModifier(type);
        int amount = 0;
        if (quality == RelicItem.Quality.SILVER) {
            amount = (int)((double)amount + modifier);
        } else if (quality == RelicItem.Quality.GOLD) {
            amount = (int)((double)amount + modifier * 1.5);
        } else if (quality == RelicItem.Quality.SAPPHIRE) {
            amount = (int)((double)amount + modifier * 2.0);
        } else if (quality == RelicItem.Quality.RUBY) {
            amount = (int)((double)amount + modifier * 2.5);
        } else if (quality == RelicItem.Quality.EMERALD) {
            amount = (int)((double)amount + modifier * 3.5);
        } else if (quality == RelicItem.Quality.DIAMOND) {
            amount = (int)((double)amount + modifier * 5.0);
        }
        return amount;
    }

    private static double getCoinModifier(RelicItem.Type type) {
        double modifier = 1.0;
        if (type == RelicItem.Type.NECKLACE) {
            modifier = 1.5;
        } else if (type == RelicItem.Type.BROOCH) {
            modifier = 2.0;
        } else if (type == RelicItem.Type.BRACELET) {
            modifier = 2.5;
        } else if (type == RelicItem.Type.IDOL) {
            modifier = 3.5;
        }
        return modifier;
    }

    private static void spawnItemNearPlayer(VillagerEntity entity, PlayerEntity player, List<ItemStack> stacks) {
        AtumVillagerTasks.spawnItemNearEntity(entity, stacks, player.func_213303_ch());
    }

    private static void spawnItemNearEntity(VillagerEntity entity, List<ItemStack> stacks, Vector3d vec3d) {
        if (!stacks.isEmpty()) {
            entity.func_184609_a(Hand.OFF_HAND);
            for (ItemStack stack : stacks) {
                BrainUtil.func_233865_a_((LivingEntity)entity, (ItemStack)stack, (Vector3d)vec3d.func_72441_c(0.0, 1.0, 0.0));
            }
        }
    }

    private static void spawnItemOnGround(VillagerEntity entity, List<ItemStack> stacks) {
        AtumVillagerTasks.spawnItemNearEntity(entity, stacks, AtumVillagerTasks.getLandPos(entity));
    }

    private static Vector3d getLandPos(VillagerEntity entity) {
        Vector3d vector3d = RandomPositionGenerator.func_191377_b((CreatureEntity)entity, (int)4, (int)2);
        return vector3d == null ? entity.func_213303_ch() : vector3d;
    }

    private static void addItemToInventory(VillagerEntity entity, @Nonnull ItemStack stack) {
        ItemStack itemstack = entity.func_213715_ed().func_174894_a(stack);
        AtumVillagerTasks.spawnItemOnGround(entity, Collections.singletonList(itemstack));
    }

    public static boolean canPickup(VillagerEntity entity) {
        return entity.func_184592_cb().func_190926_b() || !entity.func_184592_cb().func_77973_b().func_206844_a(AtumAPI.Tags.RELIC_NON_DIRTY);
    }

    public static void putInHand(VillagerEntity entity, ItemEntity itemEntity) {
        if (entity instanceof AtumVillagerEntity) {
            entity.func_213375_cj().func_218189_b(MemoryModuleType.field_220950_k);
            entity.func_70661_as().func_75499_g();
            entity.func_71001_a((Entity)itemEntity, 1);
            ItemStack stack = AtumVillagerTasks.setEntityItemStack(itemEntity);
            Item item = stack.func_77973_b();
            if (item.func_206844_a(AtumAPI.Tags.RELIC_NON_DIRTY)) {
                entity.func_213375_cj().func_218189_b(MemoryModuleType.field_242310_O);
                AtumVillagerTasks.dropOffhand((AtumVillagerEntity)entity, stack);
                entity.func_213375_cj().func_233696_a_(MemoryModuleType.field_234080_N_, (Object)true, 120L);
            }
        }
    }

    private static ItemStack setEntityItemStack(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        ItemStack itemstack1 = itemstack.func_77979_a(1);
        if (itemstack.func_190926_b()) {
            itemEntity.func_70106_y();
        } else {
            itemEntity.func_92058_a(itemstack);
        }
        return itemstack1;
    }

    private static void dropOffhand(AtumVillagerEntity entity, @Nonnull ItemStack stack) {
        if (!entity.func_184592_cb().func_190926_b()) {
            entity.func_199701_a_(entity.func_184586_b(Hand.OFF_HAND));
        }
        entity.setOffHand(stack);
    }

    public static boolean canCuratorPickup(AtumVillagerEntity entity, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (entity.func_213375_cj().func_218191_a(MemoryModuleType.field_234081_O_) && entity.func_213375_cj().func_218191_a(MemoryModuleType.field_234103_o_)) {
            return false;
        }
        if (item.func_206844_a(AtumAPI.Tags.RELIC_NON_DIRTY)) {
            return AtumVillagerTasks.canPickup(entity);
        }
        return false;
    }
}

