/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.SarcophagusBlock;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity.SarcophagusTileEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class SarcophagusRender
extends TileEntityRenderer<SarcophagusTileEntity> {
    private static final ResourceLocation SARCOPHAGUS = new ResourceLocation("atum", "textures/entity/chest/sarcophagus.png");
    private static final RenderType SARCOPHAGUS_RENDER = RenderType.func_228638_b_((ResourceLocation)SARCOPHAGUS);
    public ModelRenderer sarcophagusBase;
    public ModelRenderer sarcophagusLid = new ModelRenderer(128, 64, 0, 0);
    public ModelRenderer sarcophagusLiddeco1;
    public ModelRenderer sarcophagusLiddeco2;
    public ModelRenderer sarcophagusLiddeco3;
    public ModelRenderer sarcophagusGemchest;
    public ModelRenderer sarcophagusGemhead;

    public SarcophagusRender(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.sarcophagusLid.func_78793_a(1.0f, 14.0f, 9.0f);
        this.sarcophagusLid.func_228301_a_(-16.0f, -2.0f, -16.0f, 30.0f, 2.0f, 14.0f, 0.0f);
        this.sarcophagusGemchest = new ModelRenderer(128, 64, 0, 45);
        this.sarcophagusGemchest.func_78793_a(1.0f, 14.0f, 9.0f);
        this.sarcophagusGemchest.func_228301_a_(0.0f, -4.5f, -10.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.sarcophagusBase = new ModelRenderer(128, 64, 0, 19);
        this.sarcophagusBase.func_78793_a(1.0f, 14.0f, 9.0f);
        this.sarcophagusBase.func_228301_a_(-16.0f, 0.0f, -16.0f, 30.0f, 10.0f, 14.0f, 0.0f);
        this.sarcophagusLiddeco3 = new ModelRenderer(128, 64, 0, 45);
        this.sarcophagusLiddeco3.func_78793_a(1.0f, 14.0f, 9.0f);
        this.sarcophagusLiddeco3.func_228301_a_(-4.0f, -4.0f, -13.0f, 15.0f, 1.0f, 8.0f, 0.0f);
        this.sarcophagusGemhead = new ModelRenderer(128, 64, 0, 45);
        this.sarcophagusGemhead.func_78793_a(1.0f, 14.0f, 9.0f);
        this.sarcophagusGemhead.func_228301_a_(-12.0f, -4.5f, -10.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.sarcophagusLiddeco1 = new ModelRenderer(128, 64, 48, 51);
        this.sarcophagusLiddeco1.func_78793_a(1.0f, 14.0f, 9.0f);
        this.sarcophagusLiddeco1.func_228301_a_(-15.0f, -3.0f, -15.0f, 28.0f, 1.0f, 12.0f, 0.0f);
        this.sarcophagusLiddeco2 = new ModelRenderer(128, 64, 90, 0);
        this.sarcophagusLiddeco2.func_78793_a(1.0f, 14.0f, 9.0f);
        this.sarcophagusLiddeco2.func_228301_a_(-14.0f, -4.0f, -13.0f, 8.0f, 1.0f, 8.0f, 0.0f);
    }

    public void render(SarcophagusTileEntity sarcophagus, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = sarcophagus.func_145831_w();
        boolean worldNotNull = world != null;
        BlockState state = worldNotNull ? sarcophagus.func_195044_w() : (BlockState)AtumBlocks.SARCOPHAGUS.func_176223_P().func_206870_a((Property)SarcophagusBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType type = state.func_235901_b_((Property)SarcophagusBlock.field_196314_b) ? (ChestType)state.func_177229_b((Property)SarcophagusBlock.field_196314_b) : ChestType.SINGLE;
        Block block = state.func_177230_c();
        if (block instanceof SarcophagusBlock) {
            SarcophagusBlock sarcophagusBlock = (SarcophagusBlock)block;
            matrixStack.func_227860_a_();
            Direction facing = (Direction)state.func_177229_b((Property)SarcophagusBlock.field_176459_a);
            float facingAngle = facing.func_185119_l();
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                facingAngle = facing.func_176734_d().func_185119_l();
            }
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(facingAngle));
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper callbackWrapper = worldNotNull ? sarcophagusBlock.func_225536_a_(state, world, sarcophagus.func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            int light = ((Int2IntFunction)callbackWrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLight);
            IVertexBuilder vertexBuilder = buffer.getBuffer(SARCOPHAGUS_RENDER);
            matrixStack.func_227861_a_(0.0, 1.5, 0.5);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            if (type == ChestType.RIGHT) {
                float lidAngle = ((Float2FloatFunction)callbackWrapper.apply(SarcophagusBlock.func_226917_a_((IChestLid)sarcophagus))).get(partialTicks);
                lidAngle = 1.0f - lidAngle;
                lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
                this.renderSarcophagus(matrixStack, vertexBuilder, this.sarcophagusBase, this.sarcophagusLid, this.sarcophagusLiddeco1, this.sarcophagusLiddeco2, this.sarcophagusLiddeco3, this.sarcophagusGemhead, this.sarcophagusGemchest, lidAngle, light, combinedOverlay);
            } else if (world == null) {
                matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                matrixStack.func_227861_a_(-0.7, 0.3, 0.0);
                this.renderSarcophagus(matrixStack, vertexBuilder, this.sarcophagusBase, this.sarcophagusLid, this.sarcophagusLiddeco1, this.sarcophagusLiddeco2, this.sarcophagusLiddeco3, this.sarcophagusGemhead, this.sarcophagusGemchest, 0.0f, light, combinedOverlay);
            }
            matrixStack.func_227865_b_();
        }
    }

    private void renderSarcophagus(MatrixStack matrixStack, IVertexBuilder vertexBuilder, ModelRenderer base, ModelRenderer lid, ModelRenderer liddeco1, ModelRenderer liddeco2, ModelRenderer liddeco3, ModelRenderer gemhead, ModelRenderer gemchest, float lidAngle, int light, int combinedOverlay) {
        lid.field_78796_g = -lidAngle / 2.0f;
        liddeco1.field_78796_g = -lidAngle / 2.0f;
        liddeco2.field_78796_g = -lidAngle / 2.0f;
        liddeco3.field_78796_g = -lidAngle / 2.0f;
        gemhead.field_78796_g = -lidAngle / 2.0f;
        gemchest.field_78796_g = -lidAngle / 2.0f;
        base.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
        lid.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
        liddeco1.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
        liddeco2.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
        liddeco3.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
        gemhead.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
        gemchest.func_228308_a_(matrixStack, vertexBuilder, light, combinedOverlay);
    }
}

