/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammetallurgy.atum.client.model.entity.StonewardenModel;
import com.teammetallurgy.atum.entity.stone.StonewardenEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StonewardenRender
extends MobRenderer<StonewardenEntity, StonewardenModel<StonewardenEntity>> {
    private static final Map<Integer, ResourceLocation> CACHE = Maps.newHashMap();

    public StonewardenRender(EntityRendererManager manager) {
        super(manager, new StonewardenModel(), 0.5f);
    }

    protected void applyRotations(@Nonnull StonewardenEntity stonewarden, @Nonnull MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_((LivingEntity)stonewarden, matrixStack, ageInTicks, rotationYaw, partialTicks);
        if ((double)stonewarden.field_70721_aZ >= 0.01) {
            float swingValue = stonewarden.field_184619_aG - stonewarden.field_70721_aZ * (1.0f - partialTicks) + 6.0f;
            float swing = (Math.abs(swingValue % 13.0f - 6.5f) - 3.25f) / 3.25f;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(6.5f * swing));
        }
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull StonewardenEntity stonewarden) {
        ResourceLocation location = CACHE.get(stonewarden.getVariant());
        if (location == null) {
            location = new ResourceLocation("atum", "textures/entity/stonewarden_" + stonewarden.getVariant() + ".png");
            CACHE.put(stonewarden.getVariant(), location);
        }
        return location;
    }
}

