/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.teammetallurgy.atum.client.model.entity.DesertWolfModel;
import com.teammetallurgy.atum.client.render.entity.layer.DesertWolfArmorLayer;
import com.teammetallurgy.atum.client.render.entity.layer.DesertWolfCollarLayer;
import com.teammetallurgy.atum.client.render.entity.layer.DesertWolfSaddleLayer;
import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DesertWolfRender
extends MobRenderer<DesertWolfEntity, DesertWolfModel<DesertWolfEntity>> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();
    private static final ResourceLocation TAMED_DESERT_WOLF_TEXTURES = new ResourceLocation("atum", "textures/entity/desert_wolf_tame.png");
    private static final ResourceLocation ANGRY_DESERT_WOLF_TEXTURES = new ResourceLocation("atum", "textures/entity/desert_wolf_angry.png");

    public DesertWolfRender(EntityRendererManager renderManager) {
        super(renderManager, new DesertWolfModel(0.0f), 0.5f);
        this.func_177094_a(new DesertWolfCollarLayer((IEntityRenderer<DesertWolfEntity, DesertWolfModel<DesertWolfEntity>>)this));
        this.func_177094_a(new DesertWolfSaddleLayer((IEntityRenderer<DesertWolfEntity, DesertWolfModel<DesertWolfEntity>>)this));
        this.func_177094_a(new DesertWolfArmorLayer((IEntityRenderer<DesertWolfEntity, DesertWolfModel<DesertWolfEntity>>)this));
    }

    protected float handleRotationFloat(DesertWolfEntity desertWolf, float rotation) {
        return desertWolf.getTailRotation();
    }

    public void render(@Nonnull DesertWolfEntity desertWolf, float entityYaw, float partialTicks, @Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int i) {
        if (desertWolf.isWolfWet()) {
            float f = desertWolf.func_70013_c() * desertWolf.getShadingWhileWet(partialTicks);
            ((DesertWolfModel)this.field_77045_g).func_228253_a_(f, f, f);
        }
        super.func_225623_a_((MobEntity)desertWolf, entityYaw, partialTicks, matrixStack, buffer, i);
        if (desertWolf.isWolfWet()) {
            ((DesertWolfModel)this.field_77045_g).func_228253_a_(1.0f, 1.0f, 1.0f);
        }
    }

    @Nonnull
    public ResourceLocation getEntityTexture(@Nonnull DesertWolfEntity desertWolf) {
        String textureName = desertWolf.getTexture();
        ResourceLocation location = CACHE.get(textureName);
        if (location == null) {
            location = desertWolf.func_233678_J__() ? ANGRY_DESERT_WOLF_TEXTURES : TAMED_DESERT_WOLF_TEXTURES;
            CACHE.put(textureName, location);
        }
        return location;
    }

    protected void preRenderCallback(DesertWolfEntity desertWolf, @Nonnull MatrixStack matrixStack, float partialTickTime) {
        if (desertWolf.isAlpha()) {
            float scale = 1.5f;
            matrixStack.func_227862_a_(scale, scale, scale);
        }
    }
}

