/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teammetallurgy.atum.client.model.entity.DesertWolfModel;
import com.teammetallurgy.atum.entity.animal.DesertWolfEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class DesertWolfArmorLayer
extends LayerRenderer<DesertWolfEntity, DesertWolfModel<DesertWolfEntity>> {
    private static final Map<DesertWolfEntity.ArmorType, ResourceLocation> CACHE = (Map)Util.func_200696_a((Object)Maps.newEnumMap(DesertWolfEntity.ArmorType.class), m -> {
        m.put(DesertWolfEntity.ArmorType.NONE, null);
        m.put(DesertWolfEntity.ArmorType.IRON, new ResourceLocation("atum", "textures/entity/armor/desert_wolf_armor_iron.png"));
        m.put(DesertWolfEntity.ArmorType.GOLD, new ResourceLocation("atum", "textures/entity/armor/desert_wolf_armor_gold.png"));
        m.put(DesertWolfEntity.ArmorType.DIAMOND, new ResourceLocation("atum", "textures/entity/armor/desert_wolf_armor_diamond.png"));
    });
    private final DesertWolfModel<DesertWolfEntity> model = new DesertWolfModel(0.1f);

    public DesertWolfArmorLayer(IEntityRenderer<DesertWolfEntity, DesertWolfModel<DesertWolfEntity>> entityRenderer) {
        super(entityRenderer);
    }

    public void render(@Nonnull MatrixStack matrixStack, @Nonnull IRenderTypeBuffer buffer, int packedLight, DesertWolfEntity desertWolf, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack armor = desertWolf.getArmor();
        if (!armor.func_190926_b()) {
            DesertWolfEntity.ArmorType armorType = DesertWolfEntity.ArmorType.getByItemStack(armor);
            ((DesertWolfModel)this.func_215332_c()).func_217111_a((EntityModel)this.model);
            this.model.setLivingAnimations(desertWolf, limbSwing, limbSwingAmount, partialTicks);
            this.model.setRotationAngles(desertWolf, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            IVertexBuilder ivertexbuilder = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)CACHE.get((Object)armorType)));
            this.model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

