/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.particle;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LightSparkleParticle
extends SpriteTexturedParticle {
    private final float particleScaleOverTime;

    public LightSparkleParticle(ClientWorld world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, IAnimatedSprite spriteSet) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.field_187129_i *= (double)0.01f;
        this.field_187130_j *= (double)0.01f;
        this.field_187131_k *= (double)0.01f;
        this.field_187130_j += 0.1;
        this.field_70544_f *= 0.4f;
        this.particleScaleOverTime = this.field_70544_f;
        this.field_70547_e = 16;
        this.func_217566_b(spriteSet);
    }

    public void func_225606_a_(@Nonnull IVertexBuilder builder, @Nonnull ActiveRenderInfo renderInfo, float partialTicks) {
        float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e * 32.0f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        this.field_70544_f = this.particleScaleOverTime * f;
        super.func_225606_a_(builder, renderInfo, partialTicks);
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187127_g == this.field_187124_d) {
            this.field_187129_i *= 1.1;
            this.field_187131_k *= 1.1;
        }
        this.field_187129_i *= (double)0.86f;
        this.field_187130_j *= (double)0.86f;
        this.field_187131_k *= (double)0.86f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle makeParticle(@Nonnull BasicParticleType particleType, @Nonnull ClientWorld world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new LightSparkleParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

