/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class RenderUtils {
    public static void renderItem(TileEntity tileEntity, @Nonnull ItemStack stack, float rotation, double yOffset, boolean drawStackSize, boolean rotateEastWest, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        RenderUtils.renderItem(tileEntity, stack, Vector3f.field_229181_d_.func_229187_a_(rotation), yOffset, drawStackSize, rotateEastWest, 90.0f, matrixStack, buffer, combinedLight, combinedOverlay);
    }

    public static void renderItem(TileEntity tileEntity, @Nonnull ItemStack stack, Quaternion rotation, double yOffset, boolean drawStackSize, boolean rotateEastWest, float eastWestDegress, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (!stack.func_190926_b()) {
            BlockState state;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, yOffset + (double)1.225f, 0.5);
            if (!(stack.func_77973_b() instanceof BlockItem)) {
                matrixStack.func_227863_a_(rotation);
            }
            if (stack.func_77973_b().isShield(stack, null)) {
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                matrixStack.func_227861_a_(0.15, (double)0.1f, (double)0.15f);
            }
            if ((state = tileEntity.func_195044_w()).func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                if (rotateEastWest) {
                    if (facing == Direction.EAST || facing == Direction.WEST) {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(eastWestDegress));
                    }
                } else {
                    if (facing == Direction.EAST) {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                    }
                    if (facing == Direction.WEST) {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                    }
                    if (facing == Direction.NORTH) {
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    }
                }
            }
            matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.NONE, combinedLight, combinedOverlay, matrixStack, buffer);
            matrixStack.func_227865_b_();
            if (drawStackSize) {
                String stackSize = String.valueOf(stack.func_190916_E());
                RenderUtils.drawString(tileEntity, stackSize, 0.5, 0.75, 0.5, 0.003f, matrixStack, buffer, combinedLight, combinedOverlay);
            }
        }
    }

    public static void drawString(TileEntity te, String str, double xOffset, double yOffset, double zOffset, float scaleModifier, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        TileEntityRendererDispatcher rendererDispatcher = TileEntityRendererDispatcher.field_147556_a;
        Entity entity = rendererDispatcher.field_217666_g.func_216773_g();
        BlockPos tePos = te.func_174877_v();
        double distance = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_()).func_186679_c((double)tePos.func_177958_n(), (double)tePos.func_177956_o(), (double)tePos.func_177952_p());
        if (distance <= 196.0) {
            float yaw = rendererDispatcher.field_217666_g.func_216778_f();
            float pitch = rendererDispatcher.field_217666_g.func_216777_e();
            FontRenderer font = rendererDispatcher.func_147548_a();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(xOffset, yOffset, zOffset);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-yaw));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
            matrixStack.func_227862_a_(-0.015f + scaleModifier, -0.015f + scaleModifier, 0.015f + scaleModifier);
            font.func_228079_a_(str, (float)(-font.func_78256_a(str) / 2), 0.0f, 1, false, matrixStack.func_227866_c_().func_227870_a_(), buffer, false, 0, 0);
            matrixStack.func_227865_b_();
        }
    }
}

