/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.trap;

import com.teammetallurgy.atum.blocks.trap.tileentity.TrapTileEntity;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;

@Mod.EventBusSubscriber(modid="atum")
public abstract class TrapBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    private static final BooleanProperty DISABLED = BooleanProperty.func_177716_a((String)"disabled");

    protected TrapBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151658_d).func_200943_b(1.5f).harvestTool(ToolType.PICKAXE).harvestLevel(0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)DISABLED, (Comparable)Boolean.FALSE));
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        TileEntity tileEntity;
        BlockState state = event.getState();
        if (state.func_177230_c() instanceof TrapBlock && (tileEntity = event.getWorld().func_175625_s(event.getPos())) instanceof TrapTileEntity && ((TrapTileEntity)tileEntity).isInsidePyramid && !event.getPlayer().func_184812_l_()) {
            event.setCanceled(true);
        }
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity instanceof TrapTileEntity && ((TrapTileEntity)tileEntity).isInsidePyramid ? 6000000.0f : super.getExplosionResistance(state, world, pos, explosion);
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, @Nonnull Hand hand, @Nonnull BlockRayTraceResult rayTraceResult) {
        boolean isToolEffective;
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        boolean bl = isToolEffective = ForgeHooks.isToolEffective((IWorldReader)world, (BlockPos)pos, (ItemStack)player.func_184586_b(Hand.MAIN_HAND)) || ForgeHooks.isToolEffective((IWorldReader)world, (BlockPos)pos, (ItemStack)player.func_184586_b(Hand.OFF_HAND));
        if (tileEntity instanceof TrapTileEntity) {
            TrapTileEntity trap = (TrapTileEntity)tileEntity;
            if (!trap.isInsidePyramid) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)trap, (BlockPos)pos);
                return ActionResultType.SUCCESS;
            }
            if (trap.isInsidePyramid && isToolEffective && !((Boolean)state.func_177229_b((Property)DISABLED)).booleanValue()) {
                this.setDisabled(world, pos, state, (TrapTileEntity)tileEntity, true);
                world.func_184133_a(null, pos, SoundEvents.field_187576_at, SoundCategory.BLOCKS, 1.1f, 1.5f);
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    public void func_220069_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TrapTileEntity && !((TrapTileEntity)tileEntity).isInsidePyramid) {
            if (world.func_175640_z(pos)) {
                this.setDisabled(world, pos, state, (TrapTileEntity)tileEntity, true);
            } else if (!world.func_175640_z(pos)) {
                world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            }
        }
    }

    public void func_225534_a_(@Nonnull BlockState state, ServerWorld world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TrapTileEntity && !((TrapTileEntity)tileEntity).isInsidePyramid && !world.func_175640_z(pos)) {
            this.setDisabled((World)world, pos, state, (TrapTileEntity)tileEntity, false);
        }
    }

    private void setDisabled(World world, BlockPos pos, BlockState state, TrapTileEntity trap, boolean disabledStatus) {
        trap.setDisabledStatus(disabledStatus);
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)DISABLED, (Comparable)Boolean.valueOf(disabledStatus)));
        world.func_184138_a(pos, state, state, 3);
    }

    @Nonnull
    public BlockRenderType func_149645_b(@Nonnull BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public void func_180633_a(World world, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TrapTileEntity) {
            ((TrapTileEntity)tileentity).isInsidePyramid = false;
            if (stack.func_82837_s()) {
                ((TrapTileEntity)tileentity).func_213903_a(stack.func_200301_q());
            }
        }
    }

    public void func_196243_a(@Nonnull BlockState state, World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() != state.func_177230_c()) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TrapTileEntity) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileEntity));
                world.func_175666_e(pos, (Block)this);
            }
            world.func_175713_t(pos);
        }
    }

    public boolean func_149744_f(@Nonnull BlockState state) {
        return true;
    }

    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    public int func_180641_l(@Nonnull BlockState blockState, World world, @Nonnull BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Nonnull
    public BlockState func_185471_a(@Nonnull BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> container) {
        container.func_206894_a(new Property[]{FACING, DISABLED});
    }
}

