/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.stone.limestone.chest.tileentity;

import com.teammetallurgy.atum.api.God;
import com.teammetallurgy.atum.blocks.base.tileentity.ChestBaseTileEntity;
import com.teammetallurgy.atum.blocks.stone.limestone.chest.SarcophagusBlock;
import com.teammetallurgy.atum.entity.undead.PharaohEntity;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumSounds;
import com.teammetallurgy.atum.init.AtumTileEntities;
import com.teammetallurgy.atum.network.NetworkHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class SarcophagusTileEntity
extends ChestBaseTileEntity {
    public static final String SARCOPHAGUS_CONTAINER = "atum.container.sarcophagus";
    public boolean hasSpawned;
    public boolean isOpenable;

    public SarcophagusTileEntity() {
        super(AtumTileEntities.SARCOPHAGUS, false, true, AtumBlocks.SARCOPHAGUS);
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return new TranslationTextComponent(SARCOPHAGUS_CONTAINER);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager manager, SUpdateTileEntityPacket packet) {
        super.onDataPacket(manager, packet);
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.hasSpawned = compound.func_74767_n("spawned");
        this.isOpenable = compound.func_74767_n("openable");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74757_a("spawned", this.hasSpawned);
        compound.func_74757_a("openable", this.isOpenable);
        return compound;
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        return this.isOpenable && super.func_70300_a(player);
    }

    public void setOpenable() {
        this.isOpenable = true;
        this.func_70296_d();
        if (this.field_145850_b instanceof ServerWorld) {
            SUpdateTileEntityPacket packet = this.func_189518_D_();
            NetworkHandler.sendToTracking((ServerWorld)this.field_145850_b, this.field_174879_c, packet, false);
        }
    }

    public void spawn(PlayerEntity player, DifficultyInstance difficulty, @Nullable God god) {
        PharaohEntity pharaoh;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && (pharaoh = (PharaohEntity)AtumEntities.PHARAOH.func_200721_a(this.field_145850_b)) != null) {
            pharaoh.setDropsGodSpecificLoot(god != null);
            pharaoh.func_213386_a((IServerWorld)this.field_145850_b, difficulty, god == null ? SpawnReason.TRIGGERED : SpawnReason.CONVERSION, null, null);
            if (god != null) {
                pharaoh.setVariantWithAbilities(god.ordinal(), difficulty);
            }
            Direction blockFacing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)SarcophagusBlock.field_176459_a);
            pharaoh.func_70012_b(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p(), blockFacing.func_185119_l() + 90.0f, 0.0f);
            pharaoh.field_70759_as = blockFacing.func_185119_l() + 90.0f;
            pharaoh.setSarcophagusPos(this.field_174879_c);
            this.field_145850_b.func_217376_c((Entity)pharaoh);
            pharaoh.spawnGuards(pharaoh.func_233580_cy_().func_177967_a(blockFacing, 2).func_177977_b());
            pharaoh.func_70656_aK();
            if (this.field_145850_b instanceof ServerWorld) {
                ServerWorld serverWorld = (ServerWorld)this.field_145850_b;
                God godVariant = God.getGod(pharaoh.getVariant());
                Style pharaohStyle = pharaoh.func_200200_C_().func_150256_b();
                for (ServerPlayerEntity playerMP : serverWorld.func_73046_m().func_184103_al().func_181057_v()) {
                    playerMP.func_145747_a((ITextComponent)pharaoh.func_200200_C_().func_230532_e_().func_230530_a_(pharaohStyle.func_240718_a_(godVariant.getColor())).func_230529_a_((ITextComponent)new TranslationTextComponent("chat.atum.pharaoh_worshiper").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)godVariant.getDisplayName().func_230530_a_(pharaohStyle.func_240718_a_(godVariant.getColor()))).func_230529_a_((ITextComponent)new TranslationTextComponent("chat.atum.pharaoh_awakened").func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)player.func_200200_C_().func_230532_e_().func_240699_a_(TextFormatting.YELLOW)), Util.field_240973_b_);
                }
            }
        }
        this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), AtumSounds.PHARAOH_SPAWN, SoundCategory.HOSTILE, 0.8f, 1.0f, true);
        for (Direction horizontal : Direction.Plane.HORIZONTAL) {
            TileEntity tileEntityOffset = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(horizontal));
            if (!(tileEntityOffset instanceof SarcophagusTileEntity)) continue;
            ((SarcophagusTileEntity)tileEntityOffset).hasSpawned = true;
        }
        this.hasSpawned = true;
    }

    protected void func_195483_a(@Nonnull SoundEvent sound) {
        ChestType chestType = (ChestType)this.func_195044_w().func_177229_b((Property)ChestBlock.field_196314_b);
        if (chestType != ChestType.LEFT) {
            double x = (double)this.field_174879_c.func_177958_n() + 0.5;
            double y = (double)this.field_174879_c.func_177956_o() + 0.5;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (chestType == ChestType.RIGHT) {
                Direction direction = ChestBlock.func_196311_i((BlockState)this.func_195044_w());
                x += (double)direction.func_82601_c() * 0.5;
                z += (double)direction.func_82599_e() * 0.5;
            }
            this.field_145850_b.func_184148_a(null, x, y, z, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.05f);
        }
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return this.isOpenable && super.func_94041_b(index, stack);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return this.isOpenable ? super.func_70298_a(index, count) : ItemStack.field_190927_a;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nonnull Direction direction) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.isOpenable ? super.getCapability(capability, direction) : LazyOptional.empty();
        }
        return super.getCapability(capability, direction);
    }
}

